/* tinybind: https://github.com/blikblum/tinybind/blob/master/dist/tinybind.min.js */
// And we crossed the "component" feature from https://github.com/ribajs/riba/tree/96ae495e0530c41a8d8980d4a2671ba2b49576e6
// so this is a custom mix of both libraries. Do not update!

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
            (global = global || self, global.tinybind = factory());
}(this, function () { 'use strict';

    var OPTIONS = ['prefix', 'templateDelimiters', 'rootInterface', 'preloadData', 'handler'];
    var EXTENSIONS = ['binders', 'formatters', 'adapters','components'];

    var PRIMITIVE = 0;
    var KEYPATH = 1;
    var TEXT = 0;
    var BINDING = 1;
    var QUOTED_STR = /^'.*'$|^".*"$/; // Parser and tokenizer for getting the type and value from a string.

    function parseType(string) {
        var type = PRIMITIVE;
        var value = string;

        if (QUOTED_STR.test(string)) {
            value = string.slice(1, -1);
        } else if (string === 'true') {
            value = true;
        } else if (string === 'false') {
            value = false;
        } else if (string === 'null') {
            value = null;
        } else if (string === 'undefined') {
            value = undefined;
        } else if (!isNaN(string)) {
            value = Number(string);
        } else {
            type = KEYPATH;
        }

        return {
            type: type,
            value: value
        };
    } // Template parser and tokenizer for mustache-style text content bindings.
    // Parses the template and returns a set of tokens, separating static portions
    // of text from binding declarations.

    function parseTemplate(template, delimiters) {
        var tokens;
        var length = template.length;
        var index = 0;
        var lastIndex = 0;
        var open = delimiters[0],
            close = delimiters[1];

        while (lastIndex < length) {
            index = template.indexOf(open, lastIndex);

            if (index < 0) {
                if (tokens) {
                    tokens.push({
                        type: TEXT,
                        value: template.slice(lastIndex)
                    });
                }

                break;
            } else {
                tokens || (tokens = []);

                if (index > 0 && lastIndex < index) {
                    tokens.push({
                        type: TEXT,
                        value: template.slice(lastIndex, index)
                    });
                }

                lastIndex = index + open.length;
                index = template.indexOf(close, lastIndex);

                if (index < 0) {
                    var substring = template.slice(lastIndex - close.length);
                    var lastToken = tokens[tokens.length - 1];

                    if (lastToken && lastToken.type === TEXT) {
                        lastToken.value += substring;
                    } else {
                        tokens.push({
                            type: TEXT,
                            value: substring
                        });
                    }

                    break;
                }

                var value = template.slice(lastIndex, index).trim();
                tokens.push({
                    type: BINDING,
                    value: value
                });
                lastIndex = index + close.length;
            }
        }

        return tokens;
    }

    var tinybind = {
        // Global binders.
        binders: {},
        // Global formatters.
        formatters: {},
        // Global sightglass adapters.
        adapters: {},
        // Global components.
        components: {},
        // Default attribute prefix.
        _prefix: 'rv',
        _fullPrefix: 'rv-',

        get prefix() {
            return this._prefix;
        },

        set prefix(value) {
            this._prefix = value;
            this._fullPrefix = value + '-';
        },

        parseTemplate: parseTemplate,
        parseType: parseType,
        // Default template delimiters.
        templateDelimiters: ['{', '}'],
        // Default sightglass root interface.
        rootInterface: '.',
        // Preload data by default.
        preloadData: true,
        // Default event handler.
        handler: function handler(context, ev, binding) {
            this.call(context, ev, binding.view.models);
        },
        // Sets the attribute on the element. If no binder above is matched it will fall
        // back to using this binder.
        fallbackBinder: function fallbackBinder(el, value) {
            if (value != null) {
                el.setAttribute(this.type, value);
            } else {
                el.removeAttribute(this.type);
            }
        },
        // Merges an object literal into the corresponding global options.
        configure: function configure(options) {
            var _this = this;

            if (!options) {
                return;
            }

            Object.keys(options).forEach(function (option) {
                var value = options[option];

                if (EXTENSIONS.indexOf(option) > -1) {
                    Object.keys(value).forEach(function (key) {
                        _this[option][key] = value[key];
                    });
                } else {
                    _this[option] = value;
                }
            });
        }
    };

    // Check if a value is an object than can be observed.
    function isObject(obj) {
        return typeof obj === 'object' && obj !== null;
    } // Error thrower.


    function error(message) {
        throw new Error("[Observer] " + message);
    }

    var adapters;
    var interfaces;
    var rootInterface; // Constructs a new keypath observer and kicks things off.

    var Observer =
        /*#__PURE__*/
        function () {
            Observer.updateOptions = function updateOptions(options) {
                adapters = options.adapters;
                interfaces = Object.keys(adapters);
                rootInterface = options.rootInterface;
            } // Tokenizes the provided keypath string into interface + path tokens for the
            // observer to work with.
            ;

            Observer.tokenize = function tokenize(keypath, root) {
                var tokens = [];
                var current = {
                    i: root,
                    path: ''
                };
                var index;
                var chr;

                for (index = 0; index < keypath.length; index++) {
                    chr = keypath.charAt(index);

                    if (!!~interfaces.indexOf(chr)) {
                        tokens.push(current);
                        current = {
                            i: chr,
                            path: ''
                        };
                    } else {
                        current.path += chr;
                    }
                }

                tokens.push(current);
                return tokens;
            };

            function Observer(obj, keypath, callback) {
                this.keypath = keypath;
                this.callback = callback;
                this.objectPath = [];
                this.parse();
                this.obj = this.getRootObject(obj);

                if (isObject(this.target = this.realize())) {
                    this.set(true, this.key, this.target, this.callback);
                }
            } // Parses the keypath using the interfaces defined on the view. Sets variables
            // for the tokenized keypath as well as the end key.


            var _proto = Observer.prototype;

            _proto.parse = function parse() {
                var path;
                var root;

                if (!interfaces.length) {
                    error('Must define at least one adapter interface.');
                }

                if (!!~interfaces.indexOf(this.keypath[0])) {
                    root = this.keypath[0];
                    path = this.keypath.substr(1);
                } else {
                    root = rootInterface;
                    path = this.keypath;
                }

                this.tokens = Observer.tokenize(path, root);
                this.key = this.tokens.pop();
            } // Realizes the full keypath, attaching observers for every key and correcting
            // old observers to any changed objects in the keypath.
            ;

            _proto.realize = function realize() {
                var current = this.obj;
                var unreached = -1;
                var prev;
                var token;

                for (var index = 0; index < this.tokens.length; index++) {
                    token = this.tokens[index];

                    if (isObject(current)) {
                        if (typeof this.objectPath[index] !== 'undefined') {
                            if (current !== (prev = this.objectPath[index])) {
                                this.set(false, token, prev, this);
                                this.set(true, token, current, this);
                                this.objectPath[index] = current;
                            }
                        } else {
                            this.set(true, token, current, this);
                            this.objectPath[index] = current;
                        }

                        current = this.get(token, current);
                    } else {
                        if (unreached === -1) {
                            unreached = index;
                        }

                        if (prev = this.objectPath[index]) {
                            this.set(false, token, prev, this);
                        }
                    }
                }

                if (unreached !== -1) {
                    this.objectPath.splice(unreached);
                }

                return current;
            } // Updates the keypath. This is called when any intermediary key is changed.
            ;

            _proto.sync = function sync() {
                var next;
                var oldValue;
                var newValue;

                if ((next = this.realize()) !== this.target) {
                    if (isObject(this.target)) {
                        this.set(false, this.key, this.target, this.callback);
                    }

                    if (isObject(next)) {
                        this.set(true, this.key, next, this.callback);
                    }

                    oldValue = this.value();
                    this.target = next;
                    newValue = this.value();
                    if (newValue !== oldValue || newValue instanceof Function) this.callback.sync();
                } else if (next instanceof Array) {
                    this.callback.sync();
                }
            } // Reads the current end value of the observed keypath. Returns undefined if
            // the full keypath is unreachable.
            ;

            _proto.value = function value() {
                if (isObject(this.target)) {
                    return this.get(this.key, this.target);
                }
            } // Sets the current end value of the observed keypath. Calling setValue when
            // the full keypath is unreachable is a no-op.
            ;

            _proto.setValue = function setValue(value) {
                if (isObject(this.target)) {
                    adapters[this.key.i].set(this.target, this.key.path, value);
                }
            } // Gets the provided key on an object.
            ;

            _proto.get = function get(key, obj) {
                return adapters[key.i].get(obj, key.path);
            } // Observes or unobserves a callback on the object using the provided key.
            ;

            _proto.set = function set(active, key, obj, callback) {
                var action = active ? 'observe' : 'unobserve';
                adapters[key.i][action](obj, key.path, callback);
            } // Unobserves the entire keypath.
            ;

            _proto.unobserve = function unobserve() {
                var obj;
                var token;

                for (var index = 0; index < this.tokens.length; index++) {
                    token = this.tokens[index];

                    if (obj = this.objectPath[index]) {
                        this.set(false, token, obj, this);
                    }
                }

                if (isObject(this.target)) {
                    this.set(false, this.key, this.target, this.callback);
                }
            } // traverse the scope chain to find the scope which has the root property
            // if the property is not found in chain, returns the root scope
            ;

            _proto.getRootObject = function getRootObject(obj) {
                var rootProp;
                var current;

                if (!obj.$parent) {
                    return obj;
                }

                if (this.tokens.length) {
                    rootProp = this.tokens[0].path;
                } else {
                    rootProp = this.key.path;
                }

                current = obj;

                while (current.$parent && current[rootProp] === undefined) {
                    current = current.$parent;
                }

                return current;
            };

            return Observer;
        }();

    function getInputValue(el) {
        if (el.type === 'checkbox') {
            return el.checked;
        } else if (el.type === 'select-multiple') {
            var results = [];
            var option;

            for (var i = 0; i < el.options.length; i++) {
                option = el.options[i];

                if (option.selected) {
                    results.push(option.value);
                }
            }

            return results;
        } else {
            return el.value;
        }
    }

    var FORMATTER_ARGS = /[^\s']+|'([^']|'[^\s])*'|"([^"]|"[^\s])*"/g;
    var FORMATTER_SPLIT = /\s+/; // A single binding between a model attribute and a DOM element.

    var Binding =
        /*#__PURE__*/
        function () {
            // All information about the binding is passed into the constructor; the
            // containing view, the DOM node, the type of binding, the model object and the
            // keypath at which to listen for changes.
            function Binding(view, el, type, keypath, binder, arg, formatters) {
                this.view = view;
                this.el = el;
                this.type = type;
                this.keypath = keypath;
                this.binder = binder;
                this.arg = arg;
                this.formatters = formatters;
                this.formatterObservers = {};
                this.model = undefined;
            } // Observes the object keypath


            var _proto = Binding.prototype;

            _proto.observe = function observe(obj, keypath) {
                return new Observer(obj, keypath, this);
            };

            _proto.parseTarget = function parseTarget() {
                if (this.keypath) {
                    var token = parseType(this.keypath);

                    if (token.type === 0) {
                        this.value = token.value;
                    } else {
                        this.observer = this.observe(this.view.models, this.keypath);
                        this.model = this.observer.target;
                    }
                } else {
                    this.value = undefined;
                }
            };

            _proto.parseFormatterArguments = function parseFormatterArguments(args, formatterIndex) {
                var _this = this;

                return args.map(parseType).map(function (_ref, ai) {
                    var type = _ref.type,
                        value = _ref.value;

                    if (type === 0) {
                        return value;
                    } else {
                        if (!_this.formatterObservers[formatterIndex]) {
                            _this.formatterObservers[formatterIndex] = {};
                        }

                        var observer = _this.formatterObservers[formatterIndex][ai];

                        if (!observer) {
                            observer = _this.observe(_this.view.models, value);
                            _this.formatterObservers[formatterIndex][ai] = observer;
                        }

                        return observer.value();
                    }
                });
            } // Applies all the current formatters to the supplied value and returns the
            // formatted value.
            ;

            _proto.formattedValue = function formattedValue(value) {
                var _this2 = this;

                return this.formatters.reduce(function (result, declaration, index) {
                    var args = declaration.match(FORMATTER_ARGS);
                    var id = args.shift();
                    var formatter = _this2.view.options.formatters[id];

                    var processedArgs = _this2.parseFormatterArguments(args, index);

                    if (formatter && formatter.read instanceof Function) {
                        result = formatter.read.apply(formatter, [result].concat(processedArgs));
                    } else if (formatter instanceof Function) {
                        result = formatter.apply(void 0, [result].concat(processedArgs));
                    }

                    return result;
                }, value);
            } // Returns an event handler for the binding around the supplied function.
            ;

            _proto.eventHandler = function eventHandler(fn) {
                var binding = this;
                var handler = binding.view.options.handler;
                return function (ev) {
                    handler.call(fn, this, ev, binding);
                };
            } // Sets the value for the binding. This Basically just runs the binding routine
            // with the supplied value formatted.
            ;

            _proto.set = function set(value) {
                if (value instanceof Function && !this.binder.function) {
                    value = this.formattedValue(value.call(this.model));
                } else {
                    value = this.formattedValue(value);
                }

                var routineFn = this.binder.routine || this.binder;

                if (routineFn instanceof Function) {
                    routineFn.call(this, this.el, value);
                }
            } // Syncs up the view binding with the model.
            ;

            _proto.sync = function sync() {
                if (this.observer) {
                    this.model = this.observer.target;
                    this.set(this.observer.value());
                } else {
                    this.set(this.value);
                }
            } // Publishes the value currently set on the input element back to the model.
            ;

            _proto.publish = function publish() {
                var _this3 = this;

                if (this.observer) {
                    var value = this.formatters.reduceRight(function (result, declaration, index) {
                        var args = declaration.split(FORMATTER_SPLIT);
                        var id = args.shift();
                        var formatter = _this3.view.options.formatters[id];

                        var processedArgs = _this3.parseFormatterArguments(args, index);

                        if (formatter && formatter.publish) {
                            result = formatter.publish.apply(formatter, [result].concat(processedArgs));
                        }

                        return result;
                    }, this.getValue(this.el));
                    this.observer.setValue(value);
                }
            } // Subscribes to the model for changes at the specified keypath. Bi-directional
            // routines will also listen for changes on the element to propagate them back
            // to the model.
            ;

            _proto.bind = function bind() {
                this.parseTarget();

                if (this.binder.hasOwnProperty('bind')) {
                    this.binder.bind.call(this, this.el);
                }

                if (this.view.options.preloadData) {
                    this.sync();
                }
            } // Unsubscribes from the model and the element.
            ;

            _proto.unbind = function unbind() {
                var _this4 = this;

                if (this.binder.unbind) {
                    this.binder.unbind.call(this, this.el);
                }

                if (this.observer) {
                    this.observer.unobserve();
                }

                Object.keys(this.formatterObservers).forEach(function (fi) {
                    var args = _this4.formatterObservers[fi];
                    Object.keys(args).forEach(function (ai) {
                        args[ai].unobserve();
                    });
                });
                this.formatterObservers = {};
            } // Updates the binding's model from what is currently set on the view. Unbinds
            // the old model first and then re-binds with the new model.
            ;

            _proto.update = function update(models) {
                if (models === void 0) {
                    models = {};
                }

                if (this.observer) {
                    this.model = this.observer.target;
                }

                if (this.binder.update) {
                    this.binder.update.call(this, models);
                }
            } // Returns elements value
            ;

            _proto.getValue = function getValue(el) {
                if (this.binder && this.binder.getValue) {
                    return this.binder.getValue.call(this, el);
                } else {
                    return getInputValue(el);
                }
            };

            return Binding;
        }();

    var PRIMITIVE$2 = 0;
    var KEYPATH$2 = 1;

    // component view encapsulated as a binding within it's parent view.
    var ComponentBinding = function (_Binding) {

        // Initializes a component binding for the specified view. The raw component
        // element is passed in along with the component type. Attributes and scope
        // inflections are determined based on the components defined attributes.
        function ComponentBinding(view, el, type) {
            classCallCheck(this, ComponentBinding);

            var _this = possibleConstructorReturn(this, _Binding.call(this, view, el, type, null, null, null, null));

            _this.view = view;
            _this.el = el;
            _this.type = type;
            _this.component = view.options.components[_this.type];
            _this.static = {};
            _this.observers = {};
            _this.upstreamObservers = {};

            var bindingPrefix = tinybind._fullPrefix;

            // parse component attributes
            for (var i = 0, len = el.attributes.length; i < len; i++) {
                var attribute = el.attributes[i];

                // if attribute starts not with binding prefix. E.g. rv-
                if (attribute.name.indexOf(bindingPrefix) !== 0) {
                    var propertyName = _this.camelCase(attribute.name);
                    var token = parseType(attribute.value);
                    var stat = _this.component.static;

                    if (stat && stat.indexOf(propertyName) > -1) {
                        _this.static[propertyName] = attribute.value;
                    } else if (token.type === PRIMITIVE$2) {
                        _this.static[propertyName] = token.value;
                    } else if (token.type === KEYPATH$2) {
                        _this.observers[propertyName] = attribute.value;
                    } else {
                        throw new Error('can\'t parse component attribute', attribute, token);
                    }
                }
            }
            return _this;
        }

        // Intercepts `tinybind.Binding::sync` since component bindings are not bound to
        // a particular model to update it's value.


        ComponentBinding.prototype.sync = function sync() {};

        // Intercepts `tinybind.Binding::update` since component bindings are not bound
        // to a particular model to update it's value.


        ComponentBinding.prototype.update = function update() {};

        // Intercepts `tinybind.Binding::publish` since component bindings are not bound
        // to a particular model to update it's value.


        ComponentBinding.prototype.publish = function publish() {};

        // Returns an object map using the component's scope inflections.


        ComponentBinding.prototype.locals = function locals() {
            var _this2 = this;

            var result = {};

            Object.keys(this.static).forEach(function (key) {
                result[key] = _this2.static[key];
            });

            Object.keys(this.observers).forEach(function (key) {
                result[key] = _this2.observers[key].value();
            });

            return result;
        };

        // Returns a camel-cased version of the string. Used when translating an
        // element's attribute name into a property name for the component's scope.


        ComponentBinding.prototype.camelCase = function camelCase(string) {
            return string.replace(/-([a-z])/g, function (grouped) {
                return grouped[1].toUpperCase();
            });
        };

        // Intercepts `tinybind.Binding::bind` to build `@componentView` with a localized
        // map of models from the root view. Bind `@componentView` on subsequent calls.


        ComponentBinding.prototype.bind = function bind() {
            var _this3 = this;

            var options = {};
            if (!this.bound) {
                Object.keys(this.observers).forEach(function (key) {
                    var keypath = _this3.observers[key];

                    _this3.observers[key] = _this3.observe(_this3.view.models, keypath, function (key) {
                        return function () {
                            _this3.componentView.models[key] = _this3.observers[key].value();
                        };
                    }.call(_this3, key));
                });

                this.bound = true;
            }

            if (this.componentView) {
                this.componentView.bind();
            } else {
                this.el.innerHTML = this.component.template.call(this);
                var scope = this.component.initialize.call(this, this.el, this.locals());
                this.el._bound = true;

                EXTENSIONS.forEach(function (extensionType) {
                    options[extensionType] = {};

                    if (_this3.component[extensionType]) {
                        Object.keys(_this3.component[extensionType]).forEach(function (key) {
                            options[extensionType][key] = _this3.component[extensionType][key];
                        });
                    }

                    Object.keys(_this3.view.options[extensionType]).forEach(function (key) {
                        if (options[extensionType][key]) {
                            options[extensionType][key] = _this3.view[extensionType][key];
                        }
                    });
                });

                OPTIONS.forEach(function (option) {
                    if (_this3.component[option] != null) {
                        options[option] = _this3.component[option];
                    } else {
                        options[option] = _this3.view[option];
                    }
                });

                //there's a cyclic dependency that makes imported View a dummy object. Use tinybind.bind
                //this.componentView = new View(this.el, scope, options)
                //this.componentView.bind()
                this.componentView = tinybind.bind(Array.prototype.slice.call(this.el.childNodes), scope, options);

                Object.keys(this.observers).forEach(function (key) {
                    var observer = _this3.observers[key];
                    var models = _this3.componentView.models;

                    var upstream = _this3.observe(models, key, function (key, observer) {
                        return function () {
                            observer.setValue(_this3.componentView.models[key]);
                        };
                    }.call(_this3, key, observer));

                    _this3.upstreamObservers[key] = upstream;
                });
            }
        };

        // Intercept `tinybind.Binding::unbind` to be called on `@componentView`.


        ComponentBinding.prototype.unbind = function unbind() {
            var _this4 = this;

            Object.keys(this.upstreamObservers).forEach(function (key) {
                _this4.upstreamObservers[key].unobserve();
            });

            Object.keys(this.observers).forEach(function (key) {
                _this4.observers[key].unobserve();
            });

            if (this.componentView) {
                this.componentView.unbind.call(this);
            }
        };

        return ComponentBinding;
    }(Binding);

    var textBinder = {
        routine: function routine(node, value) {
            node.data = value != null ? value : '';
        }
    };
    var DECLARATION_SPLIT = /((?:'[^']*')*(?:(?:[^\|']*(?:'[^']*')+[^\|']*)+|[^\|]+))|^$/g;

    var parseNode = function parseNode(view, node) {
        var block = false;

        if (node.nodeType === 3) {
            var tokens = parseTemplate(node.data, tinybind.templateDelimiters);

            if (tokens) {
                for (var i = 0; i < tokens.length; i++) {
                    var token = tokens[i];
                    var text = document.createTextNode(token.value);
                    node.parentNode.insertBefore(text, node);

                    if (token.type === 1) {
                        view.buildBinding(text, null, token.value, textBinder, null);
                    }
                }

                node.parentNode.removeChild(node);
            }

            block = true;
        } else if (node.nodeType === 1) {
            block = view.traverse(node);
        }

        if (!block) {
            for (var _i = 0; _i < node.childNodes.length; _i++) {
                parseNode(view, node.childNodes[_i]);
            }
        }
    };

    var bindingComparator = function bindingComparator(a, b) {
        var aPriority = a.binder ? a.binder.priority || 0 : 0;
        var bPriority = b.binder ? b.binder.priority || 0 : 0;
        return bPriority - aPriority;
    };

    var trimStr = function trimStr(str) {
        return str.trim();
    }; // A collection of bindings built from a set of parent nodes.


    var View =
        /*#__PURE__*/
        function () {
            // The DOM elements and the model objects for binding are passed into the
            // constructor along with any local options that should be used throughout the
            // context of the view and it's bindings.
            function View(els, models, options) {
                if (els.jquery || els instanceof Array) {
                    this.els = els;
                } else {
                    this.els = [els];
                }

                this.models = models;
                this.options = options;
                this.build();
            }

            var _proto = View.prototype;

            _proto.buildBinding = function buildBinding(node, type, declaration, binder, arg) {
                var pipes = declaration.match(DECLARATION_SPLIT).map(trimStr);
                var keypath = pipes.shift();
                this.bindings.push(new Binding(this, node, type, keypath, binder, arg, pipes));
            } // Parses the DOM tree and builds `Binding` instances for every matched
            // binding declaration.
            ;

            _proto.build = function build() {
                this.bindings = [];
                var elements = this.els,
                    i,
                    len;

                for (i = 0, len = elements.length; i < len; i++) {
                    parseNode(this, elements[i]);
                }

                this.bindings.sort(bindingComparator);
            };

            _proto.traverse = function traverse(node) {
                var bindingPrefix = tinybind._fullPrefix;
                var block = node.nodeName === 'SCRIPT' || node.nodeName === 'STYLE';
                var attributes = node.attributes;
                var bindInfos = [];
                var starBinders = this.options.starBinders;
                var type, binder, identifier, arg;

                for (var i = 0, len = attributes.length; i < len; i++) {
                    var attribute = attributes[i];

                    if (attribute.name.indexOf(bindingPrefix) === 0) {
                        type = attribute.name.slice(bindingPrefix.length);
                        binder = this.options.binders[type];
                        arg = undefined;

                        if (!binder) {
                            for (var k = 0; k < starBinders.length; k++) {
                                identifier = starBinders[k];

                                if (type.slice(0, identifier.length - 1) === identifier.slice(0, -1)) {
                                    binder = this.options.binders[identifier];
                                    arg = type.slice(identifier.length - 1);
                                    break;
                                }
                            }
                        }

                        if (!binder) {
                            binder = tinybind.fallbackBinder;
                        }

                        if (binder.block) {
                            this.buildBinding(node, type, attribute.value, binder, arg);
                            node.removeAttribute(attribute.name);
                            return true;
                        }

                        bindInfos.push({
                            attr: attribute,
                            binder: binder,
                            type: type,
                            arg: arg
                        });
                    }
                }

                for (var _i2 = 0; _i2 < bindInfos.length; _i2++) {
                    var bindInfo = bindInfos[_i2];
                    this.buildBinding(node, bindInfo.type, bindInfo.attr.value, bindInfo.binder, bindInfo.arg);
                    node.removeAttribute(bindInfo.attr.name);
                }

                return block;
            } // Binds all of the current bindings for this view.
            ;

            _proto.bind = function bind() {
                this.bindings.forEach(function (binding) {
                    binding.bind();
                });
            } // Unbinds all of the current bindings for this view.
            ;

            _proto.unbind = function unbind() {
                this.bindings.forEach(function (binding) {
                    binding.unbind();
                });
            } // Syncs up the view with the model by running the routines on all bindings.
            ;

            _proto.sync = function sync() {
                this.bindings.forEach(function (binding) {
                    binding.sync();
                });
            } // Publishes the input values from the view back to the model (reverse sync).
            ;

            _proto.publish = function publish() {
                this.bindings.forEach(function (binding) {
                    if (binding.binder && binding.binder.publishes) {
                        binding.publish();
                    }
                });
            } // Updates the view's models along with any affected bindings.
            ;

            _proto.update = function update(models) {
                var _this = this;

                if (models === void 0) {
                    models = {};
                }

                Object.keys(models).forEach(function (key) {
                    _this.models[key] = models[key];
                });
                this.bindings.forEach(function (binding) {
                    if (binding.update) {
                        binding.update(models);
                    }
                });
            };

            return View;
        }();

    // The default `.` adapter that comes with tinybind.js. Allows subscribing to
    // properties on plain objects, implemented in ES5 natives using
    // `Object.defineProperty`.
    var ARRAY_METHODS = ['push', 'pop', 'shift', 'unshift', 'sort', 'reverse', 'splice'];
    var adapter = {
        counter: 0,
        weakmap: {},
        weakReference: function weakReference(obj) {
            if (!obj.hasOwnProperty('__rv')) {
                var id = this.counter++;
                Object.defineProperty(obj, '__rv', {
                    value: id
                });
            }

            if (!this.weakmap[obj.__rv]) {
                this.weakmap[obj.__rv] = {
                    callbacks: {}
                };
            }

            return this.weakmap[obj.__rv];
        },
        cleanupWeakReference: function cleanupWeakReference(data, refId) {
            if (!Object.keys(data.callbacks).length) {
                if (!(data.pointers && Object.keys(data.pointers).length)) {
                    delete this.weakmap[refId];
                }
            }
        },
        stubFunction: function stubFunction(obj, fn) {
            var original = obj[fn];
            var data = this.weakReference(obj);
            var weakmap = this.weakmap;

            obj[fn] = function () {
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                var response = original.apply(obj, args);
                Object.keys(data.pointers).forEach(function (refId) {
                    var k = data.pointers[refId];

                    if (weakmap[refId]) {
                        if (weakmap[refId].callbacks[k] instanceof Array) {
                            weakmap[refId].callbacks[k].forEach(function (callback) {
                                callback.sync();
                            });
                        }
                    }
                });
                return response;
            };
        },
        observeArray: function observeArray(value, refId, keypath) {
            var _this = this;

            if (value instanceof Array) {
                var data = this.weakReference(value);

                if (!data.pointers) {
                    data.pointers = {};
                    ARRAY_METHODS.forEach(function (fn) {
                        _this.stubFunction(value, fn);
                    });
                }

                if (!data.pointers[refId]) {
                    data.pointers[refId] = [];
                }

                if (data.pointers[refId].indexOf(keypath) === -1) {
                    data.pointers[refId].push(keypath);
                }
            }
        },
        unobserveArray: function unobserveArray(value, refId, keypath) {
            if (value instanceof Array && value.__rv != null) {
                var data = this.weakmap[value.__rv];

                if (data) {
                    var pointers = data.pointers[refId];

                    if (pointers) {
                        var idx = pointers.indexOf(keypath);

                        if (idx > -1) {
                            pointers.splice(idx, 1);
                        }

                        if (!pointers.length) {
                            delete data.pointers[refId];
                        }

                        this.cleanupWeakReference(data, value.__rv);
                    }
                }
            }
        },
        observe: function observe(obj, keypath, callback) {
            var _this2 = this;

            var value;
            var callbacks = this.weakReference(obj).callbacks;

            if (!callbacks[keypath]) {
                callbacks[keypath] = [];
                var desc = Object.getOwnPropertyDescriptor(obj, keypath);

                if (!desc || !(desc.get || desc.set || !desc.configurable)) {
                    value = obj[keypath];
                    Object.defineProperty(obj, keypath, {
                        enumerable: true,
                        get: function get() {
                            return value;
                        },
                        set: function set(newValue) {
                            if (newValue !== value) {
                                _this2.unobserveArray(value, obj.__rv, keypath);

                                value = newValue;
                                var data = _this2.weakmap[obj.__rv];

                                if (data) {
                                    var _callbacks = data.callbacks[keypath];

                                    if (_callbacks) {
                                        _callbacks.forEach(function (cb) {
                                            cb.sync();
                                        });
                                    }

                                    _this2.observeArray(newValue, obj.__rv, keypath);
                                }
                            }
                        }
                    });
                }
            }

            if (callbacks[keypath].indexOf(callback) === -1) {
                callbacks[keypath].push(callback);
            }

            this.observeArray(obj[keypath], obj.__rv, keypath);
        },
        unobserve: function unobserve(obj, keypath, callback) {
            var data = this.weakmap[obj.__rv];

            if (data) {
                var callbacks = data.callbacks[keypath];

                if (callbacks) {
                    var idx = callbacks.indexOf(callback);

                    if (idx > -1) {
                        callbacks.splice(idx, 1);

                        if (!callbacks.length) {
                            delete data.callbacks[keypath];
                            this.unobserveArray(obj[keypath], obj.__rv, keypath);
                        }
                    }

                    this.cleanupWeakReference(data, obj.__rv);
                }
            }
        },
        get: function get(obj, keypath) {
            return obj[keypath];
        },
        set: function set(obj, keypath, value) {
            obj[keypath] = value;
        }
    };

    var getString = function getString(value) {
        return value != null ? value.toString() : undefined;
    };

    var times = function times(n, cb) {
        for (var i = 0; i < n; i++) {
            cb();
        }
    };

    function createView(binding, data, anchorEl) {
        var template = binding.el.cloneNode(true);
        var view = new View(template, data, binding.view.options);
        view.bind();
        binding.marker.parentNode.insertBefore(template, anchorEl);
        return view;
    }

    var binders = {
        // Binds an event handler on the element.
        'on-*': {
            function: true,
            priority: 1000,
            unbind: function unbind(el) {
                if (this.handler) {
                    el.removeEventListener(this.arg, this.handler);
                }
            },
            routine: function routine(el, value) {
                if (this.handler) {
                    el.removeEventListener(this.arg, this.handler);
                }

                this.handler = this.eventHandler(value);
                el.addEventListener(this.arg, this.handler);
            }
        },
        // Appends bound instances of the element in place for each item in the array.
        'each-*': {
            block: true,
            priority: 4000,
            bind: function bind(el) {
                if (!this.marker) {
                    this.marker = document.createComment(" tinybind: " + this.type + " ");
                    this.iterated = [];
                    el.parentNode.insertBefore(this.marker, el);
                    el.parentNode.removeChild(el);
                } else {
                    this.iterated.forEach(function (view) {
                        view.bind();
                    });
                }
            },
            unbind: function unbind(el) {
                if (this.iterated) {
                    this.iterated.forEach(function (view) {
                        view.unbind();
                    });
                }
            },
            routine: function routine(el, collection) {
                var _this = this;

                var modelName = this.arg;
                collection = collection || [];
                var indexProp = el.getAttribute('index-property') || '$index';
                collection.forEach(function (model, index) {
                    var data = {
                        $parent: _this.view.models
                    };
                    data[indexProp] = index;
                    data[modelName] = model;
                    var view = _this.iterated[index];

                    if (!view) {
                        var previous = _this.marker;

                        if (_this.iterated.length) {
                            previous = _this.iterated[_this.iterated.length - 1].els[0];
                        }

                        view = createView(_this, data, previous.nextSibling);

                        _this.iterated.push(view);
                    } else {
                        if (view.models[modelName] !== model) {
                            // search for a view that matches the model
                            var matchIndex, nextView;

                            for (var nextIndex = index + 1; nextIndex < _this.iterated.length; nextIndex++) {
                                nextView = _this.iterated[nextIndex];

                                if (nextView.models[modelName] === model) {
                                    matchIndex = nextIndex;
                                    break;
                                }
                            }

                            if (matchIndex !== undefined) {
                                // model is in other position
                                // todo: consider avoiding the splice here by setting a flag
                                // profile performance before implementing such change
                                _this.iterated.splice(matchIndex, 1);

                                _this.marker.parentNode.insertBefore(nextView.els[0], view.els[0]);

                                nextView.models[indexProp] = index;
                            } else {
                                //new model
                                nextView = createView(_this, data, view.els[0]);
                            }

                            _this.iterated.splice(index, 0, nextView);
                        } else {
                            view.models[indexProp] = index;
                        }
                    }
                });

                if (this.iterated.length > collection.length) {
                    times(this.iterated.length - collection.length, function () {
                        var view = _this.iterated.pop();

                        view.unbind();

                        _this.marker.parentNode.removeChild(view.els[0]);
                    });
                }

                if (el.nodeName === 'OPTION') {
                    this.view.bindings.forEach(function (binding) {
                        if (binding.el === _this.marker.parentNode && binding.type === 'value') {
                            binding.sync();
                        }
                    });
                }
            },
            update: function update(models) {
                var _this2 = this;

                var data = {}; //todo: add test and fix if necessary

                Object.keys(models).forEach(function (key) {
                    if (key !== _this2.arg) {
                        data[key] = models[key];
                    }
                });
                this.iterated.forEach(function (view) {
                    view.update(data);
                });
            }
        },
        // Adds or removes the class from the element when value is true or false.
        'class-*': function _class(el, value) {
            var elClass = " " + el.className + " ";

            if (!value === elClass.indexOf(" " + this.arg + " ") > -1) {
                if (value) {
                    el.className = el.className + " " + this.arg;
                } else {
                    el.className = elClass.replace(" " + this.arg + " ", ' ').trim();
                }
            }
        },
        // Sets the element's text value.
        text: function text(el, value) {
            el.textContent = value != null ? value : '';
        },
        // Sets the element's HTML content.
        html: function html(el, value) {
            el.innerHTML = value != null ? value : '';
        },
        // Shows the element when value is true.
        show: function show(el, value) {
            el.style.display = value ? '' : 'none';
        },
        // Hides the element when value is true (negated version of `show` binder).
        hide: function hide(el, value) {
            el.style.display = value ? 'none' : '';
        },
        // Enables the element when value is true.
        enabled: function enabled(el, value) {
            el.disabled = !value;
        },
        // Disables the element when value is true (negated version of `enabled` binder).
        disabled: function disabled(el, value) {
            el.disabled = !!value;
        },
        // Checks a checkbox or radio input when the value is true. Also sets the model
        // property when the input is checked or unchecked (two-way binder).
        checked: {
            publishes: true,
            priority: 2000,
            bind: function bind(el) {
                var self = this;

                if (!this.callback) {
                    this.callback = function () {
                        self.publish();
                    };
                }

                el.addEventListener('change', this.callback);
            },
            unbind: function unbind(el) {
                el.removeEventListener('change', this.callback);
            },
            routine: function routine(el, value) {
                if (el.type === 'radio') {
                    el.checked = getString(el.value) === getString(value);
                } else {
                    el.checked = !!value;
                }
            }
        },
        // Sets the element's value. Also sets the model property when the input changes
        // (two-way binder).
        value: {
            publishes: true,
            priority: 3000,
            bind: function bind(el) {
                this.isRadio = el.tagName === 'INPUT' && el.type === 'radio';

                if (!this.isRadio) {
                    this.event = el.getAttribute('event-name') || (el.tagName === 'SELECT' ? 'change' : 'input');
                    var self = this;

                    if (!this.callback) {
                        this.callback = function () {
                            self.publish();
                        };
                    }

                    el.addEventListener(this.event, this.callback);
                }
            },
            unbind: function unbind(el) {
                if (!this.isRadio) {
                    el.removeEventListener(this.event, this.callback);
                }
            },
            routine: function routine(el, value) {
                if (this.isRadio) {
                    el.setAttribute('value', value);
                } else {
                    if (el.type === 'select-multiple') {
                        if (value instanceof Array) {
                            for (var i = 0; i < el.length; i++) {
                                var option = el[i];
                                option.selected = value.indexOf(option.value) > -1;
                            }
                        }
                    } else if (getString(value) !== getString(el.value)) {
                        el.value = value != null ? value : '';
                    }
                }
            }
        },
        // Inserts and binds the element and it's child nodes into the DOM when true.
        if: {
            block: true,
            priority: 4000,
            bind: function bind(el) {
                if (!this.marker) {
                    this.marker = document.createComment(' tinybind: ' + this.type + ' ' + this.keypath + ' ');
                    this.attached = false;
                    el.parentNode.insertBefore(this.marker, el);
                    el.parentNode.removeChild(el);
                } else if (this.bound === false && this.nested) {
                    this.nested.bind();
                }

                this.bound = true;
            },
            unbind: function unbind() {
                if (this.nested) {
                    this.nested.unbind();
                    this.bound = false;
                }
            },
            routine: function routine(el, value) {
                if (!!value !== this.attached) {
                    if (value) {
                        if (!this.nested) {
                            this.nested = new View(el, this.view.models, this.view.options);
                            this.nested.bind();
                        }

                        this.marker.parentNode.insertBefore(el, this.marker.nextSibling);
                        this.attached = true;
                    } else {
                        el.parentNode.removeChild(el);
                        this.attached = false;
                    }
                }
            },
            update: function update(models) {
                if (this.nested) {
                    this.nested.update(models);
                }
            }
        }
    };

    var formatters = {
        watch: function watch(value) {
            return value;
        },
        not: function not(value) {
            return !value;
        },
        negate: function negate(value) {
            return !value;
        }
    };

    function _defineProperties(target, props) {
        for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }

    function _createClass(Constructor, protoProps, staticProps) {
        if (protoProps) _defineProperties(Constructor.prototype, protoProps);
        if (staticProps) _defineProperties(Constructor, staticProps);
        return Constructor;
    }

    function _inheritsLoose(subClass, superClass) {
        subClass.prototype = Object.create(superClass.prototype);
        subClass.prototype.constructor = subClass;
        subClass.__proto__ = superClass;
    }

    function _getPrototypeOf(o) {
        _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
            return o.__proto__ || Object.getPrototypeOf(o);
        };
        return _getPrototypeOf(o);
    }

    function _setPrototypeOf(o, p) {
        _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
            o.__proto__ = p;
            return o;
        };

        return _setPrototypeOf(o, p);
    }

    function isNativeReflectConstruct() {
        if (typeof Reflect === "undefined" || !Reflect.construct) return false;
        if (Reflect.construct.sham) return false;
        if (typeof Proxy === "function") return true;

        try {
            Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
            return true;
        } catch (e) {
            return false;
        }
    }

    function _construct(Parent, args, Class) {
        if (isNativeReflectConstruct()) {
            _construct = Reflect.construct;
        } else {
            _construct = function _construct(Parent, args, Class) {
                var a = [null];
                a.push.apply(a, args);
                var Constructor = Function.bind.apply(Parent, a);
                var instance = new Constructor();
                if (Class) _setPrototypeOf(instance, Class.prototype);
                return instance;
            };
        }

        return _construct.apply(null, arguments);
    }

    function _isNativeFunction(fn) {
        return Function.toString.call(fn).indexOf("[native code]") !== -1;
    }

    function _wrapNativeSuper(Class) {
        var _cache = typeof Map === "function" ? new Map() : undefined;

        _wrapNativeSuper = function _wrapNativeSuper(Class) {
            if (Class === null || !_isNativeFunction(Class)) return Class;

            if (typeof Class !== "function") {
                throw new TypeError("Super expression must either be null or a function");
            }

            if (typeof _cache !== "undefined") {
                if (_cache.has(Class)) return _cache.get(Class);

                _cache.set(Class, Wrapper);
            }

            function Wrapper() {
                return _construct(Class, arguments, _getPrototypeOf(this).constructor);
            }

            Wrapper.prototype = Object.create(Class.prototype, {
                constructor: {
                    value: Wrapper,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            return _setPrototypeOf(Wrapper, Class);
        };

        return _wrapNativeSuper(Class);
    }



    tinybind.binders = binders;
    tinybind.formatters = formatters;
    tinybind.adapters['.'] = adapter;

    tinybind.bind = function (el, models, options) {
        var viewOptions = {};
        models = models || {};
        options = options || {};
        EXTENSIONS.forEach(function (extensionType) {
            viewOptions[extensionType] = Object.create(null);

            if (options[extensionType]) {
                Object.keys(options[extensionType]).forEach(function (key) {
                    viewOptions[extensionType][key] = options[extensionType][key];
                });
            }

            Object.keys(tinybind[extensionType]).forEach(function (key) {
                if (!viewOptions[extensionType][key]) {
                    viewOptions[extensionType][key] = tinybind[extensionType][key];
                }
            });
        });
        OPTIONS.forEach(function (option) {
            var value = options[option];
            viewOptions[option] = value != null ? value : tinybind[option];
        });
        viewOptions.starBinders = Object.keys(viewOptions.binders).filter(function (key) {
            return key.indexOf('*') > 0;
        });
        Observer.updateOptions(viewOptions);
        var view = new View(el, models, viewOptions);
        view.bind();
        return view;
    };

    tinybind.init = function (component, el) {
        var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        component = tinybind.components[component];
        el.innerHTML += component.template.call(tinybind, el);
        var scope = component.initialize.call(tinybind, el, data);

        var view = tinybind.bind(el, scope);
        view.bind();
        return view;
    };

    return tinybind;

}));
/*! Select2 4.0.13 | https://github.com/select2/select2/blob/master/LICENSE.md */
// Edited by Maarten to remove the deprecated .isFunction(). Select2 4.1 beta already had this solution
// So when it comes out of beta, we should update.
!function(n){"function"==typeof define&&define.amd?define(["jquery"],n):"object"==typeof module&&module.exports?module.exports=function(e,t){return void 0===t&&(t="undefined"!=typeof window?require("jquery"):require("jquery")(e)),n(t),t}:n(jQuery)}(function(d){var e=function(){if(d&&d.fn&&d.fn.select2&&d.fn.select2.amd)var e=d.fn.select2.amd;var t,n,i,h,o,s,f,g,m,v,y,_,r,a,w,l;function b(e,t){return r.call(e,t)}function c(e,t){var n,i,r,o,s,a,l,c,u,d,p,h=t&&t.split("/"),f=y.map,g=f&&f["*"]||{};if(e){for(s=(e=e.split("/")).length-1,y.nodeIdCompat&&w.test(e[s])&&(e[s]=e[s].replace(w,"")),"."===e[0].charAt(0)&&h&&(e=h.slice(0,h.length-1).concat(e)),u=0;u<e.length;u++)if("."===(p=e[u]))e.splice(u,1),--u;else if(".."===p){if(0===u||1===u&&".."===e[2]||".."===e[u-1])continue;0<u&&(e.splice(u-1,2),u-=2)}e=e.join("/")}if((h||g)&&f){for(u=(n=e.split("/")).length;0<u;--u){if(i=n.slice(0,u).join("/"),h)for(d=h.length;0<d;--d)if(r=(r=f[h.slice(0,d).join("/")])&&r[i]){o=r,a=u;break}if(o)break;!l&&g&&g[i]&&(l=g[i],c=u)}!o&&l&&(o=l,a=c),o&&(n.splice(0,a,o),e=n.join("/"))}return e}function A(t,n){return function(){var e=a.call(arguments,0);return"string"!=typeof e[0]&&1===e.length&&e.push(null),s.apply(h,e.concat([t,n]))}}function x(t){return function(e){m[t]=e}}function D(e){if(b(v,e)){var t=v[e];delete v[e],_[e]=!0,o.apply(h,t)}if(!b(m,e)&&!b(_,e))throw new Error("No "+e);return m[e]}function u(e){var t,n=e?e.indexOf("!"):-1;return-1<n&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function S(e){return e?u(e):[]}return e&&e.requirejs||(e?n=e:e={},m={},v={},y={},_={},r=Object.prototype.hasOwnProperty,a=[].slice,w=/\.js$/,f=function(e,t){var n,i,r=u(e),o=r[0],s=t[1];return e=r[1],o&&(n=D(o=c(o,s))),o?e=n&&n.normalize?n.normalize(e,(i=s,function(e){return c(e,i)})):c(e,s):(o=(r=u(e=c(e,s)))[0],e=r[1],o&&(n=D(o))),{f:o?o+"!"+e:e,n:e,pr:o,p:n}},g={require:function(e){return A(e)},exports:function(e){var t=m[e];return void 0!==t?t:m[e]={}},module:function(e){return{id:e,uri:"",exports:m[e],config:(t=e,function(){return y&&y.config&&y.config[t]||{}})};var t}},o=function(e,t,n,i){var r,o,s,a,l,c,u,d=[],p=typeof n;if(c=S(i=i||e),"undefined"==p||"function"==p){for(t=!t.length&&n.length?["require","exports","module"]:t,l=0;l<t.length;l+=1)if("require"===(o=(a=f(t[l],c)).f))d[l]=g.require(e);else if("exports"===o)d[l]=g.exports(e),u=!0;else if("module"===o)r=d[l]=g.module(e);else if(b(m,o)||b(v,o)||b(_,o))d[l]=D(o);else{if(!a.p)throw new Error(e+" missing "+o);a.p.load(a.n,A(i,!0),x(o),{}),d[l]=m[o]}s=n?n.apply(m[e],d):void 0,e&&(r&&r.exports!==h&&r.exports!==m[e]?m[e]=r.exports:s===h&&u||(m[e]=s))}else e&&(m[e]=n)},t=n=s=function(e,t,n,i,r){if("string"==typeof e)return g[e]?g[e](t):D(f(e,S(t)).f);if(!e.splice){if((y=e).deps&&s(y.deps,y.callback),!t)return;t.splice?(e=t,t=n,n=null):e=h}return t=t||function(){},"function"==typeof n&&(n=i,i=r),i?o(h,e,t,n):setTimeout(function(){o(h,e,t,n)},4),s},s.config=function(e){return s(e)},t._defined=m,(i=function(e,t,n){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(n=t,t=[]),b(m,e)||b(v,e)||(v[e]=[e,t,n])}).amd={jQuery:!0},e.requirejs=t,e.require=n,e.define=i),e.define("almond",function(){}),e.define("jquery",[],function(){var e=d||$;return null==e&&console&&console.error&&console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."),e}),e.define("select2/utils",["jquery"],function(o){var r={};function u(e){var t=e.prototype,n=[];for(var i in t){"function"==typeof t[i]&&"constructor"!==i&&n.push(i)}return n}r.Extend=function(e,t){var n={}.hasOwnProperty;function i(){this.constructor=e}for(var r in t)n.call(t,r)&&(e[r]=t[r]);return i.prototype=t.prototype,e.prototype=new i,e.__super__=t.prototype,e},r.Decorate=function(i,r){var e=u(r),t=u(i);function o(){var e=Array.prototype.unshift,t=r.prototype.constructor.length,n=i.prototype.constructor;0<t&&(e.call(arguments,i.prototype.constructor),n=r.prototype.constructor),n.apply(this,arguments)}r.displayName=i.displayName,o.prototype=new function(){this.constructor=o};for(var n=0;n<t.length;n++){var s=t[n];o.prototype[s]=i.prototype[s]}function a(e){var t=function(){};e in o.prototype&&(t=o.prototype[e]);var n=r.prototype[e];return function(){return Array.prototype.unshift.call(arguments,t),n.apply(this,arguments)}}for(var l=0;l<e.length;l++){var c=e[l];o.prototype[c]=a(c)}return o};function e(){this.listeners={}}e.prototype.on=function(e,t){this.listeners=this.listeners||{},e in this.listeners?this.listeners[e].push(t):this.listeners[e]=[t]},e.prototype.trigger=function(e){var t=Array.prototype.slice,n=t.call(arguments,1);this.listeners=this.listeners||{},null==n&&(n=[]),0===n.length&&n.push({}),(n[0]._type=e)in this.listeners&&this.invoke(this.listeners[e],t.call(arguments,1)),"*"in this.listeners&&this.invoke(this.listeners["*"],arguments)},e.prototype.invoke=function(e,t){for(var n=0,i=e.length;n<i;n++)e[n].apply(this,t)},r.Observable=e,r.generateChars=function(e){for(var t="",n=0;n<e;n++){t+=Math.floor(36*Math.random()).toString(36)}return t},r.bind=function(e,t){return function(){e.apply(t,arguments)}},r._convertData=function(e){for(var t in e){var n=t.split("-"),i=e;if(1!==n.length){for(var r=0;r<n.length;r++){var o=n[r];(o=o.substring(0,1).toLowerCase()+o.substring(1))in i||(i[o]={}),r==n.length-1&&(i[o]=e[t]),i=i[o]}delete e[t]}}return e},r.hasScroll=function(e,t){var n=o(t),i=t.style.overflowX,r=t.style.overflowY;return(i!==r||"hidden"!==r&&"visible"!==r)&&("scroll"===i||"scroll"===r||(n.innerHeight()<t.scrollHeight||n.innerWidth()<t.scrollWidth))},r.escapeMarkup=function(e){var t={"\\":"&#92;","&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#47;"};return"string"!=typeof e?e:String(e).replace(/[&<>"'\/\\]/g,function(e){return t[e]})},r.appendMany=function(e,t){if("1.7"===o.fn.jquery.substr(0,3)){var n=o();o.map(t,function(e){n=n.add(e)}),t=n}e.append(t)},r.__cache={};var n=0;return r.GetUniqueElementId=function(e){var t=e.getAttribute("data-select2-id");return null==t&&(e.id?(t=e.id,e.setAttribute("data-select2-id",t)):(e.setAttribute("data-select2-id",++n),t=n.toString())),t},r.StoreData=function(e,t,n){var i=r.GetUniqueElementId(e);r.__cache[i]||(r.__cache[i]={}),r.__cache[i][t]=n},r.GetData=function(e,t){var n=r.GetUniqueElementId(e);return t?r.__cache[n]&&null!=r.__cache[n][t]?r.__cache[n][t]:o(e).data(t):r.__cache[n]},r.RemoveData=function(e){var t=r.GetUniqueElementId(e);null!=r.__cache[t]&&delete r.__cache[t],e.removeAttribute("data-select2-id")},r}),e.define("select2/results",["jquery","./utils"],function(h,f){function i(e,t,n){this.$element=e,this.data=n,this.options=t,i.__super__.constructor.call(this)}return f.Extend(i,f.Observable),i.prototype.render=function(){var e=h('<ul class="select2-results__options" role="listbox"></ul>');return this.options.get("multiple")&&e.attr("aria-multiselectable","true"),this.$results=e},i.prototype.clear=function(){this.$results.empty()},i.prototype.displayMessage=function(e){var t=this.options.get("escapeMarkup");this.clear(),this.hideLoading();var n=h('<li role="alert" aria-live="assertive" class="select2-results__option"></li>'),i=this.options.get("translations").get(e.message);n.append(t(i(e.args))),n[0].className+=" select2-results__message",this.$results.append(n)},i.prototype.hideMessages=function(){this.$results.find(".select2-results__message").remove()},i.prototype.append=function(e){this.hideLoading();var t=[];if(null!=e.results&&0!==e.results.length){e.results=this.sort(e.results);for(var n=0;n<e.results.length;n++){var i=e.results[n],r=this.option(i);t.push(r)}this.$results.append(t)}else 0===this.$results.children().length&&this.trigger("results:message",{message:"noResults"})},i.prototype.position=function(e,t){t.find(".select2-results").append(e)},i.prototype.sort=function(e){return this.options.get("sorter")(e)},i.prototype.highlightFirstItem=function(){var e=this.$results.find(".select2-results__option[aria-selected]"),t=e.filter("[aria-selected=true]");0<t.length?t.first().trigger("mouseenter"):e.first().trigger("mouseenter"),this.ensureHighlightVisible()},i.prototype.setClasses=function(){var t=this;this.data.current(function(e){var i=h.map(e,function(e){return e.id.toString()});t.$results.find(".select2-results__option[aria-selected]").each(function(){var e=h(this),t=f.GetData(this,"data"),n=""+t.id;null!=t.element&&t.element.selected||null==t.element&&-1<h.inArray(n,i)?e.attr("aria-selected","true"):e.attr("aria-selected","false")})})},i.prototype.showLoading=function(e){this.hideLoading();var t={disabled:!0,loading:!0,text:this.options.get("translations").get("searching")(e)},n=this.option(t);n.className+=" loading-results",this.$results.prepend(n)},i.prototype.hideLoading=function(){this.$results.find(".loading-results").remove()},i.prototype.option=function(e){var t=document.createElement("li");t.className="select2-results__option";var n={role:"option","aria-selected":"false"},i=Element.prototype.matches||Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector;for(var r in(null!=e.element&&i.call(e.element,":disabled")||null==e.element&&e.disabled)&&(delete n["aria-selected"],n["aria-disabled"]="true"),null==e.id&&delete n["aria-selected"],null!=e._resultId&&(t.id=e._resultId),e.title&&(t.title=e.title),e.children&&(n.role="group",n["aria-label"]=e.text,delete n["aria-selected"]),n){var o=n[r];t.setAttribute(r,o)}if(e.children){var s=h(t),a=document.createElement("strong");a.className="select2-results__group";h(a);this.template(e,a);for(var l=[],c=0;c<e.children.length;c++){var u=e.children[c],d=this.option(u);l.push(d)}var p=h("<ul></ul>",{class:"select2-results__options select2-results__options--nested"});p.append(l),s.append(a),s.append(p)}else this.template(e,t);return f.StoreData(t,"data",e),t},i.prototype.bind=function(t,e){var l=this,n=t.id+"-results";this.$results.attr("id",n),t.on("results:all",function(e){l.clear(),l.append(e.data),t.isOpen()&&(l.setClasses(),l.highlightFirstItem())}),t.on("results:append",function(e){l.append(e.data),t.isOpen()&&l.setClasses()}),t.on("query",function(e){l.hideMessages(),l.showLoading(e)}),t.on("select",function(){t.isOpen()&&(l.setClasses(),l.options.get("scrollAfterSelect")&&l.highlightFirstItem())}),t.on("unselect",function(){t.isOpen()&&(l.setClasses(),l.options.get("scrollAfterSelect")&&l.highlightFirstItem())}),t.on("open",function(){l.$results.attr("aria-expanded","true"),l.$results.attr("aria-hidden","false"),l.setClasses(),l.ensureHighlightVisible()}),t.on("close",function(){l.$results.attr("aria-expanded","false"),l.$results.attr("aria-hidden","true"),l.$results.removeAttr("aria-activedescendant")}),t.on("results:toggle",function(){var e=l.getHighlightedResults();0!==e.length&&e.trigger("mouseup")}),t.on("results:select",function(){var e=l.getHighlightedResults();if(0!==e.length){var t=f.GetData(e[0],"data");"true"==e.attr("aria-selected")?l.trigger("close",{}):l.trigger("select",{data:t})}}),t.on("results:previous",function(){var e=l.getHighlightedResults(),t=l.$results.find("[aria-selected]"),n=t.index(e);if(!(n<=0)){var i=n-1;0===e.length&&(i=0);var r=t.eq(i);r.trigger("mouseenter");var o=l.$results.offset().top,s=r.offset().top,a=l.$results.scrollTop()+(s-o);0===i?l.$results.scrollTop(0):s-o<0&&l.$results.scrollTop(a)}}),t.on("results:next",function(){var e=l.getHighlightedResults(),t=l.$results.find("[aria-selected]"),n=t.index(e)+1;if(!(n>=t.length)){var i=t.eq(n);i.trigger("mouseenter");var r=l.$results.offset().top+l.$results.outerHeight(!1),o=i.offset().top+i.outerHeight(!1),s=l.$results.scrollTop()+o-r;0===n?l.$results.scrollTop(0):r<o&&l.$results.scrollTop(s)}}),t.on("results:focus",function(e){e.element.addClass("select2-results__option--highlighted")}),t.on("results:message",function(e){l.displayMessage(e)}),h.fn.mousewheel&&this.$results.on("mousewheel",function(e){var t=l.$results.scrollTop(),n=l.$results.get(0).scrollHeight-t+e.deltaY,i=0<e.deltaY&&t-e.deltaY<=0,r=e.deltaY<0&&n<=l.$results.height();i?(l.$results.scrollTop(0),e.preventDefault(),e.stopPropagation()):r&&(l.$results.scrollTop(l.$results.get(0).scrollHeight-l.$results.height()),e.preventDefault(),e.stopPropagation())}),this.$results.on("mouseup",".select2-results__option[aria-selected]",function(e){var t=h(this),n=f.GetData(this,"data");"true"!==t.attr("aria-selected")?l.trigger("select",{originalEvent:e,data:n}):l.options.get("multiple")?l.trigger("unselect",{originalEvent:e,data:n}):l.trigger("close",{})}),this.$results.on("mouseenter",".select2-results__option[aria-selected]",function(e){var t=f.GetData(this,"data");l.getHighlightedResults().removeClass("select2-results__option--highlighted"),l.trigger("results:focus",{data:t,element:h(this)})})},i.prototype.getHighlightedResults=function(){return this.$results.find(".select2-results__option--highlighted")},i.prototype.destroy=function(){this.$results.remove()},i.prototype.ensureHighlightVisible=function(){var e=this.getHighlightedResults();if(0!==e.length){var t=this.$results.find("[aria-selected]").index(e),n=this.$results.offset().top,i=e.offset().top,r=this.$results.scrollTop()+(i-n),o=i-n;r-=2*e.outerHeight(!1),t<=2?this.$results.scrollTop(0):(o>this.$results.outerHeight()||o<0)&&this.$results.scrollTop(r)}},i.prototype.template=function(e,t){var n=this.options.get("templateResult"),i=this.options.get("escapeMarkup"),r=n(e,t);null==r?t.style.display="none":"string"==typeof r?t.innerHTML=i(r):h(t).append(r)},i}),e.define("select2/keys",[],function(){return{BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46}}),e.define("select2/selection/base",["jquery","../utils","../keys"],function(n,i,r){function o(e,t){this.$element=e,this.options=t,o.__super__.constructor.call(this)}return i.Extend(o,i.Observable),o.prototype.render=function(){var e=n('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');return this._tabindex=0,null!=i.GetData(this.$element[0],"old-tabindex")?this._tabindex=i.GetData(this.$element[0],"old-tabindex"):null!=this.$element.attr("tabindex")&&(this._tabindex=this.$element.attr("tabindex")),e.attr("title",this.$element.attr("title")),e.attr("tabindex",this._tabindex),e.attr("aria-disabled","false"),this.$selection=e},o.prototype.bind=function(e,t){var n=this,i=e.id+"-results";this.container=e,this.$selection.on("focus",function(e){n.trigger("focus",e)}),this.$selection.on("blur",function(e){n._handleBlur(e)}),this.$selection.on("keydown",function(e){n.trigger("keypress",e),e.which===r.SPACE&&e.preventDefault()}),e.on("results:focus",function(e){n.$selection.attr("aria-activedescendant",e.data._resultId)}),e.on("selection:update",function(e){n.update(e.data)}),e.on("open",function(){n.$selection.attr("aria-expanded","true"),n.$selection.attr("aria-owns",i),n._attachCloseHandler(e)}),e.on("close",function(){n.$selection.attr("aria-expanded","false"),n.$selection.removeAttr("aria-activedescendant"),n.$selection.removeAttr("aria-owns"),n.$selection.trigger("focus"),n._detachCloseHandler(e)}),e.on("enable",function(){n.$selection.attr("tabindex",n._tabindex),n.$selection.attr("aria-disabled","false")}),e.on("disable",function(){n.$selection.attr("tabindex","-1"),n.$selection.attr("aria-disabled","true")})},o.prototype._handleBlur=function(e){var t=this;setTimeout(function(){document.activeElement==t.$selection[0]||n.contains(t.$selection[0],document.activeElement)||t.trigger("blur",e)},1)},o.prototype._attachCloseHandler=function(e){n(document.body).on("mousedown.select2."+e.id,function(e){var t=n(e.target).closest(".select2");n(".select2.select2-container--open").each(function(){this!=t[0]&&i.GetData(this,"element").select2("close")})})},o.prototype._detachCloseHandler=function(e){n(document.body).off("mousedown.select2."+e.id)},o.prototype.position=function(e,t){t.find(".selection").append(e)},o.prototype.destroy=function(){this._detachCloseHandler(this.container)},o.prototype.update=function(e){throw new Error("The `update` method must be defined in child classes.")},o.prototype.isEnabled=function(){return!this.isDisabled()},o.prototype.isDisabled=function(){return this.options.get("disabled")},o}),e.define("select2/selection/single",["jquery","./base","../utils","../keys"],function(e,t,n,i){function r(){r.__super__.constructor.apply(this,arguments)}return n.Extend(r,t),r.prototype.render=function(){var e=r.__super__.render.call(this);return e.addClass("select2-selection--single"),e.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'),e},r.prototype.bind=function(t,e){var n=this;r.__super__.bind.apply(this,arguments);var i=t.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",i).attr("role","textbox").attr("aria-readonly","true"),this.$selection.attr("aria-labelledby",i),this.$selection.on("mousedown",function(e){1===e.which&&n.trigger("toggle",{originalEvent:e})}),this.$selection.on("focus",function(e){}),this.$selection.on("blur",function(e){}),t.on("focus",function(e){t.isOpen()||n.$selection.trigger("focus")})},r.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},r.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},r.prototype.selectionContainer=function(){return e("<span></span>")},r.prototype.update=function(e){if(0!==e.length){var t=e[0],n=this.$selection.find(".select2-selection__rendered"),i=this.display(t,n);n.empty().append(i);var r=t.title||t.text;r?n.attr("title",r):n.removeAttr("title")}else this.clear()},r}),e.define("select2/selection/multiple",["jquery","./base","../utils"],function(r,e,l){function n(e,t){n.__super__.constructor.apply(this,arguments)}return l.Extend(n,e),n.prototype.render=function(){var e=n.__super__.render.call(this);return e.addClass("select2-selection--multiple"),e.html('<ul class="select2-selection__rendered"></ul>'),e},n.prototype.bind=function(e,t){var i=this;n.__super__.bind.apply(this,arguments),this.$selection.on("click",function(e){i.trigger("toggle",{originalEvent:e})}),this.$selection.on("click",".select2-selection__choice__remove",function(e){if(!i.isDisabled()){var t=r(this).parent(),n=l.GetData(t[0],"data");i.trigger("unselect",{originalEvent:e,data:n})}})},n.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},n.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},n.prototype.selectionContainer=function(){return r('<li class="select2-selection__choice"><span class="select2-selection__choice__remove" role="presentation">&times;</span></li>')},n.prototype.update=function(e){if(this.clear(),0!==e.length){for(var t=[],n=0;n<e.length;n++){var i=e[n],r=this.selectionContainer(),o=this.display(i,r);r.append(o);var s=i.title||i.text;s&&r.attr("title",s),l.StoreData(r[0],"data",i),t.push(r)}var a=this.$selection.find(".select2-selection__rendered");l.appendMany(a,t)}},n}),e.define("select2/selection/placeholder",["../utils"],function(e){function t(e,t,n){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n)}return t.prototype.normalizePlaceholder=function(e,t){return"string"==typeof t&&(t={id:"",text:t}),t},t.prototype.createPlaceholder=function(e,t){var n=this.selectionContainer();return n.html(this.display(t)),n.addClass("select2-selection__placeholder").removeClass("select2-selection__choice"),n},t.prototype.update=function(e,t){var n=1==t.length&&t[0].id!=this.placeholder.id;if(1<t.length||n)return e.call(this,t);this.clear();var i=this.createPlaceholder(this.placeholder);this.$selection.find(".select2-selection__rendered").append(i)},t}),e.define("select2/selection/allowClear",["jquery","../keys","../utils"],function(r,i,a){function e(){}return e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),null==this.placeholder&&this.options.get("debug")&&console&&console.error&&console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."),this.$selection.on("mousedown",".select2-selection__clear",function(e){i._handleClear(e)}),t.on("keypress",function(e){i._handleKeyboardClear(e,t)})},e.prototype._handleClear=function(e,t){if(!this.isDisabled()){var n=this.$selection.find(".select2-selection__clear");if(0!==n.length){t.stopPropagation();var i=a.GetData(n[0],"data"),r=this.$element.val();this.$element.val(this.placeholder.id);var o={data:i};if(this.trigger("clear",o),o.prevented)this.$element.val(r);else{for(var s=0;s<i.length;s++)if(o={data:i[s]},this.trigger("unselect",o),o.prevented)return void this.$element.val(r);this.$element.trigger("input").trigger("change"),this.trigger("toggle",{})}}}},e.prototype._handleKeyboardClear=function(e,t,n){n.isOpen()||t.which!=i.DELETE&&t.which!=i.BACKSPACE||this._handleClear(t)},e.prototype.update=function(e,t){if(e.call(this,t),!(0<this.$selection.find(".select2-selection__placeholder").length||0===t.length)){var n=this.options.get("translations").get("removeAllItems"),i=r('<span class="select2-selection__clear" title="'+n()+'">&times;</span>');a.StoreData(i[0],"data",t),this.$selection.find(".select2-selection__rendered").prepend(i)}},e}),e.define("select2/selection/search",["jquery","../utils","../keys"],function(i,a,l){function e(e,t,n){e.call(this,t,n)}return e.prototype.render=function(e){var t=i('<li class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></li>');this.$searchContainer=t,this.$search=t.find("input");var n=e.call(this);return this._transferTabIndex(),n},e.prototype.bind=function(e,t,n){var i=this,r=t.id+"-results";e.call(this,t,n),t.on("open",function(){i.$search.attr("aria-controls",r),i.$search.trigger("focus")}),t.on("close",function(){i.$search.val(""),i.$search.removeAttr("aria-controls"),i.$search.removeAttr("aria-activedescendant"),i.$search.trigger("focus")}),t.on("enable",function(){i.$search.prop("disabled",!1),i._transferTabIndex()}),t.on("disable",function(){i.$search.prop("disabled",!0)}),t.on("focus",function(e){i.$search.trigger("focus")}),t.on("results:focus",function(e){e.data._resultId?i.$search.attr("aria-activedescendant",e.data._resultId):i.$search.removeAttr("aria-activedescendant")}),this.$selection.on("focusin",".select2-search--inline",function(e){i.trigger("focus",e)}),this.$selection.on("focusout",".select2-search--inline",function(e){i._handleBlur(e)}),this.$selection.on("keydown",".select2-search--inline",function(e){if(e.stopPropagation(),i.trigger("keypress",e),i._keyUpPrevented=e.isDefaultPrevented(),e.which===l.BACKSPACE&&""===i.$search.val()){var t=i.$searchContainer.prev(".select2-selection__choice");if(0<t.length){var n=a.GetData(t[0],"data");i.searchRemoveChoice(n),e.preventDefault()}}}),this.$selection.on("click",".select2-search--inline",function(e){i.$search.val()&&e.stopPropagation()});var o=document.documentMode,s=o&&o<=11;this.$selection.on("input.searchcheck",".select2-search--inline",function(e){s?i.$selection.off("input.search input.searchcheck"):i.$selection.off("keyup.search")}),this.$selection.on("keyup.search input.search",".select2-search--inline",function(e){if(s&&"input"===e.type)i.$selection.off("input.search input.searchcheck");else{var t=e.which;t!=l.SHIFT&&t!=l.CTRL&&t!=l.ALT&&t!=l.TAB&&i.handleSearch(e)}})},e.prototype._transferTabIndex=function(e){this.$search.attr("tabindex",this.$selection.attr("tabindex")),this.$selection.attr("tabindex","-1")},e.prototype.createPlaceholder=function(e,t){this.$search.attr("placeholder",t.text)},e.prototype.update=function(e,t){var n=this.$search[0]==document.activeElement;this.$search.attr("placeholder",""),e.call(this,t),this.$selection.find(".select2-selection__rendered").append(this.$searchContainer),this.resizeSearch(),n&&this.$search.trigger("focus")},e.prototype.handleSearch=function(){if(this.resizeSearch(),!this._keyUpPrevented){var e=this.$search.val();this.trigger("query",{term:e})}this._keyUpPrevented=!1},e.prototype.searchRemoveChoice=function(e,t){this.trigger("unselect",{data:t}),this.$search.val(t.text),this.handleSearch()},e.prototype.resizeSearch=function(){this.$search.css("width","25px");var e="";""!==this.$search.attr("placeholder")?e=this.$selection.find(".select2-selection__rendered").width():e=.75*(this.$search.val().length+1)+"em";this.$search.css("width",e)},e}),e.define("select2/selection/eventRelay",["jquery"],function(s){function e(){}return e.prototype.bind=function(e,t,n){var i=this,r=["open","opening","close","closing","select","selecting","unselect","unselecting","clear","clearing"],o=["opening","closing","selecting","unselecting","clearing"];e.call(this,t,n),t.on("*",function(e,t){if(-1!==s.inArray(e,r)){t=t||{};var n=s.Event("select2:"+e,{params:t});i.$element.trigger(n),-1!==s.inArray(e,o)&&(t.prevented=n.isDefaultPrevented())}})},e}),e.define("select2/translation",["jquery","require"],function(t,n){function i(e){this.dict=e||{}}return i.prototype.all=function(){return this.dict},i.prototype.get=function(e){return this.dict[e]},i.prototype.extend=function(e){this.dict=t.extend({},e.all(),this.dict)},i._cache={},i.loadPath=function(e){if(!(e in i._cache)){var t=n(e);i._cache[e]=t}return new i(i._cache[e])},i}),e.define("select2/diacritics",[],function(){return{"Ⓐ":"A","Ａ":"A","À":"A","Á":"A","Â":"A","Ầ":"A","Ấ":"A","Ẫ":"A","Ẩ":"A","Ã":"A","Ā":"A","Ă":"A","Ằ":"A","Ắ":"A","Ẵ":"A","Ẳ":"A","Ȧ":"A","Ǡ":"A","Ä":"A","Ǟ":"A","Ả":"A","Å":"A","Ǻ":"A","Ǎ":"A","Ȁ":"A","Ȃ":"A","Ạ":"A","Ậ":"A","Ặ":"A","Ḁ":"A","Ą":"A","Ⱥ":"A","Ɐ":"A","Ꜳ":"AA","Æ":"AE","Ǽ":"AE","Ǣ":"AE","Ꜵ":"AO","Ꜷ":"AU","Ꜹ":"AV","Ꜻ":"AV","Ꜽ":"AY","Ⓑ":"B","Ｂ":"B","Ḃ":"B","Ḅ":"B","Ḇ":"B","Ƀ":"B","Ƃ":"B","Ɓ":"B","Ⓒ":"C","Ｃ":"C","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","Ç":"C","Ḉ":"C","Ƈ":"C","Ȼ":"C","Ꜿ":"C","Ⓓ":"D","Ｄ":"D","Ḋ":"D","Ď":"D","Ḍ":"D","Ḑ":"D","Ḓ":"D","Ḏ":"D","Đ":"D","Ƌ":"D","Ɗ":"D","Ɖ":"D","Ꝺ":"D","Ǳ":"DZ","Ǆ":"DZ","ǲ":"Dz","ǅ":"Dz","Ⓔ":"E","Ｅ":"E","È":"E","É":"E","Ê":"E","Ề":"E","Ế":"E","Ễ":"E","Ể":"E","Ẽ":"E","Ē":"E","Ḕ":"E","Ḗ":"E","Ĕ":"E","Ė":"E","Ë":"E","Ẻ":"E","Ě":"E","Ȅ":"E","Ȇ":"E","Ẹ":"E","Ệ":"E","Ȩ":"E","Ḝ":"E","Ę":"E","Ḙ":"E","Ḛ":"E","Ɛ":"E","Ǝ":"E","Ⓕ":"F","Ｆ":"F","Ḟ":"F","Ƒ":"F","Ꝼ":"F","Ⓖ":"G","Ｇ":"G","Ǵ":"G","Ĝ":"G","Ḡ":"G","Ğ":"G","Ġ":"G","Ǧ":"G","Ģ":"G","Ǥ":"G","Ɠ":"G","Ꞡ":"G","Ᵹ":"G","Ꝿ":"G","Ⓗ":"H","Ｈ":"H","Ĥ":"H","Ḣ":"H","Ḧ":"H","Ȟ":"H","Ḥ":"H","Ḩ":"H","Ḫ":"H","Ħ":"H","Ⱨ":"H","Ⱶ":"H","Ɥ":"H","Ⓘ":"I","Ｉ":"I","Ì":"I","Í":"I","Î":"I","Ĩ":"I","Ī":"I","Ĭ":"I","İ":"I","Ï":"I","Ḯ":"I","Ỉ":"I","Ǐ":"I","Ȉ":"I","Ȋ":"I","Ị":"I","Į":"I","Ḭ":"I","Ɨ":"I","Ⓙ":"J","Ｊ":"J","Ĵ":"J","Ɉ":"J","Ⓚ":"K","Ｋ":"K","Ḱ":"K","Ǩ":"K","Ḳ":"K","Ķ":"K","Ḵ":"K","Ƙ":"K","Ⱪ":"K","Ꝁ":"K","Ꝃ":"K","Ꝅ":"K","Ꞣ":"K","Ⓛ":"L","Ｌ":"L","Ŀ":"L","Ĺ":"L","Ľ":"L","Ḷ":"L","Ḹ":"L","Ļ":"L","Ḽ":"L","Ḻ":"L","Ł":"L","Ƚ":"L","Ɫ":"L","Ⱡ":"L","Ꝉ":"L","Ꝇ":"L","Ꞁ":"L","Ǉ":"LJ","ǈ":"Lj","Ⓜ":"M","Ｍ":"M","Ḿ":"M","Ṁ":"M","Ṃ":"M","Ɱ":"M","Ɯ":"M","Ⓝ":"N","Ｎ":"N","Ǹ":"N","Ń":"N","Ñ":"N","Ṅ":"N","Ň":"N","Ṇ":"N","Ņ":"N","Ṋ":"N","Ṉ":"N","Ƞ":"N","Ɲ":"N","Ꞑ":"N","Ꞥ":"N","Ǌ":"NJ","ǋ":"Nj","Ⓞ":"O","Ｏ":"O","Ò":"O","Ó":"O","Ô":"O","Ồ":"O","Ố":"O","Ỗ":"O","Ổ":"O","Õ":"O","Ṍ":"O","Ȭ":"O","Ṏ":"O","Ō":"O","Ṑ":"O","Ṓ":"O","Ŏ":"O","Ȯ":"O","Ȱ":"O","Ö":"O","Ȫ":"O","Ỏ":"O","Ő":"O","Ǒ":"O","Ȍ":"O","Ȏ":"O","Ơ":"O","Ờ":"O","Ớ":"O","Ỡ":"O","Ở":"O","Ợ":"O","Ọ":"O","Ộ":"O","Ǫ":"O","Ǭ":"O","Ø":"O","Ǿ":"O","Ɔ":"O","Ɵ":"O","Ꝋ":"O","Ꝍ":"O","Œ":"OE","Ƣ":"OI","Ꝏ":"OO","Ȣ":"OU","Ⓟ":"P","Ｐ":"P","Ṕ":"P","Ṗ":"P","Ƥ":"P","Ᵽ":"P","Ꝑ":"P","Ꝓ":"P","Ꝕ":"P","Ⓠ":"Q","Ｑ":"Q","Ꝗ":"Q","Ꝙ":"Q","Ɋ":"Q","Ⓡ":"R","Ｒ":"R","Ŕ":"R","Ṙ":"R","Ř":"R","Ȑ":"R","Ȓ":"R","Ṛ":"R","Ṝ":"R","Ŗ":"R","Ṟ":"R","Ɍ":"R","Ɽ":"R","Ꝛ":"R","Ꞧ":"R","Ꞃ":"R","Ⓢ":"S","Ｓ":"S","ẞ":"S","Ś":"S","Ṥ":"S","Ŝ":"S","Ṡ":"S","Š":"S","Ṧ":"S","Ṣ":"S","Ṩ":"S","Ș":"S","Ş":"S","Ȿ":"S","Ꞩ":"S","Ꞅ":"S","Ⓣ":"T","Ｔ":"T","Ṫ":"T","Ť":"T","Ṭ":"T","Ț":"T","Ţ":"T","Ṱ":"T","Ṯ":"T","Ŧ":"T","Ƭ":"T","Ʈ":"T","Ⱦ":"T","Ꞇ":"T","Ꜩ":"TZ","Ⓤ":"U","Ｕ":"U","Ù":"U","Ú":"U","Û":"U","Ũ":"U","Ṹ":"U","Ū":"U","Ṻ":"U","Ŭ":"U","Ü":"U","Ǜ":"U","Ǘ":"U","Ǖ":"U","Ǚ":"U","Ủ":"U","Ů":"U","Ű":"U","Ǔ":"U","Ȕ":"U","Ȗ":"U","Ư":"U","Ừ":"U","Ứ":"U","Ữ":"U","Ử":"U","Ự":"U","Ụ":"U","Ṳ":"U","Ų":"U","Ṷ":"U","Ṵ":"U","Ʉ":"U","Ⓥ":"V","Ｖ":"V","Ṽ":"V","Ṿ":"V","Ʋ":"V","Ꝟ":"V","Ʌ":"V","Ꝡ":"VY","Ⓦ":"W","Ｗ":"W","Ẁ":"W","Ẃ":"W","Ŵ":"W","Ẇ":"W","Ẅ":"W","Ẉ":"W","Ⱳ":"W","Ⓧ":"X","Ｘ":"X","Ẋ":"X","Ẍ":"X","Ⓨ":"Y","Ｙ":"Y","Ỳ":"Y","Ý":"Y","Ŷ":"Y","Ỹ":"Y","Ȳ":"Y","Ẏ":"Y","Ÿ":"Y","Ỷ":"Y","Ỵ":"Y","Ƴ":"Y","Ɏ":"Y","Ỿ":"Y","Ⓩ":"Z","Ｚ":"Z","Ź":"Z","Ẑ":"Z","Ż":"Z","Ž":"Z","Ẓ":"Z","Ẕ":"Z","Ƶ":"Z","Ȥ":"Z","Ɀ":"Z","Ⱬ":"Z","Ꝣ":"Z","ⓐ":"a","ａ":"a","ẚ":"a","à":"a","á":"a","â":"a","ầ":"a","ấ":"a","ẫ":"a","ẩ":"a","ã":"a","ā":"a","ă":"a","ằ":"a","ắ":"a","ẵ":"a","ẳ":"a","ȧ":"a","ǡ":"a","ä":"a","ǟ":"a","ả":"a","å":"a","ǻ":"a","ǎ":"a","ȁ":"a","ȃ":"a","ạ":"a","ậ":"a","ặ":"a","ḁ":"a","ą":"a","ⱥ":"a","ɐ":"a","ꜳ":"aa","æ":"ae","ǽ":"ae","ǣ":"ae","ꜵ":"ao","ꜷ":"au","ꜹ":"av","ꜻ":"av","ꜽ":"ay","ⓑ":"b","ｂ":"b","ḃ":"b","ḅ":"b","ḇ":"b","ƀ":"b","ƃ":"b","ɓ":"b","ⓒ":"c","ｃ":"c","ć":"c","ĉ":"c","ċ":"c","č":"c","ç":"c","ḉ":"c","ƈ":"c","ȼ":"c","ꜿ":"c","ↄ":"c","ⓓ":"d","ｄ":"d","ḋ":"d","ď":"d","ḍ":"d","ḑ":"d","ḓ":"d","ḏ":"d","đ":"d","ƌ":"d","ɖ":"d","ɗ":"d","ꝺ":"d","ǳ":"dz","ǆ":"dz","ⓔ":"e","ｅ":"e","è":"e","é":"e","ê":"e","ề":"e","ế":"e","ễ":"e","ể":"e","ẽ":"e","ē":"e","ḕ":"e","ḗ":"e","ĕ":"e","ė":"e","ë":"e","ẻ":"e","ě":"e","ȅ":"e","ȇ":"e","ẹ":"e","ệ":"e","ȩ":"e","ḝ":"e","ę":"e","ḙ":"e","ḛ":"e","ɇ":"e","ɛ":"e","ǝ":"e","ⓕ":"f","ｆ":"f","ḟ":"f","ƒ":"f","ꝼ":"f","ⓖ":"g","ｇ":"g","ǵ":"g","ĝ":"g","ḡ":"g","ğ":"g","ġ":"g","ǧ":"g","ģ":"g","ǥ":"g","ɠ":"g","ꞡ":"g","ᵹ":"g","ꝿ":"g","ⓗ":"h","ｈ":"h","ĥ":"h","ḣ":"h","ḧ":"h","ȟ":"h","ḥ":"h","ḩ":"h","ḫ":"h","ẖ":"h","ħ":"h","ⱨ":"h","ⱶ":"h","ɥ":"h","ƕ":"hv","ⓘ":"i","ｉ":"i","ì":"i","í":"i","î":"i","ĩ":"i","ī":"i","ĭ":"i","ï":"i","ḯ":"i","ỉ":"i","ǐ":"i","ȉ":"i","ȋ":"i","ị":"i","į":"i","ḭ":"i","ɨ":"i","ı":"i","ⓙ":"j","ｊ":"j","ĵ":"j","ǰ":"j","ɉ":"j","ⓚ":"k","ｋ":"k","ḱ":"k","ǩ":"k","ḳ":"k","ķ":"k","ḵ":"k","ƙ":"k","ⱪ":"k","ꝁ":"k","ꝃ":"k","ꝅ":"k","ꞣ":"k","ⓛ":"l","ｌ":"l","ŀ":"l","ĺ":"l","ľ":"l","ḷ":"l","ḹ":"l","ļ":"l","ḽ":"l","ḻ":"l","ſ":"l","ł":"l","ƚ":"l","ɫ":"l","ⱡ":"l","ꝉ":"l","ꞁ":"l","ꝇ":"l","ǉ":"lj","ⓜ":"m","ｍ":"m","ḿ":"m","ṁ":"m","ṃ":"m","ɱ":"m","ɯ":"m","ⓝ":"n","ｎ":"n","ǹ":"n","ń":"n","ñ":"n","ṅ":"n","ň":"n","ṇ":"n","ņ":"n","ṋ":"n","ṉ":"n","ƞ":"n","ɲ":"n","ŉ":"n","ꞑ":"n","ꞥ":"n","ǌ":"nj","ⓞ":"o","ｏ":"o","ò":"o","ó":"o","ô":"o","ồ":"o","ố":"o","ỗ":"o","ổ":"o","õ":"o","ṍ":"o","ȭ":"o","ṏ":"o","ō":"o","ṑ":"o","ṓ":"o","ŏ":"o","ȯ":"o","ȱ":"o","ö":"o","ȫ":"o","ỏ":"o","ő":"o","ǒ":"o","ȍ":"o","ȏ":"o","ơ":"o","ờ":"o","ớ":"o","ỡ":"o","ở":"o","ợ":"o","ọ":"o","ộ":"o","ǫ":"o","ǭ":"o","ø":"o","ǿ":"o","ɔ":"o","ꝋ":"o","ꝍ":"o","ɵ":"o","œ":"oe","ƣ":"oi","ȣ":"ou","ꝏ":"oo","ⓟ":"p","ｐ":"p","ṕ":"p","ṗ":"p","ƥ":"p","ᵽ":"p","ꝑ":"p","ꝓ":"p","ꝕ":"p","ⓠ":"q","ｑ":"q","ɋ":"q","ꝗ":"q","ꝙ":"q","ⓡ":"r","ｒ":"r","ŕ":"r","ṙ":"r","ř":"r","ȑ":"r","ȓ":"r","ṛ":"r","ṝ":"r","ŗ":"r","ṟ":"r","ɍ":"r","ɽ":"r","ꝛ":"r","ꞧ":"r","ꞃ":"r","ⓢ":"s","ｓ":"s","ß":"s","ś":"s","ṥ":"s","ŝ":"s","ṡ":"s","š":"s","ṧ":"s","ṣ":"s","ṩ":"s","ș":"s","ş":"s","ȿ":"s","ꞩ":"s","ꞅ":"s","ẛ":"s","ⓣ":"t","ｔ":"t","ṫ":"t","ẗ":"t","ť":"t","ṭ":"t","ț":"t","ţ":"t","ṱ":"t","ṯ":"t","ŧ":"t","ƭ":"t","ʈ":"t","ⱦ":"t","ꞇ":"t","ꜩ":"tz","ⓤ":"u","ｕ":"u","ù":"u","ú":"u","û":"u","ũ":"u","ṹ":"u","ū":"u","ṻ":"u","ŭ":"u","ü":"u","ǜ":"u","ǘ":"u","ǖ":"u","ǚ":"u","ủ":"u","ů":"u","ű":"u","ǔ":"u","ȕ":"u","ȗ":"u","ư":"u","ừ":"u","ứ":"u","ữ":"u","ử":"u","ự":"u","ụ":"u","ṳ":"u","ų":"u","ṷ":"u","ṵ":"u","ʉ":"u","ⓥ":"v","ｖ":"v","ṽ":"v","ṿ":"v","ʋ":"v","ꝟ":"v","ʌ":"v","ꝡ":"vy","ⓦ":"w","ｗ":"w","ẁ":"w","ẃ":"w","ŵ":"w","ẇ":"w","ẅ":"w","ẘ":"w","ẉ":"w","ⱳ":"w","ⓧ":"x","ｘ":"x","ẋ":"x","ẍ":"x","ⓨ":"y","ｙ":"y","ỳ":"y","ý":"y","ŷ":"y","ỹ":"y","ȳ":"y","ẏ":"y","ÿ":"y","ỷ":"y","ẙ":"y","ỵ":"y","ƴ":"y","ɏ":"y","ỿ":"y","ⓩ":"z","ｚ":"z","ź":"z","ẑ":"z","ż":"z","ž":"z","ẓ":"z","ẕ":"z","ƶ":"z","ȥ":"z","ɀ":"z","ⱬ":"z","ꝣ":"z","Ά":"Α","Έ":"Ε","Ή":"Η","Ί":"Ι","Ϊ":"Ι","Ό":"Ο","Ύ":"Υ","Ϋ":"Υ","Ώ":"Ω","ά":"α","έ":"ε","ή":"η","ί":"ι","ϊ":"ι","ΐ":"ι","ό":"ο","ύ":"υ","ϋ":"υ","ΰ":"υ","ώ":"ω","ς":"σ","’":"'"}}),e.define("select2/data/base",["../utils"],function(i){function n(e,t){n.__super__.constructor.call(this)}return i.Extend(n,i.Observable),n.prototype.current=function(e){throw new Error("The `current` method must be defined in child classes.")},n.prototype.query=function(e,t){throw new Error("The `query` method must be defined in child classes.")},n.prototype.bind=function(e,t){},n.prototype.destroy=function(){},n.prototype.generateResultId=function(e,t){var n=e.id+"-result-";return n+=i.generateChars(4),null!=t.id?n+="-"+t.id.toString():n+="-"+i.generateChars(4),n},n}),e.define("select2/data/select",["./base","../utils","jquery"],function(e,a,l){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return a.Extend(n,e),n.prototype.current=function(e){var n=[],i=this;this.$element.find(":selected").each(function(){var e=l(this),t=i.item(e);n.push(t)}),e(n)},n.prototype.select=function(r){var o=this;if(r.selected=!0,l(r.element).is("option"))return r.element.selected=!0,void this.$element.trigger("input").trigger("change");if(this.$element.prop("multiple"))this.current(function(e){var t=[];(r=[r]).push.apply(r,e);for(var n=0;n<r.length;n++){var i=r[n].id;-1===l.inArray(i,t)&&t.push(i)}o.$element.val(t),o.$element.trigger("input").trigger("change")});else{var e=r.id;this.$element.val(e),this.$element.trigger("input").trigger("change")}},n.prototype.unselect=function(r){var o=this;if(this.$element.prop("multiple")){if(r.selected=!1,l(r.element).is("option"))return r.element.selected=!1,void this.$element.trigger("input").trigger("change");this.current(function(e){for(var t=[],n=0;n<e.length;n++){var i=e[n].id;i!==r.id&&-1===l.inArray(i,t)&&t.push(i)}o.$element.val(t),o.$element.trigger("input").trigger("change")})}},n.prototype.bind=function(e,t){var n=this;(this.container=e).on("select",function(e){n.select(e.data)}),e.on("unselect",function(e){n.unselect(e.data)})},n.prototype.destroy=function(){this.$element.find("*").each(function(){a.RemoveData(this)})},n.prototype.query=function(i,e){var r=[],o=this;this.$element.children().each(function(){var e=l(this);if(e.is("option")||e.is("optgroup")){var t=o.item(e),n=o.matches(i,t);null!==n&&r.push(n)}}),e({results:r})},n.prototype.addOptions=function(e){a.appendMany(this.$element,e)},n.prototype.option=function(e){var t;e.children?(t=document.createElement("optgroup")).label=e.text:void 0!==(t=document.createElement("option")).textContent?t.textContent=e.text:t.innerText=e.text,void 0!==e.id&&(t.value=e.id),e.disabled&&(t.disabled=!0),e.selected&&(t.selected=!0),e.title&&(t.title=e.title);var n=l(t),i=this._normalizeItem(e);return i.element=t,a.StoreData(t,"data",i),n},n.prototype.item=function(e){var t={};if(null!=(t=a.GetData(e[0],"data")))return t;if(e.is("option"))t={id:e.val(),text:e.text(),disabled:e.prop("disabled"),selected:e.prop("selected"),title:e.prop("title")};else if(e.is("optgroup")){t={text:e.prop("label"),children:[],title:e.prop("title")};for(var n=e.children("option"),i=[],r=0;r<n.length;r++){var o=l(n[r]),s=this.item(o);i.push(s)}t.children=i}return(t=this._normalizeItem(t)).element=e[0],a.StoreData(e[0],"data",t),t},n.prototype._normalizeItem=function(e){e!==Object(e)&&(e={id:e,text:e});return null!=(e=l.extend({},{text:""},e)).id&&(e.id=e.id.toString()),null!=e.text&&(e.text=e.text.toString()),null==e._resultId&&e.id&&null!=this.container&&(e._resultId=this.generateResultId(this.container,e)),l.extend({},{selected:!1,disabled:!1},e)},n.prototype.matches=function(e,t){return this.options.get("matcher")(e,t)},n}),e.define("select2/data/array",["./select","../utils","jquery"],function(e,f,g){function i(e,t){this._dataToConvert=t.get("data")||[],i.__super__.constructor.call(this,e,t)}return f.Extend(i,e),i.prototype.bind=function(e,t){i.__super__.bind.call(this,e,t),this.addOptions(this.convertToOptions(this._dataToConvert))},i.prototype.select=function(n){var e=this.$element.find("option").filter(function(e,t){return t.value==n.id.toString()});0===e.length&&(e=this.option(n),this.addOptions(e)),i.__super__.select.call(this,n)},i.prototype.convertToOptions=function(e){var t=this,n=this.$element.find("option"),i=n.map(function(){return t.item(g(this)).id}).get(),r=[];function o(e){return function(){return g(this).val()==e.id}}for(var s=0;s<e.length;s++){var a=this._normalizeItem(e[s]);if(0<=g.inArray(a.id,i)){var l=n.filter(o(a)),c=this.item(l),u=g.extend(!0,{},a,c),d=this.option(u);l.replaceWith(d)}else{var p=this.option(a);if(a.children){var h=this.convertToOptions(a.children);f.appendMany(p,h)}r.push(p)}}return r},i}),e.define("select2/data/ajax",["./array","../utils","jquery"],function(e,t,o){function n(e,t){this.ajaxOptions=this._applyDefaults(t.get("ajax")),null!=this.ajaxOptions.processResults&&(this.processResults=this.ajaxOptions.processResults),n.__super__.constructor.call(this,e,t)}return t.Extend(n,e),n.prototype._applyDefaults=function(e){var t={data:function(e){return o.extend({},e,{q:e.term})},transport:function(e,t,n){var i=o.ajax(e);return i.then(t),i.fail(n),i}};return o.extend({},t,e,!0)},n.prototype.processResults=function(e){return e},n.prototype.query=function(n,i){var r=this;null!=this._request&&(typeof this._request.abort==='function'&&this._request.abort(),this._request=null);var t=o.extend({type:"GET"},this.ajaxOptions);function e(){var e=t.transport(t,function(e){var t=r.processResults(e,n);r.options.get("debug")&&console&&console.error&&(t&&t.results&&o.isArray(t.results)||console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")),i(t)},function(){"status"in e&&(0===e.status||"0"===e.status)||r.trigger("results:message",{message:"errorLoading"})});r._request=e}"function"==typeof t.url&&(t.url=t.url.call(this.$element,n)),"function"==typeof t.data&&(t.data=t.data.call(this.$element,n)),this.ajaxOptions.delay&&null!=n.term?(this._queryTimeout&&clearTimeout(this._queryTimeout),this._queryTimeout=setTimeout(e,this.ajaxOptions.delay)):e()},n}),e.define("select2/data/tags",["jquery"],function(u){function e(e,t,n){var i=n.get("tags"),r=n.get("createTag");void 0!==r&&(this.createTag=r);var o=n.get("insertTag");if(void 0!==o&&(this.insertTag=o),e.call(this,t,n),u.isArray(i))for(var s=0;s<i.length;s++){var a=i[s],l=this._normalizeItem(a),c=this.option(l);this.$element.append(c)}}return e.prototype.query=function(e,c,u){var d=this;this._removeOldTags(),null!=c.term&&null==c.page?e.call(this,c,function e(t,n){for(var i=t.results,r=0;r<i.length;r++){var o=i[r],s=null!=o.children&&!e({results:o.children},!0);if((o.text||"").toUpperCase()===(c.term||"").toUpperCase()||s)return!n&&(t.data=i,void u(t))}if(n)return!0;var a=d.createTag(c);if(null!=a){var l=d.option(a);l.attr("data-select2-tag",!0),d.addOptions([l]),d.insertTag(i,a)}t.results=i,u(t)}):e.call(this,c,u)},e.prototype.createTag=function(e,t){var n=u.trim(t.term);return""===n?null:{id:n,text:n}},e.prototype.insertTag=function(e,t,n){t.unshift(n)},e.prototype._removeOldTags=function(e){this.$element.find("option[data-select2-tag]").each(function(){this.selected||u(this).remove()})},e}),e.define("select2/data/tokenizer",["jquery"],function(d){function e(e,t,n){var i=n.get("tokenizer");void 0!==i&&(this.tokenizer=i),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){e.call(this,t,n),this.$search=t.dropdown.$search||t.selection.$search||n.find(".select2-search__field")},e.prototype.query=function(e,t,n){var r=this;t.term=t.term||"";var i=this.tokenizer(t,this.options,function(e){var t,n=r._normalizeItem(e);if(!r.$element.find("option").filter(function(){return d(this).val()===n.id}).length){var i=r.option(n);i.attr("data-select2-tag",!0),r._removeOldTags(),r.addOptions([i])}t=n,r.trigger("select",{data:t})});i.term!==t.term&&(this.$search.length&&(this.$search.val(i.term),this.$search.trigger("focus")),t.term=i.term),e.call(this,t,n)},e.prototype.tokenizer=function(e,t,n,i){for(var r=n.get("tokenSeparators")||[],o=t.term,s=0,a=this.createTag||function(e){return{id:e.term,text:e.term}};s<o.length;){var l=o[s];if(-1!==d.inArray(l,r)){var c=o.substr(0,s),u=a(d.extend({},t,{term:c}));null!=u?(i(u),o=o.substr(s+1)||"",s=0):s++}else s++}return{term:o}},e}),e.define("select2/data/minimumInputLength",[],function(){function e(e,t,n){this.minimumInputLength=n.get("minimumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",t.term.length<this.minimumInputLength?this.trigger("results:message",{message:"inputTooShort",args:{minimum:this.minimumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),e.define("select2/data/maximumInputLength",[],function(){function e(e,t,n){this.maximumInputLength=n.get("maximumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",0<this.maximumInputLength&&t.term.length>this.maximumInputLength?this.trigger("results:message",{message:"inputTooLong",args:{maximum:this.maximumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),e.define("select2/data/maximumSelectionLength",[],function(){function e(e,t,n){this.maximumSelectionLength=n.get("maximumSelectionLength"),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),t.on("select",function(){i._checkIfMaximumSelected()})},e.prototype.query=function(e,t,n){var i=this;this._checkIfMaximumSelected(function(){e.call(i,t,n)})},e.prototype._checkIfMaximumSelected=function(e,n){var i=this;this.current(function(e){var t=null!=e?e.length:0;0<i.maximumSelectionLength&&t>=i.maximumSelectionLength?i.trigger("results:message",{message:"maximumSelected",args:{maximum:i.maximumSelectionLength}}):n&&n()})},e}),e.define("select2/dropdown",["jquery","./utils"],function(t,e){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return e.Extend(n,e.Observable),n.prototype.render=function(){var e=t('<span class="select2-dropdown"><span class="select2-results"></span></span>');return e.attr("dir",this.options.get("dir")),this.$dropdown=e},n.prototype.bind=function(){},n.prototype.position=function(e,t){},n.prototype.destroy=function(){this.$dropdown.remove()},n}),e.define("select2/dropdown/search",["jquery","../utils"],function(o,e){function t(){}return t.prototype.render=function(e){var t=e.call(this),n=o('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></span>');return this.$searchContainer=n,this.$search=n.find("input"),t.prepend(n),t},t.prototype.bind=function(e,t,n){var i=this,r=t.id+"-results";e.call(this,t,n),this.$search.on("keydown",function(e){i.trigger("keypress",e),i._keyUpPrevented=e.isDefaultPrevented()}),this.$search.on("input",function(e){o(this).off("keyup")}),this.$search.on("keyup input",function(e){i.handleSearch(e)}),t.on("open",function(){i.$search.attr("tabindex",0),i.$search.attr("aria-controls",r),i.$search.trigger("focus"),setTimeout(function(){i.$search.trigger("focus")},0)}),t.on("close",function(){i.$search.attr("tabindex",-1),i.$search.removeAttr("aria-controls"),i.$search.removeAttr("aria-activedescendant"),i.$search.val(""),i.$search.trigger("blur")}),t.on("focus",function(){t.isOpen()||i.$search.trigger("focus")}),t.on("results:all",function(e){null!=e.query.term&&""!==e.query.term||(i.showSearch(e)?i.$searchContainer.removeClass("select2-search--hide"):i.$searchContainer.addClass("select2-search--hide"))}),t.on("results:focus",function(e){e.data._resultId?i.$search.attr("aria-activedescendant",e.data._resultId):i.$search.removeAttr("aria-activedescendant")})},t.prototype.handleSearch=function(e){if(!this._keyUpPrevented){var t=this.$search.val();this.trigger("query",{term:t})}this._keyUpPrevented=!1},t.prototype.showSearch=function(e,t){return!0},t}),e.define("select2/dropdown/hidePlaceholder",[],function(){function e(e,t,n,i){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n,i)}return e.prototype.append=function(e,t){t.results=this.removePlaceholder(t.results),e.call(this,t)},e.prototype.normalizePlaceholder=function(e,t){return"string"==typeof t&&(t={id:"",text:t}),t},e.prototype.removePlaceholder=function(e,t){for(var n=t.slice(0),i=t.length-1;0<=i;i--){var r=t[i];this.placeholder.id===r.id&&n.splice(i,1)}return n},e}),e.define("select2/dropdown/infiniteScroll",["jquery"],function(n){function e(e,t,n,i){this.lastParams={},e.call(this,t,n,i),this.$loadingMore=this.createLoadingMore(),this.loading=!1}return e.prototype.append=function(e,t){this.$loadingMore.remove(),this.loading=!1,e.call(this,t),this.showLoadingMore(t)&&(this.$results.append(this.$loadingMore),this.loadMoreIfNeeded())},e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),t.on("query",function(e){i.lastParams=e,i.loading=!0}),t.on("query:append",function(e){i.lastParams=e,i.loading=!0}),this.$results.on("scroll",this.loadMoreIfNeeded.bind(this))},e.prototype.loadMoreIfNeeded=function(){var e=n.contains(document.documentElement,this.$loadingMore[0]);if(!this.loading&&e){var t=this.$results.offset().top+this.$results.outerHeight(!1);this.$loadingMore.offset().top+this.$loadingMore.outerHeight(!1)<=t+50&&this.loadMore()}},e.prototype.loadMore=function(){this.loading=!0;var e=n.extend({},{page:1},this.lastParams);e.page++,this.trigger("query:append",e)},e.prototype.showLoadingMore=function(e,t){return t.pagination&&t.pagination.more},e.prototype.createLoadingMore=function(){var e=n('<li class="select2-results__option select2-results__option--load-more"role="option" aria-disabled="true"></li>'),t=this.options.get("translations").get("loadingMore");return e.html(t(this.lastParams)),e},e}),e.define("select2/dropdown/attachBody",["jquery","../utils"],function(f,a){function e(e,t,n){this.$dropdownParent=f(n.get("dropdownParent")||document.body),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),t.on("open",function(){i._showDropdown(),i._attachPositioningHandler(t),i._bindContainerResultHandlers(t)}),t.on("close",function(){i._hideDropdown(),i._detachPositioningHandler(t)}),this.$dropdownContainer.on("mousedown",function(e){e.stopPropagation()})},e.prototype.destroy=function(e){e.call(this),this.$dropdownContainer.remove()},e.prototype.position=function(e,t,n){t.attr("class",n.attr("class")),t.removeClass("select2"),t.addClass("select2-container--open"),t.css({position:"absolute",top:-999999}),this.$container=n},e.prototype.render=function(e){var t=f("<span></span>"),n=e.call(this);return t.append(n),this.$dropdownContainer=t},e.prototype._hideDropdown=function(e){this.$dropdownContainer.detach()},e.prototype._bindContainerResultHandlers=function(e,t){if(!this._containerResultsHandlersBound){var n=this;t.on("results:all",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:append",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:message",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("select",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("unselect",function(){n._positionDropdown(),n._resizeDropdown()}),this._containerResultsHandlersBound=!0}},e.prototype._attachPositioningHandler=function(e,t){var n=this,i="scroll.select2."+t.id,r="resize.select2."+t.id,o="orientationchange.select2."+t.id,s=this.$container.parents().filter(a.hasScroll);s.each(function(){a.StoreData(this,"select2-scroll-position",{x:f(this).scrollLeft(),y:f(this).scrollTop()})}),s.on(i,function(e){var t=a.GetData(this,"select2-scroll-position");f(this).scrollTop(t.y)}),f(window).on(i+" "+r+" "+o,function(e){n._positionDropdown(),n._resizeDropdown()})},e.prototype._detachPositioningHandler=function(e,t){var n="scroll.select2."+t.id,i="resize.select2."+t.id,r="orientationchange.select2."+t.id;this.$container.parents().filter(a.hasScroll).off(n),f(window).off(n+" "+i+" "+r)},e.prototype._positionDropdown=function(){var e=f(window),t=this.$dropdown.hasClass("select2-dropdown--above"),n=this.$dropdown.hasClass("select2-dropdown--below"),i=null,r=this.$container.offset();r.bottom=r.top+this.$container.outerHeight(!1);var o={height:this.$container.outerHeight(!1)};o.top=r.top,o.bottom=r.top+o.height;var s=this.$dropdown.outerHeight(!1),a=e.scrollTop(),l=e.scrollTop()+e.height(),c=a<r.top-s,u=l>r.bottom+s,d={left:r.left,top:o.bottom},p=this.$dropdownParent;"static"===p.css("position")&&(p=p.offsetParent());var h={top:0,left:0};(f.contains(document.body,p[0])||p[0].isConnected)&&(h=p.offset()),d.top-=h.top,d.left-=h.left,t||n||(i="below"),u||!c||t?!c&&u&&t&&(i="below"):i="above",("above"==i||t&&"below"!==i)&&(d.top=o.top-h.top-s),null!=i&&(this.$dropdown.removeClass("select2-dropdown--below select2-dropdown--above").addClass("select2-dropdown--"+i),this.$container.removeClass("select2-container--below select2-container--above").addClass("select2-container--"+i)),this.$dropdownContainer.css(d)},e.prototype._resizeDropdown=function(){var e={width:this.$container.outerWidth(!1)+"px"};this.options.get("dropdownAutoWidth")&&(e.minWidth=e.width,e.position="relative",e.width="auto"),this.$dropdown.css(e)},e.prototype._showDropdown=function(e){this.$dropdownContainer.appendTo(this.$dropdownParent),this._positionDropdown(),this._resizeDropdown()},e}),e.define("select2/dropdown/minimumResultsForSearch",[],function(){function e(e,t,n,i){this.minimumResultsForSearch=n.get("minimumResultsForSearch"),this.minimumResultsForSearch<0&&(this.minimumResultsForSearch=1/0),e.call(this,t,n,i)}return e.prototype.showSearch=function(e,t){return!(function e(t){for(var n=0,i=0;i<t.length;i++){var r=t[i];r.children?n+=e(r.children):n++}return n}(t.data.results)<this.minimumResultsForSearch)&&e.call(this,t)},e}),e.define("select2/dropdown/selectOnClose",["../utils"],function(o){function e(){}return e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),t.on("close",function(e){i._handleSelectOnClose(e)})},e.prototype._handleSelectOnClose=function(e,t){if(t&&null!=t.originalSelect2Event){var n=t.originalSelect2Event;if("select"===n._type||"unselect"===n._type)return}var i=this.getHighlightedResults();if(!(i.length<1)){var r=o.GetData(i[0],"data");null!=r.element&&r.element.selected||null==r.element&&r.selected||this.trigger("select",{data:r})}},e}),e.define("select2/dropdown/closeOnSelect",[],function(){function e(){}return e.prototype.bind=function(e,t,n){var i=this;e.call(this,t,n),t.on("select",function(e){i._selectTriggered(e)}),t.on("unselect",function(e){i._selectTriggered(e)})},e.prototype._selectTriggered=function(e,t){var n=t.originalEvent;n&&(n.ctrlKey||n.metaKey)||this.trigger("close",{originalEvent:n,originalSelect2Event:t})},e}),e.define("select2/i18n/en",[],function(){return{errorLoading:function(){return"The results could not be loaded."},inputTooLong:function(e){var t=e.input.length-e.maximum,n="Please delete "+t+" character";return 1!=t&&(n+="s"),n},inputTooShort:function(e){return"Please enter "+(e.minimum-e.input.length)+" or more characters"},loadingMore:function(){return"Loading more results…"},maximumSelected:function(e){var t="You can only select "+e.maximum+" item";return 1!=e.maximum&&(t+="s"),t},noResults:function(){return"No results found"},searching:function(){return"Searching…"},removeAllItems:function(){return"Remove all items"}}}),e.define("select2/defaults",["jquery","require","./results","./selection/single","./selection/multiple","./selection/placeholder","./selection/allowClear","./selection/search","./selection/eventRelay","./utils","./translation","./diacritics","./data/select","./data/array","./data/ajax","./data/tags","./data/tokenizer","./data/minimumInputLength","./data/maximumInputLength","./data/maximumSelectionLength","./dropdown","./dropdown/search","./dropdown/hidePlaceholder","./dropdown/infiniteScroll","./dropdown/attachBody","./dropdown/minimumResultsForSearch","./dropdown/selectOnClose","./dropdown/closeOnSelect","./i18n/en"],function(c,u,d,p,h,f,g,m,v,y,s,t,_,w,$,b,A,x,D,S,C,E,O,T,q,j,L,I,e){function n(){this.reset()}return n.prototype.apply=function(e){if(null==(e=c.extend(!0,{},this.defaults,e)).dataAdapter){if(null!=e.ajax?e.dataAdapter=$:null!=e.data?e.dataAdapter=w:e.dataAdapter=_,0<e.minimumInputLength&&(e.dataAdapter=y.Decorate(e.dataAdapter,x)),0<e.maximumInputLength&&(e.dataAdapter=y.Decorate(e.dataAdapter,D)),0<e.maximumSelectionLength&&(e.dataAdapter=y.Decorate(e.dataAdapter,S)),e.tags&&(e.dataAdapter=y.Decorate(e.dataAdapter,b)),null==e.tokenSeparators&&null==e.tokenizer||(e.dataAdapter=y.Decorate(e.dataAdapter,A)),null!=e.query){var t=u(e.amdBase+"compat/query");e.dataAdapter=y.Decorate(e.dataAdapter,t)}if(null!=e.initSelection){var n=u(e.amdBase+"compat/initSelection");e.dataAdapter=y.Decorate(e.dataAdapter,n)}}if(null==e.resultsAdapter&&(e.resultsAdapter=d,null!=e.ajax&&(e.resultsAdapter=y.Decorate(e.resultsAdapter,T)),null!=e.placeholder&&(e.resultsAdapter=y.Decorate(e.resultsAdapter,O)),e.selectOnClose&&(e.resultsAdapter=y.Decorate(e.resultsAdapter,L))),null==e.dropdownAdapter){if(e.multiple)e.dropdownAdapter=C;else{var i=y.Decorate(C,E);e.dropdownAdapter=i}if(0!==e.minimumResultsForSearch&&(e.dropdownAdapter=y.Decorate(e.dropdownAdapter,j)),e.closeOnSelect&&(e.dropdownAdapter=y.Decorate(e.dropdownAdapter,I)),null!=e.dropdownCssClass||null!=e.dropdownCss||null!=e.adaptDropdownCssClass){var r=u(e.amdBase+"compat/dropdownCss");e.dropdownAdapter=y.Decorate(e.dropdownAdapter,r)}e.dropdownAdapter=y.Decorate(e.dropdownAdapter,q)}if(null==e.selectionAdapter){if(e.multiple?e.selectionAdapter=h:e.selectionAdapter=p,null!=e.placeholder&&(e.selectionAdapter=y.Decorate(e.selectionAdapter,f)),e.allowClear&&(e.selectionAdapter=y.Decorate(e.selectionAdapter,g)),e.multiple&&(e.selectionAdapter=y.Decorate(e.selectionAdapter,m)),null!=e.containerCssClass||null!=e.containerCss||null!=e.adaptContainerCssClass){var o=u(e.amdBase+"compat/containerCss");e.selectionAdapter=y.Decorate(e.selectionAdapter,o)}e.selectionAdapter=y.Decorate(e.selectionAdapter,v)}e.language=this._resolveLanguage(e.language),e.language.push("en");for(var s=[],a=0;a<e.language.length;a++){var l=e.language[a];-1===s.indexOf(l)&&s.push(l)}return e.language=s,e.translations=this._processTranslations(e.language,e.debug),e},n.prototype.reset=function(){function a(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return t[e]||e})}this.defaults={amdBase:"./",amdLanguageBase:"./i18n/",closeOnSelect:!0,debug:!1,dropdownAutoWidth:!1,escapeMarkup:y.escapeMarkup,language:{},matcher:function e(t,n){if(""===c.trim(t.term))return n;if(n.children&&0<n.children.length){for(var i=c.extend(!0,{},n),r=n.children.length-1;0<=r;r--)null==e(t,n.children[r])&&i.children.splice(r,1);return 0<i.children.length?i:e(t,i)}var o=a(n.text).toUpperCase(),s=a(t.term).toUpperCase();return-1<o.indexOf(s)?n:null},minimumInputLength:0,maximumInputLength:0,maximumSelectionLength:0,minimumResultsForSearch:0,selectOnClose:!1,scrollAfterSelect:!1,sorter:function(e){return e},templateResult:function(e){return e.text},templateSelection:function(e){return e.text},theme:"default",width:"resolve"}},n.prototype.applyFromElement=function(e,t){var n=e.language,i=this.defaults.language,r=t.prop("lang"),o=t.closest("[lang]").prop("lang"),s=Array.prototype.concat.call(this._resolveLanguage(r),this._resolveLanguage(n),this._resolveLanguage(i),this._resolveLanguage(o));return e.language=s,e},n.prototype._resolveLanguage=function(e){if(!e)return[];if(c.isEmptyObject(e))return[];if(c.isPlainObject(e))return[e];var t;t=c.isArray(e)?e:[e];for(var n=[],i=0;i<t.length;i++)if(n.push(t[i]),"string"==typeof t[i]&&0<t[i].indexOf("-")){var r=t[i].split("-")[0];n.push(r)}return n},n.prototype._processTranslations=function(e,t){for(var n=new s,i=0;i<e.length;i++){var r=new s,o=e[i];if("string"==typeof o)try{r=s.loadPath(o)}catch(e){try{o=this.defaults.amdLanguageBase+o,r=s.loadPath(o)}catch(e){t&&console&&console.warn&&console.warn('Select2: The language file for "'+o+'" could not be automatically loaded. A fallback will be used instead.')}}else r=c.isPlainObject(o)?new s(o):o;n.extend(r)}return n},n.prototype.set=function(e,t){var n={};n[c.camelCase(e)]=t;var i=y._convertData(n);c.extend(!0,this.defaults,i)},new n}),e.define("select2/options",["require","jquery","./defaults","./utils"],function(i,d,r,p){function e(e,t){if(this.options=e,null!=t&&this.fromElement(t),null!=t&&(this.options=r.applyFromElement(this.options,t)),this.options=r.apply(this.options),t&&t.is("input")){var n=i(this.get("amdBase")+"compat/inputData");this.options.dataAdapter=p.Decorate(this.options.dataAdapter,n)}}return e.prototype.fromElement=function(e){var t=["select2"];null==this.options.multiple&&(this.options.multiple=e.prop("multiple")),null==this.options.disabled&&(this.options.disabled=e.prop("disabled")),null==this.options.dir&&(e.prop("dir")?this.options.dir=e.prop("dir"):e.closest("[dir]").prop("dir")?this.options.dir=e.closest("[dir]").prop("dir"):this.options.dir="ltr"),e.prop("disabled",this.options.disabled),e.prop("multiple",this.options.multiple),p.GetData(e[0],"select2Tags")&&(this.options.debug&&console&&console.warn&&console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'),p.StoreData(e[0],"data",p.GetData(e[0],"select2Tags")),p.StoreData(e[0],"tags",!0)),p.GetData(e[0],"ajaxUrl")&&(this.options.debug&&console&&console.warn&&console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."),e.attr("ajax--url",p.GetData(e[0],"ajaxUrl")),p.StoreData(e[0],"ajax-Url",p.GetData(e[0],"ajaxUrl")));var n={};function i(e,t){return t.toUpperCase()}for(var r=0;r<e[0].attributes.length;r++){var o=e[0].attributes[r].name,s="data-";if(o.substr(0,s.length)==s){var a=o.substring(s.length),l=p.GetData(e[0],a);n[a.replace(/-([a-z])/g,i)]=l}}d.fn.jquery&&"1."==d.fn.jquery.substr(0,2)&&e[0].dataset&&(n=d.extend(!0,{},e[0].dataset,n));var c=d.extend(!0,{},p.GetData(e[0]),n);for(var u in c=p._convertData(c))-1<d.inArray(u,t)||(d.isPlainObject(this.options[u])?d.extend(this.options[u],c[u]):this.options[u]=c[u]);return this},e.prototype.get=function(e){return this.options[e]},e.prototype.set=function(e,t){this.options[e]=t},e}),e.define("select2/core",["jquery","./options","./utils","./keys"],function(o,c,u,i){var d=function(e,t){null!=u.GetData(e[0],"select2")&&u.GetData(e[0],"select2").destroy(),this.$element=e,this.id=this._generateId(e),t=t||{},this.options=new c(t,e),d.__super__.constructor.call(this);var n=e.attr("tabindex")||0;u.StoreData(e[0],"old-tabindex",n),e.attr("tabindex","-1");var i=this.options.get("dataAdapter");this.dataAdapter=new i(e,this.options);var r=this.render();this._placeContainer(r);var o=this.options.get("selectionAdapter");this.selection=new o(e,this.options),this.$selection=this.selection.render(),this.selection.position(this.$selection,r);var s=this.options.get("dropdownAdapter");this.dropdown=new s(e,this.options),this.$dropdown=this.dropdown.render(),this.dropdown.position(this.$dropdown,r);var a=this.options.get("resultsAdapter");this.results=new a(e,this.options,this.dataAdapter),this.$results=this.results.render(),this.results.position(this.$results,this.$dropdown);var l=this;this._bindAdapters(),this._registerDomEvents(),this._registerDataEvents(),this._registerSelectionEvents(),this._registerDropdownEvents(),this._registerResultsEvents(),this._registerEvents(),this.dataAdapter.current(function(e){l.trigger("selection:update",{data:e})}),e.addClass("select2-hidden-accessible"),e.attr("aria-hidden","true"),this._syncAttributes(),u.StoreData(e[0],"select2",this),e.data("select2",this)};return u.Extend(d,u.Observable),d.prototype._generateId=function(e){return"select2-"+(null!=e.attr("id")?e.attr("id"):null!=e.attr("name")?e.attr("name")+"-"+u.generateChars(2):u.generateChars(4)).replace(/(:|\.|\[|\]|,)/g,"")},d.prototype._placeContainer=function(e){e.insertAfter(this.$element);var t=this._resolveWidth(this.$element,this.options.get("width"));null!=t&&e.css("width",t)},d.prototype._resolveWidth=function(e,t){var n=/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;if("resolve"==t){var i=this._resolveWidth(e,"style");return null!=i?i:this._resolveWidth(e,"element")}if("element"==t){var r=e.outerWidth(!1);return r<=0?"auto":r+"px"}if("style"!=t)return"computedstyle"!=t?t:getComputedStyle(e[0]).width;var o=e.attr("style");if("string"!=typeof o)return null;for(var s=o.split(";"),a=0,l=s.length;a<l;a+=1){var c=s[a].replace(/\s/g,"").match(n);if(null!==c&&1<=c.length)return c[1]}return null},d.prototype._bindAdapters=function(){this.dataAdapter.bind(this,this.$container),this.selection.bind(this,this.$container),this.dropdown.bind(this,this.$container),this.results.bind(this,this.$container)},d.prototype._registerDomEvents=function(){var t=this;this.$element.on("change.select2",function(){t.dataAdapter.current(function(e){t.trigger("selection:update",{data:e})})}),this.$element.on("focus.select2",function(e){t.trigger("focus",e)}),this._syncA=u.bind(this._syncAttributes,this),this._syncS=u.bind(this._syncSubtree,this),this.$element[0].attachEvent&&this.$element[0].attachEvent("onpropertychange",this._syncA);var e=MutationObserver||WebKitMutationObserver||MozMutationObserver;null!=e?(this._observer=new e(function(e){t._syncA(),t._syncS(null,e)}),this._observer.observe(this.$element[0],{attributes:!0,childList:!0,subtree:!1})):this.$element[0].addEventListener&&(this.$element[0].addEventListener("DOMAttrModified",t._syncA,!1),this.$element[0].addEventListener("DOMNodeInserted",t._syncS,!1),this.$element[0].addEventListener("DOMNodeRemoved",t._syncS,!1))},d.prototype._registerDataEvents=function(){var n=this;this.dataAdapter.on("*",function(e,t){n.trigger(e,t)})},d.prototype._registerSelectionEvents=function(){var n=this,i=["toggle","focus"];this.selection.on("toggle",function(){n.toggleDropdown()}),this.selection.on("focus",function(e){n.focus(e)}),this.selection.on("*",function(e,t){-1===o.inArray(e,i)&&n.trigger(e,t)})},d.prototype._registerDropdownEvents=function(){var n=this;this.dropdown.on("*",function(e,t){n.trigger(e,t)})},d.prototype._registerResultsEvents=function(){var n=this;this.results.on("*",function(e,t){n.trigger(e,t)})},d.prototype._registerEvents=function(){var n=this;this.on("open",function(){n.$container.addClass("select2-container--open")}),this.on("close",function(){n.$container.removeClass("select2-container--open")}),this.on("enable",function(){n.$container.removeClass("select2-container--disabled")}),this.on("disable",function(){n.$container.addClass("select2-container--disabled")}),this.on("blur",function(){n.$container.removeClass("select2-container--focus")}),this.on("query",function(t){n.isOpen()||n.trigger("open",{}),this.dataAdapter.query(t,function(e){n.trigger("results:all",{data:e,query:t})})}),this.on("query:append",function(t){this.dataAdapter.query(t,function(e){n.trigger("results:append",{data:e,query:t})})}),this.on("keypress",function(e){var t=e.which;n.isOpen()?t===i.ESC||t===i.TAB||t===i.UP&&e.altKey?(n.close(e),e.preventDefault()):t===i.ENTER?(n.trigger("results:select",{}),e.preventDefault()):t===i.SPACE&&e.ctrlKey?(n.trigger("results:toggle",{}),e.preventDefault()):t===i.UP?(n.trigger("results:previous",{}),e.preventDefault()):t===i.DOWN&&(n.trigger("results:next",{}),e.preventDefault()):(t===i.ENTER||t===i.SPACE||t===i.DOWN&&e.altKey)&&(n.open(),e.preventDefault())})},d.prototype._syncAttributes=function(){this.options.set("disabled",this.$element.prop("disabled")),this.isDisabled()?(this.isOpen()&&this.close(),this.trigger("disable",{})):this.trigger("enable",{})},d.prototype._isChangeMutation=function(e,t){var n=!1,i=this;if(!e||!e.target||"OPTION"===e.target.nodeName||"OPTGROUP"===e.target.nodeName){if(t)if(t.addedNodes&&0<t.addedNodes.length)for(var r=0;r<t.addedNodes.length;r++){t.addedNodes[r].selected&&(n=!0)}else t.removedNodes&&0<t.removedNodes.length?n=!0:o.isArray(t)&&o.each(t,function(e,t){if(i._isChangeMutation(e,t))return!(n=!0)});else n=!0;return n}},d.prototype._syncSubtree=function(e,t){var n=this._isChangeMutation(e,t),i=this;n&&this.dataAdapter.current(function(e){i.trigger("selection:update",{data:e})})},d.prototype.trigger=function(e,t){var n=d.__super__.trigger,i={open:"opening",close:"closing",select:"selecting",unselect:"unselecting",clear:"clearing"};if(void 0===t&&(t={}),e in i){var r=i[e],o={prevented:!1,name:e,args:t};if(n.call(this,r,o),o.prevented)return void(t.prevented=!0)}n.call(this,e,t)},d.prototype.toggleDropdown=function(){this.isDisabled()||(this.isOpen()?this.close():this.open())},d.prototype.open=function(){this.isOpen()||this.isDisabled()||this.trigger("query",{})},d.prototype.close=function(e){this.isOpen()&&this.trigger("close",{originalEvent:e})},d.prototype.isEnabled=function(){return!this.isDisabled()},d.prototype.isDisabled=function(){return this.options.get("disabled")},d.prototype.isOpen=function(){return this.$container.hasClass("select2-container--open")},d.prototype.hasFocus=function(){return this.$container.hasClass("select2-container--focus")},d.prototype.focus=function(e){this.hasFocus()||(this.$container.addClass("select2-container--focus"),this.trigger("focus",{}))},d.prototype.enable=function(e){this.options.get("debug")&&console&&console.warn&&console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.'),null!=e&&0!==e.length||(e=[!0]);var t=!e[0];this.$element.prop("disabled",t)},d.prototype.data=function(){this.options.get("debug")&&0<arguments.length&&console&&console.warn&&console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');var t=[];return this.dataAdapter.current(function(e){t=e}),t},d.prototype.val=function(e){if(this.options.get("debug")&&console&&console.warn&&console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'),null==e||0===e.length)return this.$element.val();var t=e[0];o.isArray(t)&&(t=o.map(t,function(e){return e.toString()})),this.$element.val(t).trigger("input").trigger("change")},d.prototype.destroy=function(){this.$container.remove(),this.$element[0].detachEvent&&this.$element[0].detachEvent("onpropertychange",this._syncA),null!=this._observer?(this._observer.disconnect(),this._observer=null):this.$element[0].removeEventListener&&(this.$element[0].removeEventListener("DOMAttrModified",this._syncA,!1),this.$element[0].removeEventListener("DOMNodeInserted",this._syncS,!1),this.$element[0].removeEventListener("DOMNodeRemoved",this._syncS,!1)),this._syncA=null,this._syncS=null,this.$element.off(".select2"),this.$element.attr("tabindex",u.GetData(this.$element[0],"old-tabindex")),this.$element.removeClass("select2-hidden-accessible"),this.$element.attr("aria-hidden","false"),u.RemoveData(this.$element[0]),this.$element.removeData("select2"),this.dataAdapter.destroy(),this.selection.destroy(),this.dropdown.destroy(),this.results.destroy(),this.dataAdapter=null,this.selection=null,this.dropdown=null,this.results=null},d.prototype.render=function(){var e=o('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');return e.attr("dir",this.options.get("dir")),this.$container=e,this.$container.addClass("select2-container--"+this.options.get("theme")),u.StoreData(e[0],"element",this.$element),e},d}),e.define("select2/compat/utils",["jquery"],function(s){return{syncCssClasses:function(e,t,n){var i,r,o=[];(i=s.trim(e.attr("class")))&&s((i=""+i).split(/\s+/)).each(function(){0===this.indexOf("select2-")&&o.push(this)}),(i=s.trim(t.attr("class")))&&s((i=""+i).split(/\s+/)).each(function(){0!==this.indexOf("select2-")&&null!=(r=n(this))&&o.push(r)}),e.attr("class",o.join(" "))}}}),e.define("select2/compat/containerCss",["jquery","./utils"],function(s,a){function l(e){return null}function e(){}return e.prototype.render=function(e){var t=e.call(this),n=this.options.get("containerCssClass")||"";typeof n === 'function'&&(n=n(this.$element));var i=this.options.get("adaptContainerCssClass");if(i=i||l,-1!==n.indexOf(":all:")){n=n.replace(":all:","");var r=i;i=function(e){var t=r(e);return null!=t?t+" "+e:e}}var o=this.options.get("containerCss")||{};return typeof o === 'function'&&(o=o(this.$element)),a.syncCssClasses(t,this.$element,i),t.css(o),t.addClass(n),t},e}),e.define("select2/compat/dropdownCss",["jquery","./utils"],function(s,a){function l(e){return null}function e(){}return e.prototype.render=function(e){var t=e.call(this),n=this.options.get("dropdownCssClass")||"";typeof n==='function'&&(n=n(this.$element));var i=this.options.get("adaptDropdownCssClass");if(i=i||l,-1!==n.indexOf(":all:")){n=n.replace(":all:","");var r=i;i=function(e){var t=r(e);return null!=t?t+" "+e:e}}var o=this.options.get("dropdownCss")||{};return typeof o==='function'&&(o=o(this.$element)),a.syncCssClasses(t,this.$element,i),t.css(o),t.addClass(n),t},e}),e.define("select2/compat/initSelection",["jquery"],function(i){function e(e,t,n){n.get("debug")&&console&&console.warn&&console.warn("Select2: The `initSelection` option has been deprecated in favor of a custom data adapter that overrides the `current` method. This method is now called multiple times instead of a single time when the instance is initialized. Support will be removed for the `initSelection` option in future versions of Select2"),this.initSelection=n.get("initSelection"),this._isInitialized=!1,e.call(this,t,n)}return e.prototype.current=function(e,t){var n=this;this._isInitialized?e.call(this,t):this.initSelection.call(null,this.$element,function(e){n._isInitialized=!0,i.isArray(e)||(e=[e]),t(e)})},e}),e.define("select2/compat/inputData",["jquery","../utils"],function(s,i){function e(e,t,n){this._currentData=[],this._valueSeparator=n.get("valueSeparator")||",","hidden"===t.prop("type")&&n.get("debug")&&console&&console.warn&&console.warn("Select2: Using a hidden input with Select2 is no longer supported and may stop working in the future. It is recommended to use a `<select>` element instead."),e.call(this,t,n)}return e.prototype.current=function(e,t){function i(e,t){var n=[];return e.selected||-1!==s.inArray(e.id,t)?(e.selected=!0,n.push(e)):e.selected=!1,e.children&&n.push.apply(n,i(e.children,t)),n}for(var n=[],r=0;r<this._currentData.length;r++){var o=this._currentData[r];n.push.apply(n,i(o,this.$element.val().split(this._valueSeparator)))}t(n)},e.prototype.select=function(e,t){if(this.options.get("multiple")){var n=this.$element.val();n+=this._valueSeparator+t.id,this.$element.val(n),this.$element.trigger("input").trigger("change")}else this.current(function(e){s.map(e,function(e){e.selected=!1})}),this.$element.val(t.id),this.$element.trigger("input").trigger("change")},e.prototype.unselect=function(e,r){var o=this;r.selected=!1,this.current(function(e){for(var t=[],n=0;n<e.length;n++){var i=e[n];r.id!=i.id&&t.push(i.id)}o.$element.val(t.join(o._valueSeparator)),o.$element.trigger("input").trigger("change")})},e.prototype.query=function(e,t,n){for(var i=[],r=0;r<this._currentData.length;r++){var o=this._currentData[r],s=this.matches(t,o);null!==s&&i.push(s)}n({results:i})},e.prototype.addOptions=function(e,t){var n=s.map(t,function(e){return i.GetData(e[0],"data")});this._currentData.push.apply(this._currentData,n)},e}),e.define("select2/compat/matcher",["jquery"],function(s){return function(o){return function(e,t){var n=s.extend(!0,{},t);if(null==e.term||""===s.trim(e.term))return n;if(t.children){for(var i=t.children.length-1;0<=i;i--){var r=t.children[i];o(e.term,r.text,r)||n.children.splice(i,1)}if(0<n.children.length)return n}return o(e.term,t.text,t)?n:null}}}),e.define("select2/compat/query",[],function(){function e(e,t,n){n.get("debug")&&console&&console.warn&&console.warn("Select2: The `query` option has been deprecated in favor of a custom data adapter that overrides the `query` method. Support will be removed for the `query` option in future versions of Select2."),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.callback=n,this.options.get("query").call(null,t)},e}),e.define("select2/dropdown/attachContainer",[],function(){function e(e,t,n){e.call(this,t,n)}return e.prototype.position=function(e,t,n){n.find(".dropdown-wrapper").append(t),t.addClass("select2-dropdown--below"),n.addClass("select2-container--below")},e}),e.define("select2/dropdown/stopPropagation",[],function(){function e(){}return e.prototype.bind=function(e,t,n){e.call(this,t,n);this.$dropdown.on(["blur","change","click","dblclick","focus","focusin","focusout","input","keydown","keyup","keypress","mousedown","mouseenter","mouseleave","mousemove","mouseover","mouseup","search","touchend","touchstart"].join(" "),function(e){e.stopPropagation()})},e}),e.define("select2/selection/stopPropagation",[],function(){function e(){}return e.prototype.bind=function(e,t,n){e.call(this,t,n);this.$selection.on(["blur","change","click","dblclick","focus","focusin","focusout","input","keydown","keyup","keypress","mousedown","mouseenter","mouseleave","mousemove","mouseover","mouseup","search","touchend","touchstart"].join(" "),function(e){e.stopPropagation()})},e}),l=function(p){var h,f,e=["wheel","mousewheel","DOMMouseScroll","MozMousePixelScroll"],t="onwheel"in document||9<=document.documentMode?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"],g=Array.prototype.slice;if(p.event.fixHooks)for(var n=e.length;n;)p.event.fixHooks[e[--n]]=p.event.mouseHooks;var m=p.event.special.mousewheel={version:"3.1.12",setup:function(){if(this.addEventListener)for(var e=t.length;e;)this.addEventListener(t[--e],i,!1);else this.onmousewheel=i;p.data(this,"mousewheel-line-height",m.getLineHeight(this)),p.data(this,"mousewheel-page-height",m.getPageHeight(this))},teardown:function(){if(this.removeEventListener)for(var e=t.length;e;)this.removeEventListener(t[--e],i,!1);else this.onmousewheel=null;p.removeData(this,"mousewheel-line-height"),p.removeData(this,"mousewheel-page-height")},getLineHeight:function(e){var t=p(e),n=t["offsetParent"in p.fn?"offsetParent":"parent"]();return n.length||(n=p("body")),parseInt(n.css("fontSize"),10)||parseInt(t.css("fontSize"),10)||16},getPageHeight:function(e){return p(e).height()},settings:{adjustOldDeltas:!0,normalizeOffset:!0}};function i(e){var t,n=e||event,i=g.call(arguments,1),r=0,o=0,s=0,a=0,l=0;if((e=p.event.fix(n)).type="mousewheel","detail"in n&&(s=-1*n.detail),"wheelDelta"in n&&(s=n.wheelDelta),"wheelDeltaY"in n&&(s=n.wheelDeltaY),"wheelDeltaX"in n&&(o=-1*n.wheelDeltaX),"axis"in n&&n.axis===n.HORIZONTAL_AXIS&&(o=-1*s,s=0),r=0===s?o:s,"deltaY"in n&&(r=s=-1*n.deltaY),"deltaX"in n&&(o=n.deltaX,0===s&&(r=-1*o)),0!==s||0!==o){if(1===n.deltaMode){var c=p.data(this,"mousewheel-line-height");r*=c,s*=c,o*=c}else if(2===n.deltaMode){var u=p.data(this,"mousewheel-page-height");r*=u,s*=u,o*=u}if(t=Math.max(Math.abs(s),Math.abs(o)),(!f||t<f)&&y(n,f=t)&&(f/=40),y(n,t)&&(r/=40,o/=40,s/=40),r=Math[1<=r?"floor":"ceil"](r/f),o=Math[1<=o?"floor":"ceil"](o/f),s=Math[1<=s?"floor":"ceil"](s/f),m.settings.normalizeOffset&&this.getBoundingClientRect){var d=this.getBoundingClientRect();a=e.clientX-d.left,l=e.clientY-d.top}return e.deltaX=o,e.deltaY=s,e.deltaFactor=f,e.offsetX=a,e.offsetY=l,e.deltaMode=0,i.unshift(e,r,o,s),h&&clearTimeout(h),h=setTimeout(v,200),(p.event.dispatch||p.event.handle).apply(this,i)}}function v(){f=null}function y(e,t){return m.settings.adjustOldDeltas&&"mousewheel"===e.type&&t%120==0}p.fn.extend({mousewheel:function(e){return e?this.bind("mousewheel",e):this.trigger("mousewheel")},unmousewheel:function(e){return this.unbind("mousewheel",e)}})},"function"==typeof e.define&&e.define.amd?e.define("jquery-mousewheel",["jquery"],l):"object"==typeof exports?module.exports=l:l(d),e.define("jquery.select2",["jquery","jquery-mousewheel","./select2/core","./select2/defaults","./select2/utils"],function(r,e,o,t,s){if(null==r.fn.select2){var a=["open","close","destroy"];r.fn.select2=function(t){if("object"==typeof(t=t||{}))return this.each(function(){var e=r.extend(!0,{},t);new o(r(this),e)}),this;if("string"!=typeof t)throw new Error("Invalid arguments for Select2: "+t);var n,i=Array.prototype.slice.call(arguments,1);return this.each(function(){var e=s.GetData(this,"select2");null==e&&console&&console.error&&console.error("The select2('"+t+"') method was called on an element that is not using Select2."),n=e[t].apply(e,i)}),-1<r.inArray(t,a)?this:n}}return null==r.fn.select2.defaults&&(r.fn.select2.defaults=t),o}),{define:e.define,require:e.require}}(),t=e.require("jquery.select2");return d.fn.select2.amd=e,t});
var WAPF;
(function (WAPF) {
    var Components;
    (function (Components) {
        var FormulaBuilder = /** @class */ (function () {
            function FormulaBuilder(initiator, as, onChange) {
                if (as === void 0) { as = 'field'; }
                if (onChange === void 0) { onChange = null; }
                var _this = this;
                this.fields = [];
                this.vars = [];
                this.allFunctions = [];
                var timer = null;
                this.$initiator = initiator;
                this.$checkMsg = initiator.querySelector('.wapf-formula-check');
                this.$input = initiator.querySelector('input[type=text]');
                this.onChange = onChange;
                initiator.querySelectorAll('button[data-type="func"]').forEach(function (el) {
                    _this.allFunctions.push(el.dataset.symbol.replace('(', '').replace(')', ''));
                });
                this.$input.addEventListener('input', function () {
                    clearTimeout(timer);
                    timer = setTimeout(function () {
                        _this.validate();
                        if (_this.onChange)
                            _this.onChange(_this.$input.value);
                    }, 500);
                });
                initiator.addEventListener('click', function (e) {
                    if (e.target.tagName === 'BUTTON') {
                        e.preventDefault();
                        var symbol = e.target.dataset.symbol;
                        var newFormula = _this.$input.value + symbol;
                        _this.$input.value = newFormula;
                        _this.validate();
                        if (_this.onChange)
                            _this.onChange(newFormula);
                        e.stopPropagation();
                    }
                });
                jQuery(document).on('wapf/field/activated', function (e, field) {
                    if (field.type === 'calc' && as == 'field') {
                        _this.addVars();
                        _this.addFields();
                    }
                });
                jQuery(document).on('wapf/fields/change', function (e, fields, type, from) {
                    if (as === 'field' && type === 'change' && from === 'type') {
                        _this.addVars();
                        _this.addFields();
                    }
                });
            }
            FormulaBuilder.prototype.addVars = function (vars) {
                if (vars === void 0) { vars = null; }
                if (!vars)
                    vars = WAPF.Main.bindings['VariablesCtrl'].models.variables;
                this.vars = [
                    { id: '[price]', label: 'Product price' },
                    { id: '[qty]', label: 'Quantity' },
                    ];
                this.vars = this.vars.concat(vars.map(function (f) { return { id: '[var_' + f.name + ']', label: f.name }; }));
                this.addButtons('vars');
            };
            FormulaBuilder.prototype.addFields = function (fields) {
                if (fields === void 0) { fields = null; }
                if (!fields)
                    fields = WAPF.Main.bindings['FieldListCtrl'].models.fields;
                this.fields = [];
                this.fields = fields.filter(function (f) { return f.group == 'field' && f.type !== 'calc'; }).map(function (f) { return { id: '[field.' + f.id + ']', label: f.label }; });
                this.addButtons('fields');
            };
            FormulaBuilder.prototype.setFormula = function (f) {
                this.$input.value = f;
            };
            FormulaBuilder.prototype.addButtons = function (type) {
                var $list = this.$initiator.querySelector('.wapf-fb-' + type);
                if (!this[type].length) {
                    $list.style.display = 'none';
                    return;
                }
                var $buttons = $list.querySelector('.wapf-fb-buttons');
                $buttons.innerHTML = '';
                this[type].forEach(function (f, index) {
                    if (index > 20)
                        return;
                    var btn = document.createElement('button');
                    btn.innerText = f.label;
                    btn.dataset.type = type;
                    btn.dataset.symbol = f.id;
                    btn.classList.add('wapf-fb-btn-field');
                    btn.title = f.label;
                    var item = document.createElement('li');
                    item.appendChild(btn);
                    $buttons.appendChild(item);
                });
                $list.style.display = 'flex';
            };
            FormulaBuilder.prototype.validate = function () {
                var v = this.$input.value;
                if (!v.length) {
                    this.$checkMsg.style.display = 'none';
                    return;
                }
                var check = this.checkFormula(v);
                var msg = "We didn't find any syntax issues with this formula.";
                switch (check) {
                    case 1:
                        msg = "This formula has an invalid operand combination. Please check the syntax.";
                        break;
                    case 2:
                        msg = "You are closing a square bracket in the wrong place.";
                        break;
                    case 3:
                        msg = "You are closing a parenthesis in the wrong place.";
                        break;
                    case 4:
                        msg = "You need an equal amount of opening and closing brackets.";
                        break;
                    case 5:
                        msg = "You need an equal amount of opening and closing parentheses.";
                        break;
                    case 6:
                        msg = "We think perhaps your formula needs parentheses.";
                        break;
                    case 7:
                        msg = "You are using a field ID that does not exist in this field group.";
                        break;
                    case 8:
                        msg = "This formula has an invalid operand combination. Please check the syntax.";
                        break;
                    case 9:
                        msg = "This formula has a multiplier (*) in a wrong position.";
                        break;
                    case 10:
                        msg = "This formula has a division (/) in a wrong position.";
                        break;
                    case 11:
                        msg = "This formula has a sum (+) in a wrong position.";
                        break;
                }
                this.$checkMsg.innerText = msg;
                this.$checkMsg.style.color = check > 0 ? 'orange' : 'green';
                this.$checkMsg.style.display = 'block';
            };
            FormulaBuilder.prototype.checkFormula = function (formula) {
                formula = formula.trim();
                // Error: operand error.
                var checks = ['**', '++', '//', '*/', '/*', '-*', '+*', '*+', '*-', '-/', '+/', '/+', '/-', '[]'];
                for (var i = 0; i < checks.length; i++) {
                    if (formula.indexOf(checks[i]) > -1)
                        return 1;
                }
                var chars = formula.split('');
                var levelBrackets = 0;
                var levelParenthesis = 0;
                for (var i = 0; i < chars.length; i++) {
                    if (chars[i] === '[')
                        levelBrackets++;
                    if (chars[i] === ']')
                        levelBrackets--;
                    if (chars[i] === '(')
                        levelParenthesis++;
                    if (chars[i] === ')')
                        levelParenthesis--;
                    if (levelParenthesis < 0) {
                        return 2; // closing bracket before opening bracket
                    }
                    if (levelBrackets < 0) {
                        return 3; // closing bracket before opening bracket
                    }
                }
                if (levelBrackets > 0) {
                    return 4; // No equal brackets
                }
                if (levelParenthesis > 0) {
                    return 5; // No equal brackets
                }
                // Warning: check if field IDs exist. Warning because fields from other group can be used?
                var matches = formula.match(/\[field\..+?]/g);
                if (matches) {
                    for (var i = 0; i < matches.length; i++) {
                        if (this.fields.filter(function (f) { return f.id === matches[i]; }).length === 0)
                            return 7;
                    }
                }
                // If only operators, error
                if (!formula.replace(/[-+*/()[\]]/g, '').length) {
                    return 8;
                }
                var cc = function (str, letter) {
                    var c = 0;
                    for (var position = 0; position < str.length; position++) {
                        if (str.charAt(position) == letter) {
                            c++;
                        }
                    }
                    return c;
                };
                var containsAll = function (str, chars) {
                    for (i = 0; i < chars.length; i++) {
                        if (str.indexOf(chars[i]) == -1)
                            return false;
                    }
                    return true;
                };
                // Operands need a left and right part (execpt for minus so we do not do that here)
                var countMultiply = cc(formula, '*');
                if (countMultiply && formula.split('*').filter(function (x) { return x.length; }).length !== countMultiply + 1)
                    return 9;
                var countDiv = cc(formula, '/');
                if (countDiv && formula.split('/').filter(function (x) { return x.length; }).length !== countDiv + 1)
                    return 10;
                var countPlus = cc(formula, '+');
                if (countPlus && formula.split('+').filter(function (x) { return x.length; }).length !== countPlus + 1)
                    return 11;
                // Warning: perhaps needs parenthesis
                if (formula.indexOf('(') == -1 && (containsAll(formula, ['*', '/']) || containsAll(formula, ['*', '+']) || containsAll(formula, ['*', '-']) || containsAll(formula, ['-', '/']) || containsAll(formula, ['+', '/']))) {
                    return 6;
                }
                return 0;
            };
            return FormulaBuilder;
        }());
        Components.FormulaBuilder = FormulaBuilder;
    })(Components = WAPF.Components || (WAPF.Components = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Components;
    (function (Components) {
        var MediaSelector = /** @class */ (function () {
            function MediaSelector(initiator, onSelect, onClear, filetypes) {
                if (onSelect === void 0) { onSelect = null; }
                if (onClear === void 0) { onClear = null; }
                if (filetypes === void 0) { filetypes = null; }
                var _this = this;
                this.hasSelected = false;
                this.parent = initiator;
                this.filetypes = filetypes;
                this.preview = initiator.find('.wapf-media-preview');
                this.clearBtn = initiator.find('.wapf-btn-remove-media');
                this.selectBtn = initiator.find('.wapf-btn-add-media');
                this.onSelect = onSelect;
                this.initMediaSelector();
                this.selectBtn.off('click').on('click', function (e) {
                    e.preventDefault();
                    _this.mediaSelector.open();
                });
                this.clearBtn.off('click').on('click', function (e) {
                    e.preventDefault();
                    _this.preview.hide().find('img').attr('src', '');
                    if (typeof onClear == 'function')
                        onClear(_this.parent);
                    _this.clearBtn.hide();
                    _this.selectBtn.show();
                });
            }
            MediaSelector.prototype.initMediaSelector = function () {
                var _this = this;
                var opts = {
                    multiple: false,
                    title: 'Choose or upload an image',
                    button: {
                        text: 'Use this image'
                    }
                };
                if (this.filetypes) {
                    opts.library = { type: this.filetypes };
                }
                this.mediaSelector = wp.media.frames.file_frame = wp.media(opts);
                this.mediaSelector.on('select', function () {
                    _this.hasSelected = true;
                    var attachment = _this.mediaSelector.state().get('selection').first().toJSON();
                    _this.preview.find('img').attr('src', _this.getAttachmentUrlForPreview(attachment));
                    if (typeof _this.onSelect == 'function')
                        _this.onSelect(attachment, _this.parent);
                    jQuery(document).trigger('wapf/media_selected', [attachment, _this.parent]);
                });
            };
            MediaSelector.prototype.getAttachmentUrlForPreview = function (attachment) {
                if (!attachment.sizes)
                    return attachment.url;
                if (attachment.sizes.thumbnail)
                    return attachment.sizes.thumbnail.url;
                if (attachment.sizes.medium)
                    return attachment.sizes.medium.url;
                if (attachment.sizes.full)
                    return attachment.sizes.full.url;
                return attachment.url;
            };
            return MediaSelector;
        }());
        Components.MediaSelector = MediaSelector;
    })(Components = WAPF.Components || (WAPF.Components = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Components;
    (function (Components) {
        var MediaSelector2 = /** @class */ (function () {
            function MediaSelector2(initiator, onSelect, id) {
                if (onSelect === void 0) { onSelect = null; }
                if (id === void 0) { id = 'file_frame'; }
                var _this = this;
                this.id = id;
                this.onSelect = onSelect;
                this.initMediaSelector();
                // Open the media selector dialog
                initiator.on('click', '.wapf-btn-add-media', function (e) {
                    e.preventDefault();
                    _this.active = jQuery(e.currentTarget).closest('[data-index]');
                    _this.mediaSelector.open();
                });
            }
            MediaSelector2.prototype.initMediaSelector = function () {
                var _this = this;
                if (!wp.media.frames[this.id])
                    this.mediaSelector = wp.media.frames[this.id] = wp.media({
                        multiple: false,
                        title: 'Choose or upload an image',
                        button: {
                            text: 'Use this image'
                        }
                    });
                else
                    this.mediaSelector = wp.media.frames[this.id];
                this.mediaSelector.on('select', function () {
                    var attachment = _this.mediaSelector.state().get('selection').first().toJSON();
                    var index = _this.active.data('index');
                    _this.active.find('.wapf-media-preview img').attr('src', _this.getAttachmentUrlForPreview(attachment));
                    if (typeof _this.onSelect == 'function')
                        _this.onSelect(attachment, index);
                });
            };
            MediaSelector2.prototype.getAttachmentUrlForPreview = function (attachment) {
                if (!attachment.sizes)
                    return attachment.url;
                if (attachment.sizes.thumbnail)
                    return attachment.sizes.thumbnail.url;
                if (attachment.sizes.medium)
                    return attachment.sizes.medium.url;
                if (attachment.sizes.full)
                    return attachment.sizes.full.url;
                return attachment.url;
            };
            return MediaSelector2;
        }());
        Components.MediaSelector2 = MediaSelector2;
    })(Components = WAPF.Components || (WAPF.Components = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Api;
    (function (Api) {
        var Collections = /** @class */ (function () {
            function Collections() {
            }
            Collections.findFirst = function (collection, key, value, operator) {
                if (operator === void 0) { operator = '==='; }
                for (var i = 0; i < collection.length; i++) {
                    switch (operator) {
                        case '===':
                            if (collection[i][key] === value)
                                return collection[i];
                            break;
                        case '==':
                            if (collection[i][key] == value)
                                return collection[i];
                            break;
                        case '!=':
                            if (collection[i][key] != value)
                                return collection[i];
                            break;
                    }
                }
                return null;
            };
            Collections.findFirstNot = function (collection, key, value) {
                for (var i = 0; i < collection.length; i++) {
                    if (collection[i][key] !== value)
                        return collection[i];
                }
                return null;
            };
            Collections.findAll = function (collection, key, value, operator) {
                if (operator === void 0) { operator = '==='; }
                var arr = [];
                for (var i = 0; i < collection.length; i++) {
                    switch (operator) {
                        case '===':
                            if (collection[i][key] === value)
                                arr.push(collection[i]);
                            break;
                        case '==':
                            if (collection[i][key] == value)
                                arr.push(collection[i]);
                            break;
                        case '!=':
                            if (collection[i][key] != value)
                                arr.push(collection[i]);
                            break;
                    }
                }
                return arr;
            };
            Collections.findIndex = function (collection, obj) {
                obj = JSON.stringify(obj);
                for (var i = 0; i < collection.length; i++) {
                    if (JSON.stringify(collection[i]) === obj)
                        return i;
                }
                return null;
            };
            Collections.flatten = function (collection, key) {
                var arr = [];
                collection.forEach(function (c) {
                    c[key].forEach(function (cc) {
                        arr.push(cc);
                    });
                });
                return arr;
            };
            return Collections;
        }());
        Api.Collections = Collections;
    })(Api = WAPF.Api || (WAPF.Api = {}));
})(WAPF || (WAPF = {}));

/// <reference path="../models/field.ts" />
/// <reference path="../models/choice.ts" />
var WAPF;
(function (WAPF) {
    var Api;
    (function (Api) {
        var Fields = /** @class */ (function () {
            function Fields() {
            }
            Fields.getChoiceFieldValues = function (field) {
                if (!field)
                    return [];
                if (field.type === 'true-false')
                    return [{ value: 1, label: 'Checked' }, { value: 0, label: 'Unchecked' }];
                var a = [];
                if (field.choices && field.choices.length) {
                    for (var i = 0; i < field.choices.length; i++) {
                        a[i] = { value: field.choices[i].slug, label: field.choices[i].label };
                    }
                }
                return a;
            };
            Fields.canGalleryImageChange = function (field) {
                if (!field)
                    return false;
                return (['true-false', 'checkboxes', 'radio', 'select', 'text-swatch', 'multi-text-swatch', 'image-swatch', 'multi-image-swatch', 'color-swatch', 'multi-color-swatch'].indexOf(field.type) > -1);
            };
            Fields.deleteRulesReferringField = function (fields, referingFieldId) {
                fields.forEach(function (field) {
                    field.conditionals = field.conditionals.filter(function (conditional) {
                        conditional.rules = conditional.rules.filter(function (rule) {
                            return rule.field !== referingFieldId;
                        });
                        return conditional.rules.length;
                    });
                });
            };
            Fields.copy = function (field, keepId, useUniqueLabel) {
                if (keepId === void 0) { keepId = false; }
                if (useUniqueLabel === void 0) { useUniqueLabel = true; }
                field = JSON.parse(JSON.stringify(field));
                var copy = new WAPF.Models.Field();
                if (keepId)
                    copy.id = field.id;
                copy.label = Api.Helpers.unescape(field.label) + (useUniqueLabel ? ' (Copy)' : '');
                // copy.key = field.key + (useUniqueLabel ? '_copy' : '');
                copy.type = field.type;
                copy.required = field.required;
                copy.description = field.description;
                //copy.updatedKey = true;
                copy["class"] = field["class"];
                copy.width = field.width;
                copy.conditionals = field.conditionals;
                copy.group = field.group;
                copy.level = field.level;
                if (field.clone) {
                    if (field.clone.del)
                        copy.clone.del = field.clone.del;
                    if (field.clone.add)
                        copy.clone.add = field.clone.add;
                    if (field.clone.field)
                        copy.clone.field = field.clone.field;
                    if (field.clone.label)
                        copy.clone.label = field.clone.label;
                    if (field.clone.max)
                        copy.clone.max = field.clone.max;
                    if (field.clone.type)
                        copy.clone.type = field.clone.type;
                    else
                        field.clone.type = 'qty';
                }
                if (field.choices) {
                    copy.choices = [];
                    field.choices.forEach(function (c) {
                        var choiceCopy = new WAPF.Models.Choice();
                        if (keepId)
                            choiceCopy.slug = c.slug;
                        choiceCopy.pricing_type = c.pricing_type;
                        choiceCopy.pricing_amount = Api.Helpers.unescape(c.pricing_amount);
                        choiceCopy.selected = c.selected;
                        choiceCopy.label = c.label;
                        if (c.color)
                            choiceCopy.color = c.color;
                        if (c.image)
                            choiceCopy.image = c.image;
                        if (c.attachment)
                            choiceCopy.attachment = c.attachment;
                        //if((c.options && typeof c.options === 'object')|| (c.options && Array.isArray(c.options) && c.options.length))
                        if (c.options && c.options.length || c.options && Object.keys(c.options).length)
                            choiceCopy.options = c.options;
                        copy.choices.push(choiceCopy);
                    });
                }
                // Set other options on the object.
                for (var property in field) {
                    if (field.hasOwnProperty(property) && ['id', 'label', 'key', 'choices', 'options', 'type', 'required', 'description', 'updatedKey', 'conditionals', 'width', 'class'].indexOf(property) === -1) {
                        copy[property] = field[property];
                    }
                }
                // Unescaping for formulas so &lt; or &gt; is not shown instead of < or >.
                if (copy.pricing && copy.pricing.amount)
                    copy.pricing.amount = Api.Helpers.unescape(copy.pricing.amount);
                return copy;
            };
            return Fields;
        }());
        Api.Fields = Fields;
    })(Api = WAPF.Api || (WAPF.Api = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Api;
    (function (Api) {
        var Helpers = /** @class */ (function () {
            function Helpers() {
            }
            Helpers.unescape = function (str) {
                if (!str || typeof str !== 'string')
                    return str;
                return str.replace(/&gt;/g, '>').replace(/&lt;/g, '<').replace(/&amp;/g, '&').replace(/&quot;/g, '"');
            };
            Helpers.slugify = function (str) {
                // Bail early:
                if (!str)
                    return str;
                str = str.replace(/\s/g, '_');
                var map = {
                    "À": "A",
                    "Á": "A",
                    "Â": "A",
                    "Ã": "A",
                    "Ä": "A",
                    "Å": "A",
                    "Æ": "AE",
                    "Ç": "C",
                    "È": "E",
                    "É": "E",
                    "Ê": "E",
                    "Ë": "E",
                    "Ì": "I",
                    "Í": "I",
                    "Î": "I",
                    "Ï": "I",
                    "Ð": "D",
                    "Ñ": "N",
                    "Ò": "O",
                    "Ó": "O",
                    "Ô": "O",
                    "Õ": "O",
                    "Ö": "O",
                    "Ø": "O",
                    "Ù": "U",
                    "Ú": "U",
                    "Û": "U",
                    "Ü": "U",
                    "Ý": "Y",
                    "ß": "s",
                    "à": "a",
                    "á": "a",
                    "â": "a",
                    "ã": "a",
                    "ä": "a",
                    "å": "a",
                    "æ": "ae",
                    "ç": "c",
                    "è": "e",
                    "é": "e",
                    "ê": "e",
                    "ë": "e",
                    "ì": "i",
                    "í": "i",
                    "î": "i",
                    "ï": "i",
                    "ñ": "n",
                    "ò": "o",
                    "ó": "o",
                    "ô": "o",
                    "õ": "o",
                    "ö": "o",
                    "ø": "o",
                    "ù": "u",
                    "ú": "u",
                    "û": "u",
                    "ü": "u",
                    "ý": "y",
                    "ÿ": "y",
                    "Ā": "A",
                    "ā": "a",
                    "Ă": "A",
                    "ă": "a",
                    "Ą": "A",
                    "ą": "a",
                    "Ć": "C",
                    "ć": "c",
                    "Ĉ": "C",
                    "ĉ": "c",
                    "Ċ": "C",
                    "ċ": "c",
                    "Č": "C",
                    "č": "c",
                    "Ď": "D",
                    "ď": "d",
                    "Đ": "D",
                    "đ": "d",
                    "Ē": "E",
                    "ē": "e",
                    "Ĕ": "E",
                    "ĕ": "e",
                    "Ė": "E",
                    "ė": "e",
                    "Ę": "E",
                    "ę": "e",
                    "Ě": "E",
                    "ě": "e",
                    "Ĝ": "G",
                    "ĝ": "g",
                    "Ğ": "G",
                    "ğ": "g",
                    "Ġ": "G",
                    "ġ": "g",
                    "Ģ": "G",
                    "ģ": "g",
                    "Ĥ": "H",
                    "ĥ": "h",
                    "Ħ": "H",
                    "ħ": "h",
                    "Ĩ": "I",
                    "ĩ": "i",
                    "Ī": "I",
                    "ī": "i",
                    "Ĭ": "I",
                    "ĭ": "i",
                    "Į": "I",
                    "į": "i",
                    "İ": "I",
                    "ı": "i",
                    "Ĳ": "IJ",
                    "ĳ": "ij",
                    "Ĵ": "J",
                    "ĵ": "j",
                    "Ķ": "K",
                    "ķ": "k",
                    "Ĺ": "L",
                    "ĺ": "l",
                    "Ļ": "L",
                    "ļ": "l",
                    "Ľ": "L",
                    "ľ": "l",
                    "Ŀ": "L",
                    "ŀ": "l",
                    "Ł": "l",
                    "ł": "l",
                    "Ń": "N",
                    "ń": "n",
                    "Ņ": "N",
                    "ņ": "n",
                    "Ň": "N",
                    "ň": "n",
                    "ŉ": "n",
                    "Ō": "O",
                    "ō": "o",
                    "Ŏ": "O",
                    "ŏ": "o",
                    "Ő": "O",
                    "ő": "o",
                    "Œ": "OE",
                    "œ": "oe",
                    "Ŕ": "R",
                    "ŕ": "r",
                    "Ŗ": "R",
                    "ŗ": "r",
                    "Ř": "R",
                    "ř": "r",
                    "Ś": "S",
                    "ś": "s",
                    "Ŝ": "S",
                    "ŝ": "s",
                    "Ş": "S",
                    "ş": "s",
                    "Š": "S",
                    "š": "s",
                    "Ţ": "T",
                    "ţ": "t",
                    "Ť": "T",
                    "ť": "t",
                    "Ŧ": "T",
                    "ŧ": "t",
                    "Ũ": "U",
                    "ũ": "u",
                    "Ū": "U",
                    "ū": "u",
                    "Ŭ": "U",
                    "ŭ": "u",
                    "Ů": "U",
                    "ů": "u",
                    "Ű": "U",
                    "ű": "u",
                    "Ų": "U",
                    "ų": "u",
                    "Ŵ": "W",
                    "ŵ": "w",
                    "Ŷ": "Y",
                    "ŷ": "y",
                    "Ÿ": "Y",
                    "Ź": "Z",
                    "ź": "z",
                    "Ż": "Z",
                    "ż": "z",
                    "Ž": "Z",
                    "ž": "z",
                    "ſ": "s",
                    "ƒ": "f",
                    "Ơ": "O",
                    "ơ": "o",
                    "Ư": "U",
                    "ư": "u",
                    "Ǎ": "A",
                    "ǎ": "a",
                    "Ǐ": "I",
                    "ǐ": "i",
                    "Ǒ": "O",
                    "ǒ": "o",
                    "Ǔ": "U",
                    "ǔ": "u",
                    "Ǖ": "U",
                    "ǖ": "u",
                    "Ǘ": "U",
                    "ǘ": "u",
                    "Ǚ": "U",
                    "ǚ": "u",
                    "Ǜ": "U",
                    "ǜ": "u",
                    "Ǻ": "A",
                    "ǻ": "a",
                    "Ǽ": "AE",
                    "ǽ": "ae",
                    "Ǿ": "O",
                    "ǿ": "o"
                };
                var nonWord = /\W/g;
                var mapping = function (c) {
                    return (map[c] !== undefined) ? map[c] : c;
                };
                str = str.replace(nonWord, mapping);
                str = str.toLowerCase();
                str = str.replace(/[^a-z0-9_\-]+/g, '');
                return str;
            };
            Helpers.uniqueIdWithLength = function (length) {
                if (length === void 0) { length = 5; }
                return Math.random().toString(36).substr(2, length);
            };
            Helpers.uniqueId = function (prefix, moreEntropy) {
                if (prefix === void 0) { prefix = ''; }
                if (moreEntropy === void 0) { moreEntropy = false; }
                var retId;
                var formatSeed = function (seed, reqWidth) {
                    seed = parseInt(seed, 10).toString(16); // to hex str
                    if (reqWidth < seed.length) { // so long we split
                        return seed.slice(seed.length - reqWidth);
                    }
                    if (reqWidth > seed.length) { // so short we pad
                        return Array(1 + (reqWidth - seed.length)).join('0') + seed;
                    }
                    return seed;
                };
                var uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
                uniqidSeed++;
                retId = prefix; // start with prefix, add current milliseconds hex string
                retId += formatSeed(parseInt((new Date().getTime() / 1000).toString(), 10), 8);
                retId += formatSeed(uniqidSeed, 5); // add seed hex string
                if (moreEntropy) {
                    // for more entropy we add a float lower to 10
                    retId += (Math.random() * 10).toFixed(8).toString();
                }
                return retId;
            };
            Helpers.initializeSelect2 = function ($element) {
                $element.each(function (idx, el) {
                    var $el = jQuery(el);
                    var options = {
                        width: '100%',
                        placeholder: $el.attr('data-select2-placeholder')
                    };
                    if ($el.attr('data-select2-single')) {
                        if ($el.attr('data-select2-single') === 'true')
                            options.maximumSelectionLength = 1;
                        else {
                            options.maximumSelectionLength = 0;
                            options.multiple = true;
                        }
                    }
                    if ($el.attr('data-select2-action')) {
                        options.minimumInputLength = 2;
                        options.ajax = {
                            url: WAPF.Config.getVariable('ajaxUrl'),
                            type: 'POST',
                            dataType: 'json',
                            delay: 350,
                            data: function (params) {
                                return {
                                    q: params.term,
                                    action: $el.attr('data-select2-action')
                                };
                            },
                            processResults: function (data) {
                                var result = [];
                                for (var i = 0; i < data.length; i++) {
                                    result.push({ id: data[i].id, text: data[i].name });
                                }
                                return {
                                    results: result
                                };
                            }
                        };
                    }
                    else {
                        options.minimumInputLength = 0;
                        if ($el.attr('data-select2-prefill')) {
                            options.data = JSON.parse($el.attr('data-select2-prefill'));
                        }
                    }
                    $el.select2(options);
                });
            };
            return Helpers;
        }());
        Api.Helpers = Helpers;
    })(Api = WAPF.Api || (WAPF.Api = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Controllers;
    (function (Controllers) {
        var ConditionsCtrl = /** @class */ (function () {
            function ConditionsCtrl($element) {
                if ($element === void 0) { $element = null; }
                var _this = this;
                // The fields in this field group.
                this.rulegroups = [];
                this.addRuleGroup = function (e, data) {
                    e.preventDefault();
                    // Create a group and add first default rule to it.
                    var group = new WAPF.Models.ConditionRuleGroup();
                    _this.addDefaultRuleToGroup(group);
                    _this.rulegroups.push(group);
                    _this.onChange();
                };
                this.addRule = function (e, data) {
                    e.preventDefault();
                    _this.addDefaultRuleToGroup(_this.rulegroups[data.$parent.$index]);
                    _this.onChange();
                };
                this.deleteRule = function (e, data) {
                    e.preventDefault();
                    var r = _this.rulegroups[data.$parent.$index];
                    r.rules.splice(data.$index, 1);
                    if (r.rules.length === 0)
                        _this.rulegroups.splice(data.$parent.$index, 1);
                    _this.onChange();
                };
                this.onChange = function () {
                    // Create a copy
                    var conditions = JSON.parse(JSON.stringify(_this.rulegroups));
                    // remove the things we don't need in the backend.
                    conditions.forEach(function (condition) {
                        condition.rules.forEach(function (rule) {
                            rule.options = null;
                            delete rule.options;
                            delete rule.selectedCondition;
                        });
                    });
                    // Add on model.
                    _this.conditionsJson = JSON.stringify(conditions);
                };
                this.setSelectedCondition = function (e, data) {
                    var rule = _this.rulegroups[data.$parent.$index].rules[data.$index];
                    var targetClass = '.wapf-rulegroup-' + data.$parent.$index + ' .wapf-rulegroup-rule-' + data.$index;
                    rule.value = null;
                    _this.setSelectedConditionOnRule(rule, targetClass);
                    // Rebind select2
                    _this.onChange();
                };
                this.onChangeRuleSubject = function (e, data) {
                    // preselect 1st condition
                    var rule = _this.rulegroups[data.$parent.$index].rules[data.$index];
                    var selectedOption = WAPF.Api.Collections.findFirst(_this.flattenedConditionOptions, 'id', rule.subject);
                    rule.condition = selectedOption.conditions[0].id;
                    rule.options = selectedOption;
                    _this.setSelectedCondition(e, data);
                };
                this.$element = $element;
                this.rulegroups = [];
                this.fieldgroupType = WAPF.Config.fieldgroupType;
                this.activeConditionOptions = WAPF.Config.getFieldGroupVisibilityConditions()[this.fieldgroupType];
                this.flattenedConditionOptions = WAPF.Api.Collections.flatten(this.activeConditionOptions, 'children');
                // Fill frontend model with backend conditions if editing a post.
                var raw = $element.data('raw-conditions') || [];
                this.rawToConditions(raw);
            }
            ConditionsCtrl.prototype.rawToConditions = function (raw) {
                var _this = this;
                if (raw.length) {
                    this.rulegroups = [];
                    raw.forEach(function (v) {
                        if (v.rules.length) {
                            v.rules.forEach(function (rule) {
                                rule.options = WAPF.Api.Collections.findFirst(_this.flattenedConditionOptions, 'id', rule.subject);
                                rule.selectedCondition = WAPF.Api.Collections.findFirst(rule.options.conditions, 'id', rule.condition);
                            });
                        }
                    });
                    this.rulegroups = raw;
                    this.onChange();
                }
            };
            ConditionsCtrl.prototype.addDefaultRuleToGroup = function (group) {
                var firstGroup = this.flattenedConditionOptions[0];
                var rule = new WAPF.Models.ConditionRule();
                rule.subject = firstGroup.id;
                rule.condition = firstGroup.conditions[0].id;
                rule.options = firstGroup;
                group.rules.push(rule);
            };
            ConditionsCtrl.prototype.setSelectedConditionOnRule = function (rule, ruleRowTargetClass) {
                var selectedCondition = WAPF.Api.Collections.findFirst(rule.options.conditions, 'id', rule.condition);
                // Stringify so we can add to a data attribute in html
                if (selectedCondition.value.type === 'select2' && selectedCondition.value.data)
                    selectedCondition.value.data = JSON.stringify(selectedCondition.value.data);
                rule.selectedCondition = selectedCondition;
                var $select2 = jQuery(ruleRowTargetClass + ' .wapf-select2');
                // Rebind select2
                WAPF.Api.Helpers.initializeSelect2($select2);
                // Set select2 to no values.
                $select2.val(null).trigger('change');
                // Dirty hack to rebind select2 dropdowns.
                /*
                var bindings = WAPF.Main.bindings['ConditionsCtrl'].bindings;
                var theBinding = Api.Collections.findFirst(bindings,'type','each-group');
                theBinding.unbind();
                theBinding.bind();
    */
            };
            return ConditionsCtrl;
        }());
        Controllers.ConditionsCtrl = ConditionsCtrl;
    })(Controllers = WAPF.Controllers || (WAPF.Controllers = {}));
})(WAPF || (WAPF = {}));

/// <reference path="../models/field.ts" />
/// <reference path="../models/conditional.ts" />
var WAPF;
(function (WAPF) {
    var Controllers;
    (function (Controllers) {
        var FieldListCtrl = /** @class */ (function () {
            function FieldListCtrl($element) {
                if ($element === void 0) { $element = null; }
                var _this = this;
                // The fields in this field group.
                this.fields = [];
                // The fields displayed on the frontend
                this.renderedFields = [];
                this.fieldDefinitions = [];
                this.hiddenForPerformance = true;
                // The field currently active (expanded on the frontend).
                this.activeField = null;
                this.onChangeTimeout = null;
                this.oldTypes = {};
                this.fieldsForConditionals = {};
                this.renderFields = function (e, data) {
                    e.preventDefault();
                    _this.setRenderFields(_this.$element);
                };
                this.setActiveField = function (e, data) {
                    e.preventDefault();
                    // Slide animations.
                    _this.$element.find('.wapf-field-body').slideUp(200);
                    var clickedField = _this.fields[data.$index];
                    if (_this.activeField && clickedField.id === _this.activeField.id) {
                        _this.activeField = null;
                        return;
                    }
                    _this.activeField = clickedField;
                    jQuery(document).trigger('wapf/field/activated', [_this.activeField]);
                    _this.setFieldsForConditionals();
                    var $parent = jQuery('[data-field-id=' + _this.activeField.id + ']').closest('.wapf-field');
                    $parent.find('.wapf-field-body').slideToggle(200);
                };
                this.copyFieldId = function (e, data) {
                    e.preventDefault();
                    var id = _this.fields[data.$index].id;
                    var $a = jQuery(e.currentTarget).find('a');
                    if (!navigator.clipboard || !navigator.clipboard.writeText) {
                        var textArea = document.createElement("textarea");
                        textArea.value = id;
                        textArea.style.top = "0";
                        textArea.style.left = "0";
                        textArea.style.position = "fixed";
                        document.body.appendChild(textArea);
                        textArea.focus();
                        textArea.select();
                        document.execCommand('copy');
                        document.body.removeChild(textArea);
                    }
                    else {
                        navigator.clipboard.writeText(id);
                    }
                    $a.text($a.data('copied'));
                    setTimeout(function () { $a.text($a.data('copy')); }, 3000);
                    e.stopPropagation();
                };
                this.addField = function (e) {
                    e.preventDefault();
                    // Create and add a new field.
                    var field = new WAPF.Models.Field();
                    _this.fields.push(field);
                    _this.oldTypes[field.id] = field.type;
                    // Quick fix to just fire this.
                    _this.setActiveField(new Event('click'), { $index: _this.fields.length - 1 });
                    _this.updateFieldLevels();
                    _this.updateFieldGroup();
                    // Trigger update.
                    _this.onChange(e);
                    jQuery(document).trigger('wapf/field/added', [[field], _this.fields]); // an array of [field] because we could have added more fields (duplicating a section for example)
                };
                this.deleteField = function (e, data) {
                    e.preventDefault();
                    var sections = 0;
                    var reIdx = 0;
                    for (var i = data.$index; i - reIdx < _this.fields.length; i++) {
                        var realIndex = i - reIdx; // Because we do "splice" in a loop, this reindexes the array so we adjust for it.
                        var f = _this.fields[realIndex];
                        if (f.type === 'section')
                            sections++;
                        if (f.type === 'sectionend')
                            sections--;
                        // Check other fields conditional rules. Remove the rules pertaining to the deleted field.
                        WAPF.Api.Fields.deleteRulesReferringField(_this.fields, f.id);
                        // Delete old type entry
                        delete _this.oldTypes[f.id];
                        // Delete the field.
                        _this.fields.splice(realIndex, 1);
                        reIdx++;
                        _this.updateFieldLevels();
                        if (sections < 1)
                            break;
                    }
                    // Trigger update.
                    _this.onChange(e);
                    jQuery(document).trigger('wapf/field/removed', [_this.fields]);
                };
                this.duplicateField = function (e, data) {
                    e.preventDefault();
                    // Create duplicate.
                    var f = _this.fields[data.$index];
                    var fieldsToDuplicate = [f];
                    var level = 0;
                    if (f.type === 'section') {
                        level++;
                        for (var i = data.$index + 1; i < _this.fields.length; i++) {
                            var f = _this.fields[i];
                            fieldsToDuplicate.push(f);
                            if (f.type == 'sectionend')
                                level--;
                            if (f.type == 'section')
                                level++;
                            if (level == 0)
                                break;
                        }
                    }
                    var ctr = 0;
                    var dupes = [];
                    fieldsToDuplicate.forEach(function (ftd) {
                        ctr++;
                        var dupe = WAPF.Api.Fields.copy(ftd, false, true);
                        dupes.push(dupe);
                        _this.oldTypes[dupe.id] = dupe.type;
                        _this.fields.splice(data.$index + (fieldsToDuplicate.length - 1) + ctr, 0, dupe);
                    });
                    _this.setFieldsForConditionals();
                    // Trigger update.
                    _this.onChange(e);
                    jQuery(document).trigger('wapf/field/added', [dupes, _this.fields]);
                };
                this.addConditional = function (e, data) {
                    e.preventDefault();
                    // Add a new conditional with a default rule.
                    var conditional = new WAPF.Models.Conditional();
                    var rule = _this.createRule();
                    conditional.rules.push(rule);
                    _this.activeField.conditionals.push(conditional);
                    // Trigger update.
                    _this.onChange(e);
                };
                this.deleteRule = function (e, data) {
                    e.preventDefault();
                    var c = _this.activeField.conditionals[data.$parent.$index];
                    c.rules.splice(data.$index, 1);
                    if (c.rules.length === 0)
                        _this.activeField.conditionals.splice(data.$parent.$index, 1);
                    _this.onChange(e);
                };
                this.addRule = function (e, data) {
                    e.preventDefault();
                    var rule = _this.createRule();
                    _this.activeField.conditionals[data.$parent.$index].rules.push(rule);
                    _this.onChange(e);
                };
                this.openFormulaBuilder = function (e, data) {
                    e.preventDefault();
                    var change = function (formula) {
                        if (data.choice)
                            this.fields[data.$parent.$index].choices[data.$index].pricing_amount = formula;
                        else
                            this.fields[data.$index].pricing.amount = formula;
                    };
                    if (!_this.formulaBuilder) {
                        var initiator = jQuery('#wapf-fb-wrapper')[0];
                        _this.formulaBuilder = new WAPF.Components.FormulaBuilder(initiator, 'popup', change.bind(_this));
                    }
                    else {
                        _this.formulaBuilder.onChange = change.bind(_this);
                    }
                    _this.formulaBuilder.addFields();
                    _this.formulaBuilder.addVars();
                    var currentFormula = data.choice ? data.choice.pricing_amount : data.field.pricing.amount;
                    _this.formulaBuilder.setFormula(currentFormula == 0 ? '' : currentFormula);
                    jQuery('#wapf-fb').show();
                };
                this.openOptionsImport = function (e, data) {
                    e.preventDefault();
                    jQuery('#wapf-bulkopts').val('').attr('placeholder', data.field.type.indexOf('color-swatch') > -1 ? 'White, #ffffff\nRed, #ff0000\nBlue, #0000ff\n...' : 'Option A\nOption B\nOption C\n...');
                    jQuery('#bulkopts-msg').hide();
                    jQuery('#btn-bulkopts').show().data('field', data.field);
                    jQuery('#btn-bulkopts-done').hide();
                    jQuery('.wapf-bulk-options').show();
                };
                // Conditional rule "field" dropdown changed
                this.onConditionalFieldChange = function (e, data) {
                    var rule = _this.activeField.conditionals[data.$parent.$index].rules[data.$index];
                    rule.value = '';
                    rule.condition = '';
                    _this.enrichRule(rule);
                    _this.onChange(e);
                };
                this.onConditionalConditionChange = function (e, data) {
                    var rule = _this.activeField.conditionals[data.$parent.$index].rules[data.$index];
                    _this.enrichRule(rule);
                    if (rule.selectedCondition.type === false)
                        rule.value = '';
                    _this.onChange(e);
                };
                // Name of label changed
                this.labelChangeTimer = null;
                this.onLabelChange = function (e, data) {
                    clearTimeout(_this.labelChangeTimer);
                    clearTimeout(_this.onChangeTimeout);
                    _this.labelChangeTimer = setTimeout(function () {
                        _this.onChange(e);
                    }, 350);
                };
                this.onChangeType = function (e, data) {
                    var field = _this.fields[data.$index];
                    field.required = false;
                    var oldType = _this.oldTypes[field.id];
                    var removeChoices = true;
                    var map = {
                        'image-swatch': 'multi-image-swatch',
                        'color-swatch': 'multi-color-swatch',
                        'text-swatch': 'multi-text-swatch'
                    };
                    // Don't remove field choices if it makes sense to keep them.
                    if (oldType) {
                        if ((map[oldType] && map[oldType] === field.type) || (map[field.type] && map[field.type] === oldType)) {
                            removeChoices = false;
                        }
                        if (['radio', 'select', 'checkboxes'].indexOf(oldType) > -1 && ['radio', 'select', 'checkboxes'].indexOf(field.type) > -1) {
                            removeChoices = false;
                        }
                        if (oldType === 'select' && field.type.indexOf('swatch') > -1)
                            removeChoices = false;
                    }
                    if (removeChoices) {
                        field.choices = [];
                    }
                    else {
                        field.choices.forEach(function (s) {
                            s.selected = false;
                        });
                    }
                    _this.oldTypes[field.id] = field.type;
                    _this.updateFieldLevels();
                    _this.updateFieldGroup();
                    _this.onChange(null, true, 'change', 'type');
                    jQuery(document).trigger('wapf/field/type_change', [field]);
                };
                this.repeaterChanged = function (e, data) {
                    var field = _this.fields[data.$index];
                    if (!field.clone.enabled) {
                        delete field.clone.label;
                        delete field.clone.field;
                        delete field.clone.add;
                        delete field.clone.del;
                        delete field.clone.max;
                    }
                    _this.onChange(e);
                };
                this.onChange = function (e, withTimeout, type, from) {
                    if (e === void 0) { e = null; }
                    if (withTimeout === void 0) { withTimeout = true; }
                    if (type === void 0) { type = null; }
                    if (from === void 0) { from = null; }
                    var f = function () {
                        // Create a copyonqty
                        var fields = JSON.parse(JSON.stringify(_this.fields));
                        // Do some post processing
                        fields.forEach(function (field) {
                            // Delete stuff we don't need in the backend.
                            delete field.updatedKey;
                            delete field.level;
                            // Make sure these fields are a string as they may contains "true" or "false" as text
                            if (field.type === 'true-false') {
                                if (field.label_true != undefined)
                                    field.label_true = field.label_true.toString();
                                if (field.label_false != undefined)
                                    field.label_false = field.label_false.toString();
                            }
                            if (field.conditionals && field.conditionals.length) {
                                field.conditionals.forEach(function (c) {
                                    c.rules.forEach(function (r) {
                                        delete r.selectedCondition;
                                        delete r.possibleConditions;
                                    });
                                });
                            }
                        });
                        _this.fieldsJson = JSON.stringify(fields);
                        if (e && !from && !type) {
                            type = e.type;
                            from = jQuery(e.currentTarget || e.target).closest('.wapf-field__setting').data('setting');
                        }
                        jQuery(document).trigger('wapf/fields/change', [_this.fields, type, from]);
                    };
                    clearTimeout(_this.onChangeTimeout);
                    if (withTimeout)
                        _this.onChangeTimeout = setTimeout(f, 350);
                    else
                        f();
                };
                this.$element = $element;
                this.fields = [];
                this.fieldDefinitions = jQuery('[data-field-conditions]').data('field-definitions');
                this.availableConditions = WAPF.Config.getFieldVisibilityConditions();
                var rawFields = $element.data('raw-fields') || [];
                this.rawToFields(rawFields);
                if (rawFields.length < 50) {
                    this.hiddenForPerformance = false;
                    this.setRenderFields($element);
                }
                jQuery(document).on('wapf/admin/before_submit', function () {
                    _this.onChange(null, false);
                });
            }
            FieldListCtrl.prototype.rawToFields = function (raw) {
                var _this = this;
                if (raw.length) {
                    this.fields = [];
                    jQuery.each(raw, function (idx, field) {
                        var f = WAPF.Api.Fields.copy(field, true, false);
                        _this.fields.push(f);
                        _this.oldTypes[f.id] = f.type;
                    });
                    this.updateFieldLevels();
                    this.updateFieldGroup();
                    jQuery(document).trigger('wapf/fields/init', [this.fields]);
                    this.onChange();
                }
            };
            FieldListCtrl.prototype.setRenderFields = function ($element) {
                var _this = this;
                this.renderedFields = this.fields;
                this.hiddenForPerformance = false;
                // Initialize sorting
                $element.find('.wapf-field-list__body').sortable({
                    handle: '.wapf-field-sort',
                    axis: 'y',
                    opacity: .75,
                    tolerance: 'pointer',
                    update: function () {
                        // When drag complete, re-sort the fields.
                        var ids = [];
                        _this.$element.find('.wapf-field').each(function (i, e) {
                            ids.push('' + jQuery(e).data('field-id')); // We do ''+ to make sure we get strings if the field ID is all numbers
                        });
                        _this.fields.sort(function (a, b) {
                            var indexA = ids.indexOf(a.id);
                            var indexB = ids.indexOf(b.id);
                            if (indexA < indexB)
                                return -1;
                            if (indexA > indexB)
                                return 1;
                            return 0;
                        });
                        // Trigger to calculate field levels.
                        _this.updateFieldLevels();
                        // Trigger change to update hidden input.
                        _this.onChange();
                    }
                });
            };
            FieldListCtrl.prototype.updateFieldGroup = function () {
                var _this = this;
                this.fields.forEach(function (field) {
                    var def = WAPF.Api.Collections.findFirst(_this.fieldDefinitions, 'id', field.type);
                    field.group = def.type;
                });
            };
            FieldListCtrl.prototype.updateFieldLevels = function () {
                // Each field has a "level" which is used to display fields that are within a section with a different left margin.
                var levelId = 0;
                this.fields.forEach(function (field) {
                    field.level = levelId;
                    if (field.type == 'section')
                        levelId++;
                    if (field.type === 'sectionend') {
                        levelId--;
                        field.level = levelId;
                    }
                });
            };
            FieldListCtrl.prototype.createRule = function () {
                var rule = new WAPF.Models.ConditionalRule();
                rule.field = this.fieldsForConditionals.fields[0].id;
                this.enrichRule(rule);
                return rule;
            };
            FieldListCtrl.prototype.setFieldsForConditionals = function () {
                var _this = this;
                this.fieldsForConditionals = { fields: [], conditions: [] };
                this.fields.forEach(function (field) {
                    if (_this.activeField && _this.activeField.id == field.id || field.group != 'field') {
                        return;
                    }
                    _this.fieldsForConditionals.fields.push({ id: field.id, label: field.label });
                });
                // Enrich current rules
                if (this.activeField) {
                    this.activeField.conditionals.forEach(function (c) {
                        c.rules.forEach(function (r) {
                            _this.enrichRule(r);
                        });
                    });
                }
            };
            FieldListCtrl.prototype.enrichRule = function (rule) {
                var field = WAPF.Api.Collections.findFirst(this.fields, 'id', rule.field);
                rule.possibleConditions = WAPF.Api.Collections.findFirst(this.availableConditions, 'type', field.type).conditions;
                if (!rule.condition) {
                    rule.selectedCondition = rule.possibleConditions[0];
                    rule.condition = rule.selectedCondition.value;
                }
                else {
                    rule.selectedCondition = WAPF.Api.Collections.findFirst(rule.possibleConditions, 'value', rule.condition);
                }
                if (rule.selectedCondition.type == 'options' && !rule.value && field.choices.length) {
                    rule.value = field.choices[0].slug;
                }
            };
            return FieldListCtrl;
        }());
        Controllers.FieldListCtrl = FieldListCtrl;
    })(Controllers = WAPF.Controllers || (WAPF.Controllers = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Controllers;
    (function (Controllers) {
        var LayoutCtrl = /** @class */ (function () {
            function LayoutCtrl($element) {
                if ($element === void 0) { $element = null; }
                var _this = this;
                this.galleryImages = [];
                this.showAddNewRule = false;
                this.fieldCache = [];
                this.fieldLabels = [];
                // pagination
                this.treshold = 10;
                this.needsMoreLess = false;
                this.showAll = false;
                this.hidden = 0;
                this.toggleGalleryImages = function () {
                    _this.settings.gallery_images = [];
                    _this.pagination();
                    _this.onChange();
                };
                this.addGalleryImage = function (e) {
                    e.preventDefault();
                    var fieldCacheKeys = Object.keys(_this.fieldCache);
                    if (!fieldCacheKeys.length)
                        return;
                    var gi = new WAPF.Models.GalleryImage();
                    if (_this.settings.swap_type === 'rules') {
                        fieldCacheKeys.forEach(function (fieldId) {
                            gi.values.push(new WAPF.Models.GalleryImageValue(fieldId, '*', _this.fieldCache[fieldId]));
                        });
                    }
                    else {
                        var field = _this.fieldCache[fieldCacheKeys[0]];
                        gi.values = [new WAPF.Models.GalleryImageValue(field.id, field.choices[0].value, field)];
                    }
                    _this.settings.gallery_images.push(gi);
                    _this.pagination();
                    _this.onChange();
                };
                this.deleteGalleryImage = function (e, data) {
                    e.preventDefault();
                    _this.settings.gallery_images.splice(data.$index, 1);
                    _this.pagination();
                    _this.onChange();
                };
                this.setProductImage = function (e, data) {
                    var index = data.$parent.$index;
                    _this.settings.gallery_images[index].source = 'gallery';
                    _this.settings.gallery_images[index].id = data.image.id;
                    _this.settings.gallery_images[index].url = data.image.url;
                    _this.onChange();
                };
                this.onChange = function () {
                    _this.layoutJson = JSON.stringify(_this.settings);
                };
                // When type is "last" and another field is selected.
                this.onChangeField = function (e, data) {
                    var giv = _this.settings.gallery_images[data.$parent.$index].values[data.$index];
                    var field = _this.fieldCache[giv.field];
                    giv.fieldCache = field;
                    giv.value = field.choices[0].value;
                    _this.onChange();
                };
                this.changeSwapType = function () {
                    _this.settings.gallery_images = [];
                    _this.viewableGalleryImages = [];
                    _this.onChange();
                };
                this.showAllRules = function (e) {
                    e.preventDefault();
                    _this.showAll = true;
                    _this.pagination();
                };
                this.hideRules = function (e) {
                    e.preventDefault();
                    _this.showAll = false;
                    _this.pagination();
                };
                this.$element = $element;
                // Quick & dirty jquery val() overwrite so that we can work with #product_image_gallery on change
                var originalVal = jQuery.fn.val;
                jQuery.fn.val = function (value) {
                    if (arguments.length >= 1) {
                        if (jQuery(this).attr('id') === 'product_image_gallery') {
                            originalVal.call(this, value);
                            jQuery(this).trigger('change');
                            return this;
                        }
                        return originalVal.call(this, value);
                    }
                    return originalVal.call(this);
                };
                // Fetch from frontend
                this.rawToSettings($element.data('layout-options') || new WAPF.Models.LayoutSettings());
                // Logic for when the woocommerce product gallery changes.
                jQuery('#product_image_gallery').on('change', function () {
                    _this.galleryImages = [];
                    jQuery('ul.product_images > li').each(function (i, el) {
                        var image = jQuery(el).find('img');
                        if (image) {
                            _this.galleryImages.push({
                                url: image.attr('src'),
                                id: jQuery(el).data('attachment_id')
                            });
                        }
                    });
                    // Delete gallery images that no longer have a gallery image set in woo
                    var i = _this.settings.gallery_images.length;
                    while (i--) {
                        var gimage = _this.settings.gallery_images[i];
                        var galleryImage = WAPF.Api.Collections.findAll(WAPF.Api.Collections.findAll(_this.galleryImages, 'source', 'gallery'), 'id', parseInt(gimage.id));
                        if (!galleryImage)
                            _this.settings.gallery_images.splice(i, 1);
                    }
                    _this.pagination();
                    _this.onChange();
                }).trigger('change'); // Already run once on page load.
                jQuery(document).on('wapf/field/option_removed', function (e, deletedId, field) {
                    if (_this.settings.swap_type !== 'last')
                        return;
                    if (_this.settings.gallery_images.length) {
                        var j = _this.settings.gallery_images.length;
                        while (j--) {
                            var gimage = _this.settings.gallery_images[j];
                            if (gimage.values[0].field === field.id && gimage.values[0].value === deletedId)
                                _this.settings.gallery_images.splice(j, 1);
                        }
                    }
                });
                jQuery(document).on('wapf/fields/change', function (e, fields, type, from) {
                    // Only update if something interesting happened or when we have no data of what is happening.
                    if ((!from && !type) || type === 'click' || (from === 'label' && type === 'change') || (from === 'type' && type === 'change') || from === 'options' && type === 'change') {
                        // Redo field cache
                        _this.fieldCache = [];
                        _this.fieldLabels = [];
                        for (var i = 0; i < fields.length; i++) {
                            _this.addToFieldCache(fields[i]);
                        }
                        var fieldCacheKeys = Object.keys(_this.fieldCache);
                        // When there are no fields that can change the product image
                        if (!fieldCacheKeys.length) {
                            _this.settings.gallery_images = [];
                            _this.settings.enable_gallery_images = false;
                        }
                        // Update gallery images by deleting them (or their values) when they're not applicable anymore.
                        if (_this.settings.gallery_images.length) {
                            var j = _this.settings.gallery_images.length;
                            while (j--) {
                                var gimage = _this.settings.gallery_images[j];
                                var i = gimage.values.length;
                                while (i--) { // iterate backward so we dont break loop when we delete element
                                    var v = gimage.values[i];
                                    var f = _this.fieldCache[v.field];
                                    if (!f) {
                                        gimage.values.splice(i, 1); // field doesn't exist anymore or has wrong type, remove it.
                                        continue;
                                    }
                                    if (v.value == '*')
                                        continue;
                                    var c = WAPF.Api.Collections.findFirst(f.choices, 'value', v.value, '==');
                                    if (!c)
                                        gimage.values[i].value = '*'; // Choice doesn't exist anymore - reset it.
                                }
                                if (!gimage.values.length)
                                    _this.settings.gallery_images.splice(j, 1);
                            }
                        }
                        _this.showAddNewRule = fieldCacheKeys.length > 0;
                        if (_this.settings.swap_type === 'rules') {
                            // Add new fields from fieldCache
                            _this.settings.gallery_images.forEach(function (gi) {
                                if (gi.values.length < fieldCacheKeys.length) {
                                    for (var i = 0; i < fieldCacheKeys.length; i++) {
                                        var any = WAPF.Api.Collections.findFirst(gi.values, 'field', fieldCacheKeys[i]);
                                        if (!any)
                                            gi.values.push(new WAPF.Models.GalleryImageValue(fieldCacheKeys[i], '*', _this.fieldCache[fieldCacheKeys[i]]));
                                    }
                                }
                            });
                        }
                        // Set labels & choices on our frontend objects
                        for (var i = 0; i < _this.settings.gallery_images.length; i++) {
                            for (var j = 0; j < _this.settings.gallery_images[i].values.length; j++) {
                                _this.settings.gallery_images[i].values[j].fieldCache = _this.fieldCache[_this.settings.gallery_images[i].values[j].field];
                            }
                        }
                        _this.pagination();
                        _this.onChange();
                    }
                });
                jQuery($element.find('.gallery-sort-wrapper')[0]).sortable({
                    handle: '.wapf-gallery_image_drag',
                    axis: 'y',
                    opacity: .75,
                    tolerance: 'pointer',
                    update: function () {
                        // When drag complete, re-sort the fields.
                        var indexes = [];
                        _this.$element.find('.wapf-gallery_image').each(function (i, e) {
                            indexes.push(jQuery(e).data('index'));
                        });
                        _this.settings.gallery_images.sort(function (a, b) {
                            var indexA = indexes.indexOf(WAPF.Api.Collections.findIndex(_this.settings.gallery_images, a));
                            var indexB = indexes.indexOf(WAPF.Api.Collections.findIndex(_this.settings.gallery_images, b));
                            if (indexA < indexB)
                                return -1;
                            if (indexA > indexB)
                                return 1;
                            return 0;
                        });
                        // Reindex the UI
                        _this.$element.find('.wapf-gallery_image').each(function (i, e) {
                            jQuery(e).data('index', i).attr('data-index', i);
                        });
                        // Trigger change to update hidden input.
                        _this.onChange();
                    }
                });
            }
            LayoutCtrl.prototype.rawToSettings = function (raw) {
                this.settings = new WAPF.Models.LayoutSettings();
                if (raw) {
                    for (var prop in raw) {
                        if (Object.prototype.hasOwnProperty.call(raw, prop)) {
                            this.settings[prop] = raw[prop];
                        }
                    }
                    // Versions prior to 1.6.1 had strings "true" or "false" as values for checkbox field. It was then changed to 0 or 1 so we fix this here.
                    if (this.settings.gallery_images) {
                        this.settings.gallery_images.forEach(function (gi) {
                            gi.values.forEach(function (giv) {
                                if (giv.value === 'true')
                                    giv.value = 1;
                                if (giv.value === 'false')
                                    giv.value = 0;
                            });
                        });
                    }
                    this.onChange();
                }
            };
            LayoutCtrl.prototype.addToFieldCache = function (field) {
                if (!WAPF.Api.Fields.canGalleryImageChange(field))
                    return;
                var choices = WAPF.Api.Fields.getChoiceFieldValues(field);
                if (choices.length) {
                    var f = { label: field.label, choices: choices, id: field.id };
                    this.fieldCache[field.id] = f;
                    this.fieldLabels.push({ id: field.id, label: field.label });
                    return f;
                }
                return false;
            };
            LayoutCtrl.prototype.pagination = function () {
                if (this.settings.gallery_images.length <= this.treshold) {
                    this.needsMoreLess = false;
                    this.viewableGalleryImages = this.settings.gallery_images;
                }
                else {
                    this.needsMoreLess = true;
                    this.viewableGalleryImages = this.showAll ? this.settings.gallery_images : this.settings.gallery_images.slice(0, this.treshold);
                }
                this.hidden = this.settings.gallery_images.length - this.treshold;
            };
            return LayoutCtrl;
        }());
        Controllers.LayoutCtrl = LayoutCtrl;
    })(Controllers = WAPF.Controllers || (WAPF.Controllers = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Controllers;
    (function (Controllers) {
        var ToolsCtrl = /** @class */ (function () {
            function ToolsCtrl() {
                jQuery('.btn-wapf-import').on('click', function (e) {
                    e.preventDefault();
                    try {
                        var json = JSON.parse(jQuery('.wapf-import-ta').val());
                        json.fields.forEach(function (f) {
                            var oldId = f.id;
                            f.id = WAPF.Api.Helpers.uniqueId();
                            var replaceAll = function (str) {
                                return ('' + str).replace(new RegExp(oldId, 'g'), f.id);
                            };
                            json.fields.forEach(function (of) {
                                of.conditionals.forEach(function (c) {
                                    c.rules.forEach(function (r) {
                                        if (r.field == oldId)
                                            r.field = f.id;
                                    });
                                });
                                if (of.pricing.enabled && of.pricing.type == 'fx') {
                                    of.pricing.amount = replaceAll(of.pricing.amount);
                                }
                                if (of.choices) {
                                    of.choices.forEach(function (c) {
                                        if (c.pricing_type == 'fx')
                                            c.pricing_amount = replaceAll(c.pricing_amount);
                                    });
                                }
                            });
                            if (json.variables) {
                                json.variables.forEach(function (v) {
                                    if (v["default"])
                                        v["default"] = replaceAll(v["default"]);
                                    if (v.rules && v.rules.length) {
                                        v.rules.forEach(function (r) {
                                            if (r.variable)
                                                r.variable = replaceAll(r.variable);
                                            if (r.type == 'field' && r.field == oldId)
                                                r.field = f.id;
                                        });
                                    }
                                });
                            }
                            if (json.layout.gallery_images && json.layout.gallery_images.length) {
                                json.layout.gallery_images.forEach(function (gi) {
                                    gi.values.forEach(function (v) {
                                        if (v.field == oldId)
                                            v.field = f.id;
                                    });
                                });
                            }
                        });
                        if (WAPF.Config.getVariable('isWooProductScreen') != 1) {
                            WAPF.Main.bindings['ConditionsCtrl'].models.rawToConditions(json.conditions || {});
                        }
                        var fieldListCtrl = WAPF.Main.bindings['FieldListCtrl'].models;
                        fieldListCtrl.rawToFields(json.fields);
                        var layoutCtrl = WAPF.Main.bindings['LayoutCtrl'].models;
                        layoutCtrl.rawToSettings(json.layout);
                        var variableCtrl = WAPF.Main.bindings['VariablesCtrl'].models;
                        variableCtrl.variables = json.variables || [];
                        jQuery('.wapf-import-success').show();
                        jQuery('.wapf-import-error').hide();
                    }
                    catch (e) {
                        jQuery('.wapf-import-success').hide();
                        jQuery('.wapf-import-error').show();
                    }
                });
                jQuery('.wapf-import').on('click', function (e) {
                    e.preventDefault();
                    var $e = jQuery(e.currentTarget);
                    jQuery('.' + $e.data('modal-class')).show();
                });
                jQuery('.wapf-export').on('click', function (e) {
                    e.preventDefault();
                    var $e = jQuery(e.currentTarget);
                    var rawFields = jQuery('[name=wapf-fields]').val();
                    var rawConditions = jQuery('[name=wapf-conditions]').val();
                    var rawLayout = jQuery('[name=wapf-layout]').val();
                    var rawVariables = jQuery('[name=wapf-variables]').val();
                    var json = {
                        fields: rawFields ? JSON.parse(rawFields) : [],
                        conditions: rawConditions ? JSON.parse(rawConditions) : [],
                        layout: rawLayout ? JSON.parse(rawLayout) : {},
                        variables: rawVariables ? JSON.parse(rawVariables) : []
                    };
                    jQuery('.wapf-export-ta').val(JSON.stringify(json));
                    jQuery('.' + $e.data('modal-class')).show();
                });
                jQuery('#btn-bulkopts').on('click', function (e) {
                    e.preventDefault();
                    jQuery(this).hide();
                    var field = jQuery(this).data('field');
                    if (!field)
                        return;
                    var lines = ('' + jQuery('#wapf-bulkopts').val()).split(/\n/);
                    var imported = 0;
                    lines.forEach(function (l) {
                        l = l.trim();
                        if (!l.length)
                            return;
                        var second = null;
                        if (['color-swatch', 'multi-color-swatch'].indexOf(field.type) > -1) {
                            var split = l.split(',');
                            l = split[0];
                            second = split.length == 2 ? split[1] : null;
                        }
                        field.addChoice(l, second);
                        imported++;
                    });
                    jQuery('#btn-bulkopts-done').show();
                    var $msg = jQuery('#bulkopts-msg');
                    $msg.text($msg.data('msg').replace('{x}', imported).replace('{y}', lines.length)).show();
                });
            }
            return ToolsCtrl;
        }());
        Controllers.ToolsCtrl = ToolsCtrl;
    })(Controllers = WAPF.Controllers || (WAPF.Controllers = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Controllers;
    (function (Controllers) {
        var VariablesCtrl = /** @class */ (function () {
            function VariablesCtrl($element) {
                if ($element === void 0) { $element = null; }
                var _this = this;
                this.canAddFieldToVariableRule = false;
                this.variables = [];
                this.fields = [];
                this.addEmptyVariable = function (e) {
                    e.preventDefault();
                    var v = new WAPF.Models.Variable();
                    v.name = 'unnamed_' + (_this.variables.length + 1);
                    _this.activateVariable(_this.variables.push(v) - 1);
                    jQuery(document).trigger('wapf/variable/added', [v, _this.variables]);
                    _this.onChange();
                };
                this.addVariableRule = function (e, data) {
                    e.preventDefault();
                    var field = WAPF.Api.Collections.findFirst(_this.fields, 'group', 'field');
                    var rule = new WAPF.Models.VairableRule();
                    if (field) {
                        rule.field = field.id;
                        rule.value = '';
                        rule.type = 'field';
                        rule.condition = WAPF.Api.Collections.findFirst(_this.availableConditions, 'type', field.type).conditions[0].value;
                    }
                    else {
                        rule.type = 'qty';
                        rule.field = 'qty';
                        rule.value = '1';
                        rule.condition = 'eq';
                    }
                    _this.variables[data.$index].rules.push(rule);
                    _this.onChange();
                };
                this.onChangeVariableName = function (e, data) {
                    _this.variables[data.$index].name = WAPF.Api.Helpers.slugify(_this.variables[data.$index].name).replace(/-/g, '_');
                    jQuery(document).trigger('wapf/variable/changed', [_this.variables[data.$index], _this.variables]);
                    _this.onChange();
                };
                this.onVariableRuleTypeChange = function (e, data) {
                    var r = _this.variables[data.$parent.$index].rules[data.$index];
                    if (r.type == 'qty') {
                        r.field = 'qty';
                        r.value = '1';
                        r.condition = 'eq';
                    }
                    else {
                        r.value = null;
                        var field = WAPF.Api.Collections.findFirst(_this.fields, 'group', 'field');
                        r.field = field.id;
                        r.condition = WAPF.Api.Collections.findFirst(_this.availableConditions, 'type', field.type).conditions[0].value;
                    }
                    _this.onChange();
                };
                this.onChange = function () {
                    _this.json = JSON.stringify(_this.variables);
                };
                this.deleteVariableRule = function (e, data) {
                    e.preventDefault();
                    var v = _this.variables[data.$parent.$index];
                    v.rules.splice(data.$index, 1);
                    _this.onChange();
                };
                this.deleteVariable = function (e, data) {
                    e.preventDefault();
                    _this.variables.splice(data.$index, 1);
                    jQuery(document).trigger('wapf/variable/removed', [_this.variables]);
                    // Trigger update.
                    _this.onChange();
                };
                this.$element = $element;
                this.availableConditions = WAPF.Config.getFieldVisibilityConditions();
                this.variables = $element.data('variables');
                // Some preprocessing
                this.variables.forEach(function (v) {
                    v.rules.forEach(function (r) {
                        if (!r.type)
                            r.type = 'field';
                    });
                });
                // Initialize sorting
                $element.find('.wapf-collapsible__holder').sortable({
                    handle: '.wapf-collapsible__sort',
                    axis: 'y',
                    opacity: .7,
                    tolerance: 'pointer',
                    update: function () {
                        // When drag complete, re-sort the fields.
                        var ids = [];
                        _this.$element.find('.wapf-collapsible__wrapper').each(function (i, e) {
                            ids.push('' + jQuery(e).data('variable-id')); // We do ''+ to make sure we get strings if the field ID is all numbers
                        });
                        _this.variables.sort(function (a, b) {
                            var indexA = ids.indexOf(a.name);
                            var indexB = ids.indexOf(b.name);
                            if (indexA < indexB)
                                return -1;
                            if (indexA > indexB)
                                return 1;
                            return 0;
                        });
                        // Trigger change to update hidden input.
                        _this.onChange();
                    }
                });
                jQuery(document).on('wapf/fields/change', function (e, fields) {
                    _this.fields = [];
                    fields.forEach(function (f) {
                        if (f.group === 'field')
                            _this.fields.push(f);
                    });
                    var field = WAPF.Api.Collections.findFirst(_this.fields, 'group', 'field');
                    _this.canAddFieldToVariableRule = field != null;
                    _this.variables.forEach(function (v) {
                        if (!v.rules)
                            return;
                        var i = v.rules.length;
                        while (i--) {
                            var r = v.rules[i];
                            if (r.type != 'field')
                                continue;
                            if (!WAPF.Api.Collections.findFirst(_this.fields, 'id', r.field))
                                v.rules.splice(i, 1);
                        }
                    });
                    _this.onChange();
                });
                this.onChange();
            }
            VariablesCtrl.prototype.activateVariable = function (index) {
                var $parent = jQuery('[data-variable-id=' + this.variables[index].name + '] .wapf-collapsible__header').trigger('click');
            };
            return VariablesCtrl;
        }());
        Controllers.VariablesCtrl = VariablesCtrl;
    })(Controllers = WAPF.Controllers || (WAPF.Controllers = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var Choice = /** @class */ (function () {
            function Choice() {
                this.selected = false;
                this.slug = WAPF.Api.Helpers.uniqueIdWithLength(5);
                this.label = '';
                this.pricing_type = 'none';
                this.pricing_amount = 0;
                this.options = {};
            }
            return Choice;
        }());
        Models.Choice = Choice;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var ConditionRuleGroup = /** @class */ (function () {
            function ConditionRuleGroup() {
                this.rules = [];
            }
            return ConditionRuleGroup;
        }());
        Models.ConditionRuleGroup = ConditionRuleGroup;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var ConditionRule = /** @class */ (function () {
            function ConditionRule() {
                // Defaults
                this.subject = 'auth';
                this.condition = 'auth';
            }
            return ConditionRule;
        }());
        Models.ConditionRule = ConditionRule;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var ConditionalRule = /** @class */ (function () {
            function ConditionalRule() {
                //this.condition = '==';
            }
            return ConditionalRule;
        }());
        Models.ConditionalRule = ConditionalRule;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var Conditional = /** @class */ (function () {
            function Conditional() {
                this.rules = [];
            }
            return Conditional;
        }());
        Models.Conditional = Conditional;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var FieldClone = /** @class */ (function () {
            function FieldClone() {
                this.enabled = false;
                this.type = 'qty';
            }
            return FieldClone;
        }());
        Models.FieldClone = FieldClone;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var FieldPricing = /** @class */ (function () {
            function FieldPricing() {
                this.enabled = false;
                this.type = 'fixed';
                this.amount = 0;
            }
            return FieldPricing;
        }());
        Models.FieldPricing = FieldPricing;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var Field = /** @class */ (function () {
            function Field() {
                var _this = this;
                // Functions for the 'choice' option
                this.addChoiceEvent = function (e) {
                    e.preventDefault();
                    _this.addChoice();
                };
                this.deleteChoice = function (e, data) {
                    e.preventDefault();
                    var deletedId = _this.choices[data.$index].slug;
                    _this.choices.splice(data.$index, 1);
                    jQuery(document).trigger('wapf/field/option_removed', [deletedId, _this]); // This has to come before the onchange
                    data.$parent.$parent.onChange();
                };
                // Set other "selecteds" off since only one "selected checkbox can be checked
                this.checkSelected = function (e, data) {
                    var multiOption = jQuery(e.currentTarget).data('multi-option');
                    if (!multiOption) {
                        for (var i = 0; i < _this.choices.length; i++) {
                            if (i !== data.$index)
                                _this.choices[i].selected = false;
                        }
                    }
                    data.$parent.$parent.onChange();
                };
                // Defaults TODO internationalize
                this.conditionals = [];
                this.label = 'New field';
                //this.key = 'new_field';
                this.type = 'text';
                this.id = WAPF.Api.Helpers.uniqueId();
                this.pricing = new WAPF.Models.FieldPricing();
                this.clone = new WAPF.Models.FieldClone();
                //this.updatedKey = false;
                this.level = 0;
                this.group = 'field';
            }
            Field.prototype.addChoice = function (item, color) {
                if (item === void 0) { item = null; }
                if (color === void 0) { color = null; }
                if (!this.choices)
                    this.choices = [];
                var c = new Models.Choice();
                if (item && ['color-swatch', 'multi-color-swatch', 'select', 'checkboxes', 'text-swatch', 'multi-text-swatch', 'radio'].indexOf(this.type) > -1)
                    c.label = item;
                if (['color-swatch', 'multi-color-swatch'].indexOf(this.type) > -1)
                    c.color = color || '#ffffff';
                this.choices.push(c);
                jQuery(document).trigger('wapf/field/option_added', [this, this.choices, c]);
            };
            return Field;
        }());
        Models.Field = Field;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var GalleryImage = /** @class */ (function () {
            function GalleryImage() {
                this.source = 'gallery';
                this.values = [];
            }
            return GalleryImage;
        }());
        Models.GalleryImage = GalleryImage;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var GalleryImageValue = /** @class */ (function () {
            function GalleryImageValue(field, value, fieldCache) {
                if (value === void 0) { value = '*'; }
                if (fieldCache === void 0) { fieldCache = null; }
                this.field = field;
                this.value = value;
                this.fieldCache = fieldCache;
            }
            return GalleryImageValue;
        }());
        Models.GalleryImageValue = GalleryImageValue;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var LayoutSettings = /** @class */ (function () {
            function LayoutSettings() {
                this.swap_type = 'rules';
                this.labels_position = 'above';
                this.instructions_position = 'field';
                this.mark_required = true;
                this.enable_gallery_images = false;
                this.gallery_images = [];
            }
            return LayoutSettings;
        }());
        Models.LayoutSettings = LayoutSettings;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var VairableRule = /** @class */ (function () {
            function VairableRule() {
                this.type = 'qty';
            }
            return VairableRule;
        }());
        Models.VairableRule = VairableRule;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Models;
    (function (Models) {
        var Variable = /** @class */ (function () {
            function Variable() {
                this["default"] = '0';
                this.rules = [];
            }
            return Variable;
        }());
        Models.Variable = Variable;
    })(Models = WAPF.Models || (WAPF.Models = {}));
})(WAPF || (WAPF = {}));

var WAPF;
(function (WAPF) {
    var Main = /** @class */ (function () {
        function Main() {
            // Set up tinybind.
            this.setupTinybind();
            // Allow external plugins to hook before admin init
            jQuery(document).trigger('wapf/admin/init_before');
            // init all controllers, FieldListcontroller should come after layout & var controller
            ['VariablesCtrl', 'LayoutCtrl', 'FieldListCtrl', 'ConditionsCtrl', 'ToolsCtrl'].forEach(function (c) {
                var $element = jQuery('[rv-controller="' + c + '"]');
                if ($element.length)
                    WAPF.Main.bindings[c] = tinybind.bind($element[0], new WAPF.Controllers[c]($element));
            });
            var $post = jQuery('#post');
            // Prevent saving and do validation.
            if (WAPF.Config.getVariable('isWooProductScreen') != 1)
                $post.on('submit', function (e) {
                    var hasError = false;
                    if (!jQuery('[name=post_title]').val()) {
                        alert(WAPF.Config.getTranslatedString('title_required'));
                        hasError = true;
                    }
                    if (!hasError && !jQuery('[name=wapf-fields]').val()) {
                        alert(WAPF.Config.getTranslatedString('fields_required'));
                        hasError = true;
                    }
                    if (hasError) {
                        e.stopPropagation();
                        e.preventDefault();
                    }
                });
            $post.on('submit', function (e) {
                jQuery('.wapf-error').removeClass('wapf-error');
                // When plugin isn't activated yet, but user wants to save their product page, this would
                // throw an error so add this check here.
                if (!WAPF.Main.bindings || !Object.keys(WAPF.Main.bindings).length)
                    return;
                var fields = WAPF.Main.bindings['FieldListCtrl'].models.fields;
                var hasError = false;
                for (var i = 0; i < fields.length; i++) {
                    var f = fields[i];
                    if (f.choices) {
                        for (var j = 0; j < f.choices.length; j++) {
                            if (!f.choices[j].label) {
                                jQuery('.customfields_tab a').trigger('click');
                                if (!WAPF.Main.bindings['FieldListCtrl'].models.activeField || WAPF.Main.bindings['FieldListCtrl'].models.activeField.id != f.id)
                                    WAPF.Main.bindings['FieldListCtrl'].models.setActiveField(new Event('click'), { $index: i });
                                var $row = jQuery('[data-option-slug="' + f.choices[j].slug + '"]');
                                setTimeout(function () {
                                    jQuery('html,body').animate({ scrollTop: $row.offset().top - 70 }, 150);
                                }, 200);
                                $row.find('.choice-label').addClass('wapf-error');
                                hasError = true;
                                break;
                            }
                        }
                    }
                }
                if (hasError) {
                    e.stopPropagation();
                    e.preventDefault();
                }
                jQuery(document).trigger('wapf/admin/before_submit');
            });
            // Allow external plugins to hook after admin init
            jQuery(document).trigger('wapf/admin/init_after');
            // Don't allow re-ordering meta boxes (no specific reason, just not really practical as we don't save it)
            jQuery('.meta-box-sortables').sortable({
                disabled: true
            });
            // Initialize collapsible boxes
            jQuery('.wapf-collapsible__holder').on('click', '.wapf-collapsible__header', function (e) {
                var $this = jQuery(e.currentTarget);
                var $holder = $this.closest('.wapf-collapsible__holder');
                var $parent = $this.closest('.wapf-collapsible__wrapper');
                $holder.find('.wapf-collapsible__wrapper').not($parent).removeClass('wapf--active');
                $holder.find('.wapf-collapsible__body').not($parent.find('.wapf-collapsible__body')).slideUp(200);
                $parent.find('.wapf-collapsible__body').slideToggle(200);
                $parent.toggleClass('wapf--active');
            });
            // Delete files button
            jQuery('.wapf-delete-files').on('click', function (e) {
                e.preventDefault();
                if (confirm("Are you sure you want to delete uploaded files from this order? This action can't be undone.")) {
                }
            });
            // Hide preloader
            jQuery('.wapf-preloader').remove();
        }
        Main.prototype.setupTinybind = function () {
            function findFuncRecursive(observer, func, data) {
                if (func === void 0) { func = 'onChange'; }
                if (data === void 0) { data = null; }
                if (observer.obj) {
                    var o = observer.obj;
                    // Travel up the chain to all "$parents" until we have the first one that has "onchange" function on it.
                    while (o && typeof o[func] != 'function') {
                        if (o.$parent)
                            o = o.$parent;
                        else
                            o = null;
                    }
                    if (o && o[func])
                        o[func](data);
                }
            }
            // Setting up tinybind:
            // 1. Add binders
            // An "rv-cloak" attribute which works like Angular's cloak.
            tinybind.binders.cloak = {
                priority: -1000,
                bind: function (el) {
                    el.style.display = 'block';
                }
            };
            tinybind.binders.disabled = {
                routine: function (el, value) {
                    el.disabled = !!value;
                },
                bind: function (el, value) {
                    el.disabled = !!value;
                }
            };
            tinybind.binders.colorpicker = {
                bind: function (el) {
                    var $e = jQuery(el);
                    var _this = this;
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var keypath = this.observer.key.path;
                    $e.wpColorPicker({
                        change: function (event, ui) {
                            var color = ui.color.toString();
                            adapter.set(_this.model, keypath, color);
                            findFuncRecursive(_this.observer);
                        },
                        clear: function () {
                            adapter.set(_this.model, keypath, $e.data('default-color'));
                            findFuncRecursive(_this.observer);
                        }
                    });
                    // Set color if already exists:
                    var startColor = adapter.get(_this.model, keypath) || $e.data('default-color');
                    if (startColor) {
                        $e.wpColorPicker('color', startColor);
                    }
                },
                unbind: function (el) {
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    adapter.set(model, keypath, '');
                    jQuery(el).remove();
                }
            };
            tinybind.binders['sortable-options'] = {
                priority: 100,
                bind: function (el) {
                    var _this_1 = this;
                    var $this = jQuery(el);
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var keypath = this.observer.key.path;
                    $this.sortable({
                        handle: '.wapf-option__sort',
                        axis: 'y',
                        opacity: .75,
                        tolerance: 'pointer',
                        update: function () {
                            // When drag complete, re-sort the fields.
                            var ids = [];
                            $this.find('.wapf-option').each(function (i, e) {
                                ids.push('' + jQuery(e).data('option-slug'));
                            });
                            var choices = adapter.get(_this_1.model, keypath);
                            choices.sort(function (a, b) {
                                var indexA = ids.indexOf(a.slug);
                                var indexB = ids.indexOf(b.slug);
                                if (indexA < indexB)
                                    return -1;
                                if (indexA > indexB)
                                    return 1;
                                return 0;
                            });
                            findFuncRecursive(_this_1.observer);
                        }
                    });
                }
            };
            tinybind.binders.mediaselector = {
                bind: function (el) {
                    var _this = this;
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var keypath = this.observer.key.path;
                    var $el = jQuery(el);
                    var get = $el.data('return-type') || 'url';
                    var filetypes = $el.data('filetypes') || null;
                    var onChange = $el.data('change');
                    new WAPF.Components.MediaSelector($el.closest('.wapf-media-selector'), function (selected) {
                        var v = selected.id;
                        var url = selected.sizes && selected.sizes.full ? selected.sizes.full.url : selected.url;
                        var thumb = selected.sizes && selected.sizes.thumbnail ? selected.sizes.thumbnail.url : url;
                        switch (get) {
                            case 'url':
                                v = url;
                                break;
                            case 'id':
                                v = selected.id;
                                break;
                            case 'object':
                                v = { id: selected.id, thumb: thumb };
                                break;
                            case 'attachment':
                                v = thumb;
                                break;
                            default:
                                v = url;
                                break;
                        }
                        adapter.set(_this.model, keypath, v);
                        if (get === 'attachment') {
                            adapter.set(_this.model, 'attachment', selected.id);
                        }
                        if (onChange && _this.observer.obj) {
                            findFuncRecursive(_this.observer, onChange, v);
                        }
                        findFuncRecursive(_this.observer);
                    }, function () {
                        adapter.set(_this.model, keypath, null);
                        if (onChange && _this.observer.obj) {
                            findFuncRecursive(_this.observer, onChange, null);
                        }
                        findFuncRecursive(_this.observer);
                    }, filetypes);
                },
                unbind: function (el) {
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    adapter.set(model, keypath, null);
                    jQuery(el).remove();
                }
            };
            tinybind.binders.formulabuilder = {
                bind: function (el) {
                    var _this = this;
                    var adapter = tinybind.adapters[_this.observer.key.i];
                    var keypath = _this.observer.key.path;
                    new WAPF.Components.FormulaBuilder(el, 'field', function (val) {
                        adapter.set(_this.model, keypath, val);
                    });
                },
                unbind: function (el) {
                    el.remove();
                }
            };
            tinybind.binders.productgallery = {
                bind: function (el) {
                    var _this = this;
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var keypath = this.observer.key.path;
                    new WAPF.Components.MediaSelector2(jQuery(el), function (selected, idx) {
                        var model = _this.model[keypath];
                        model[idx].source = 'upload';
                        model[idx].url = selected.sizes.full.url;
                        model[idx].id = selected.id;
                        adapter.set(_this.model, keypath, model);
                        findFuncRecursive(_this.observer);
                    }, 'pg_frame');
                },
                unbind: function (el) {
                    jQuery(el).remove();
                }
            };
            tinybind.binders.select2options = {
                priority: 2000,
                bind: function (el, value) {
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    var modelValue = adapter.get(model, keypath);
                    var $el = jQuery(el);
                    if (modelValue)
                        modelValue.forEach(function (item) {
                            jQuery('<option selected value="' + item.id + '">' + item.text + '</option>').appendTo($el);
                        });
                }
            };
            // Set a default value from a dropdown list as given from the backend (when the current value of the model is empty)
            tinybind.binders['default'] = {
                priority: 100,
                bind: function (el, v) {
                    var $el = jQuery(el);
                    var val = $el.val();
                    var d = $el.data('default');
                    if (d != null && d != undefined && d.toString().length && v == undefined && !val) {
                        var adapter = tinybind.adapters[this.observer.key.i];
                        var model = this.model;
                        var keypath = this.observer.key.path;
                        // Set the model
                        adapter.set(model, keypath, d);
                        // Dirty hack to call onChange function directly.
                        findFuncRecursive(this.observer);
                    }
                }
            };
            tinybind.binders['unique-checkbox'] = {
                bind: function (el) {
                    var $el = jQuery(el);
                    var id = WAPF.Api.Helpers.uniqueId();
                    $el.find('input').attr('id', 'wapf-toggle-' + id);
                    $el.find('label').attr('for', 'wapf-toggle-' + id);
                }
            };
            tinybind.binders['slugify'] = {
                priority: -1000,
                routine: function (el, value) {
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    adapter.set(model, keypath, WAPF.Api.Helpers.slugify(value));
                }
            };
            tinybind.binders['select2-basic'] = {
                bind: function (el) {
                    var _this = this;
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    var modelValue = adapter.get(model, keypath);
                    var $el = jQuery(el);
                    var options = {
                        width: '100%'
                    };
                    if ($el.data('source'))
                        options.data = typeof window[$el.data('source')] === 'function' ? window[$el.data('source')]($el) : window[$el.data('source')];
                    $el.select2(options);
                    if (modelValue)
                        $el.val(modelValue.split(',')).trigger('change');
                    var isMultiple = $el.prop('multiple');
                    // Whan an item is selected.
                    $el.on('select2:select', function (e) {
                        // Update the model
                        // Copy object and leave out "selected" property.
                        var selected = JSON.parse(JSON.stringify(e.params.data));
                        var modelValue = adapter.get(model, keypath);
                        if (isMultiple) {
                            modelValue = modelValue ? modelValue.split(',') : [];
                        }
                        else
                            modelValue = [];
                        modelValue.push(selected.id);
                        adapter.set(model, keypath, modelValue.join(','));
                        // Dirty hack to call the "rv-on-change".
                        findFuncRecursive(_this.observer);
                    });
                    // When deselecting an item
                    $el.on('select2:unselect', function (e) {
                        // Also remove it from the object.
                        var unselected = e.params.data;
                        var modelValue = adapter.get(model, keypath);
                        if (isMultiple) {
                            modelValue = modelValue ? modelValue.split(',') : [];
                            modelValue.splice(modelValue.indexOf(unselected.id), 1);
                        }
                        else
                            modelValue = [];
                        adapter.set(model, keypath, modelValue.join(','));
                        // Dirty hack to call the "rv-on-change".
                        findFuncRecursive(_this.observer);
                    });
                }
            };
            tinybind.binders.select2 = {
                initSelect2: function (el, _this) {
                    var adapter = tinybind.adapters[_this.observer.key.i];
                    var model = _this.model;
                    var keypath = _this.observer.key.path;
                    setTimeout(function () {
                        // initialize select2
                        WAPF.Api.Helpers.initializeSelect2(jQuery(el));
                        // Whan an item is selected.
                        jQuery(el).on('select2:select', function (e) {
                            // Update the model
                            // Copy object and leave out "selected" property.
                            var selected = JSON.parse(JSON.stringify(e.params.data));
                            var item = { id: selected.id, text: selected.text };
                            var modelValue = adapter.get(model, keypath);
                            if (Array.isArray(modelValue))
                                modelValue.push(item);
                            else
                                modelValue = [item];
                            adapter.set(model, keypath, modelValue);
                            // Dirty hack to call the "rv-on-change".
                            findFuncRecursive(_this.observer);
                        });
                        // When deselecting an item
                        jQuery(el).on('select2:unselect', function (e) {
                            // Seems like an awfully dirty hack -_- but idk what I'm doing with this.
                            // "select:unselect" is also called when you click on an item in the list that is already added. We can't have that.
                            if (e.params.originalEvent && e.params.originalEvent.type === 'mouseup' && !e.params.data.element)
                                return;
                            // Also remove it from the object.
                            var unselected = e.params.data;
                            var modelValue = adapter.get(model, keypath);
                            modelValue = modelValue.filter(function (item) {
                                return item.id != unselected.id;
                            });
                            adapter.set(model, keypath, modelValue);
                            // Dirty hack to call the "rv-on-change".
                            findFuncRecursive(_this.observer);
                        });
                    }, 0);
                },
                publishes: false,
                unbind: function (el) {
                    // Clear all options.
                    jQuery(el).html('');
                    jQuery(el).val(null).trigger('change');
                    // Set model to empty array
                    var adapter = tinybind.adapters[this.observer.key.i];
                    var model = this.model;
                    var keypath = this.observer.key.path;
                    adapter.set(model, keypath, []);
                    // Clear select2 events so they can rebind
                    jQuery(el).off('select2:select');
                    jQuery(el).off('select2:unselect');
                },
                priority: -99000,
                routine: function (el) {
                },
                bind: function (el) {
                    tinybind.binders.select2.initSelect2(el, this);
                }
            };
            // isEmpty checks if an array is empty.
            tinybind.formatters.isEmpty = function (arg) {
                if (typeof arg === "number")
                    return arg === 0;
                return !arg || !arg.length;
            };
            tinybind.formatters.isNotEmpty = function (arg) {
                return arg && arg.length;
            };
            // This formatter checks if an array has more than N elements.
            tinybind.formatters.hasMoreThan = function (arr, arg) {
                return Array.isArray(arr) && arr.length > arg;
            };
            // This formatter checks if an array has less than N elements.
            tinybind.formatters.hasLessThan = function (arr, arg) {
                return Array.isArray(arr) && arr.length < arg;
            };
            tinybind.formatters.prefix = function (value, arg) {
                return arg + value;
            };
            // Check if two objects are the same ( = have the same 'id' property).
            tinybind.formatters.equalIds = function (value, arg) {
                if (!value || !arg || !value.id || !arg.id)
                    return false;
                return value.id === arg.id;
            };
            tinybind.formatters.query = function () {
                var args = [].slice.call(arguments);
                var collection = args[0];
                if (!collection.length)
                    return collection;
                for (var i = 1; i < args.length; i++) {
                    switch (args[i]) {
                        case 'where':
                            collection = WAPF.Api.Collections.findAll(collection, args[i + 1], args[i + 3], args[i + 2]);
                            break;
                        case 'first':
                            collection = WAPF.Api.Collections.findFirst(collection, args[i + 1], args[i + 3], args[i + 2]);
                            break;
                        case 'array_get': return collection[args[i + 1]];
                        case 'get':
                            var get = function (from, toget) {
                                if (!from)
                                    return null;
                                if (toget.length === 1)
                                    return from[toget[0]];
                                else {
                                    var toreturn = {};
                                    toget.forEach(function (v) {
                                        toreturn[v] = from[v];
                                    });
                                    return toreturn;
                                }
                            };
                            var toget = args[i + 1].split(',');
                            collection = Array.isArray(collection) ? collection.map(function (a) { return get(a, toget); }) : get(collection, toget);
                            break;
                        case 'has': return WAPF.Api.Collections.findFirst(collection, args[i + 1], args[i + 2]) != null;
                    }
                }
                return collection;
            };
            tinybind.formatters.ifEmpty = function (str, otherStr) {
                return str ? str : (otherStr.charAt(0).toUpperCase() + otherStr.slice(1));
            };
            // Get the correct conditions for conditionals.
            tinybind.formatters.filterConditions = function (allConditions, id, allFields) {
                var theField = WAPF.Api.Collections.findFirst(allFields, 'id', id);
                if (theField === null)
                    return [];
                var c = WAPF.Api.Collections.findFirst(allConditions, 'type', theField.type);
                if (!c)
                    return [];
                return c.conditions;
            };
            // Does the selected condition need a value entered in the "value" input box?
            tinybind.formatters.conditionDesc = function (conditionId, allConditions, fields, chosenFieldId) {
                var field = WAPF.Api.Collections.findFirst(fields, 'id', chosenFieldId);
                if (!field)
                    return false;
                var conditions = WAPF.Api.Collections.findFirst(allConditions, 'type', field.type);
                if (!conditions)
                    return false;
                var condition = WAPF.Api.Collections.findFirst(conditions.conditions, 'value', conditionId);
                return condition && condition.desc ? condition.desc : '';
            };
            tinybind.formatters.conditionNeedsValue = function (conditionId, allConditions, expectedValueType, fields, chosenFieldId) {
                var field = WAPF.Api.Collections.findFirst(fields, 'id', chosenFieldId);
                if (!field)
                    return false;
                var conditions = WAPF.Api.Collections.findFirst(allConditions, 'type', field.type);
                if (!conditions)
                    return false;
                var condition = WAPF.Api.Collections.findFirst(conditions.conditions, 'value', conditionId);
                if (!condition || !condition.type)
                    return false;
                return condition.type === expectedValueType;
            };
            tinybind.formatters.conditionDoesntNeedValue = function (conditionId, allConditions, fields, chosenFieldId) {
                var field = WAPF.Api.Collections.findFirst(fields, 'id', chosenFieldId);
                if (!field)
                    return true;
                var conditions = WAPF.Api.Collections.findFirst(allConditions, 'type', field.type);
                if (!conditions)
                    return true;
                var condition = WAPF.Api.Collections.findFirst(conditions.conditions, 'value', conditionId);
                return !condition || !condition.type;
            };
            tinybind.formatters.replace = function (value, args) {
                return args.replace('{x}', value);
            };
            tinybind.formatters.tostring = function (value) {
                if (typeof value === 'string')
                    return value;
                return JSON.stringify(value);
            };
            // General purpose formatters
            tinybind.formatters["in"] = function (value, args) {
                return args.split(',').indexOf(value) > -1;
            };
            tinybind.formatters.notin = function (value, args) {
                return args.split(',').indexOf(value) === -1;
            };
            tinybind.formatters.eq = function (value, args) {
                return value === args;
            };
            tinybind.formatters.eqloose = function (value, args) {
                return value == args;
            };
            tinybind.formatters.neq = function (value, args) {
                return value !== args;
            };
            tinybind.formatters.gt = function (value, args) {
                if (Array.isArray(args))
                    return value > args.length;
                return value > args;
            };
            tinybind.formatters.lt = function (value, args) {
                if (Array.isArray(args))
                    return value < args.length;
                return value < args;
            };
            tinybind.formatters.isLastIteration = function (value, args) {
                return value.length - 1 === args;
            };
            tinybind.formatters.and = function (value, args) {
                return value && args;
            };
        };
        Main.bindings = [];
        return Main;
    }());
    WAPF.Main = Main;
})(WAPF || (WAPF = {}));
jQuery(function () {
    // Init config from backend
    WAPF.Config.init();
    // Kickoff the app.
    new WAPF.Main();
});

var WAPF;
(function (WAPF) {
    var Config = /** @class */ (function () {
        function Config() {
        }
        Config.init = function () {
            this.language = wapf_language;
            this.variables = wapf_config;
            this.fieldgroupType = jQuery('[data-wapf-type]').data('wapf-type') || 'wapf_product';
            this.fieldGroupVisibilityConditions = jQuery('[data-fieldgroup-conditions]').data('fieldgroup-conditions');
            this.fieldVisibilityConditions = jQuery('[data-field-conditions]').data('field-conditions');
        };
        Config.getTranslatedString = function (key) {
            return this.language[key] || '';
        };
        Config.getVariable = function (key) {
            return this.variables[key];
        };
        Config.getFieldGroupVisibilityConditions = function () {
            return this.fieldGroupVisibilityConditions;
        };
        Config.getFieldVisibilityConditions = function () {
            return this.fieldVisibilityConditions;
        };
        return Config;
    }());
    WAPF.Config = Config;
})(WAPF || (WAPF = {}));
