<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'CRPRO_Local_Emails' ) ) :

	class CRPRO_Local_Emails {

		public function __construct() {
			add_filter( 'cr_local_review_reminder_subject', array( $this, 'advanced_review_reminder_subject' ), 10, 2 );
			add_filter( 'cr_local_review_discount_subject', array( $this, 'advanced_review_discount_subject' ), 10, 2 );
			add_filter( 'cr_local_review_reminder_template', array( $this, 'advanced_review_reminder_template' ), 10, 2 );
			add_filter( 'cr_local_review_discount_template', array( $this, 'advanced_review_discount_template' ), 10, 2 );
		}

		// filter for the review reminder email subject
		public function advanced_review_reminder_template( $template, $args ) {
			return $this->advanced_email_template( $template, $args, 'ivole_email_review_reminder' );
		}

		// filter for the review discount email subject
		public function advanced_review_discount_template( $template, $args ) {
			return $this->advanced_email_template( $template, $args, 'ivole_email_review_discount' );
		}

		public function advanced_email_template( $template, $args, $email_type ) {
			$email_template = get_option( $email_type, array() );
			if( isset( $email_template['enabled'] ) && $email_template['enabled'] ) {
				if(
					isset( $email_template['email'] ) &&
					is_array( $email_template['email'] )
				) {
					$lang = strtoupper( $args['language'] );
					// try to find an email template in the language of customer order
					if(
						isset( $email_template['email'][$lang] ) &&
						is_array( $email_template['email'][$lang] ) &&
						isset( $email_template['email'][$lang]['templateInline'] )
					) {
						$template = $email_template['email'][$lang]['templateInline'];
						$template = self::replace_variables_template( $template, $args, $email_type );
					} else {
						// as a fallback try to use an English language template
						$lang = 'EN';
						if(
							isset( $email_template['email'][$lang] ) &&
							is_array( $email_template['email'][$lang] ) &&
							isset( $email_template['email'][$lang]['templateInline'] )
						) {
							$template = $email_template['email'][$lang]['templateInline'];
							$template = self::replace_variables_template( $template, $args, $email_type );
						}
					}
				}
			}
			return $template;
		}

		// filter for the review reminder email subject
		public function advanced_review_reminder_subject( $subject, $args ) {
			return $this->advanced_email_subject( $subject, $args, 'ivole_email_review_reminder' );
		}

		// filter for the review discount email subject
		public function advanced_review_discount_subject( $subject, $args ) {
			return $this->advanced_email_subject( $subject, $args, 'ivole_email_review_discount' );
		}

		public function advanced_email_subject( $subject, $args, $email_type ) {
			$email_template = get_option( $email_type, array() );
			if( isset( $email_template['enabled'] ) && $email_template['enabled'] ) {
				if(
					isset( $email_template['email'] ) &&
					is_array( $email_template['email'] )
				) {
					$lang = strtoupper( $args['language'] );
					// try to find an email template in the language of customer order
					if(
						isset( $email_template['email'][$lang] ) &&
						is_array( $email_template['email'][$lang] ) &&
						isset( $email_template['email'][$lang]['subject'] )
					) {
						$subject = $email_template['email'][$lang]['subject'];
						$subject = self::replace_variables_subject( $subject, $args );
					} else {
						// as a fallback try to use an English language template
						$lang = 'EN';
						if(
							isset( $email_template['email'][$lang] ) &&
							is_array( $email_template['email'][$lang] ) &&
							isset( $email_template['email'][$lang]['subject'] )
						) {
							$subject = $email_template['email'][$lang]['subject'];
							$subject = self::replace_variables_subject( $subject, $args );
						}
					}
				}
			}
			return $subject;
		}

		private static function replace_variables_template( $email_message, $args, $email_type ) {
			//  list products and list products with pics
			$list_products = '';
			$list_products_w_pics = '';
			$price_args = array( 'currency' => $args['currency'] );
			if( is_array( $args['items'] ) ) {
				foreach( $args['items'] as $item ) {
					$tmp = $item['name'] . ' / ' . self::crpro_price( $item['price'], $price_args ) . '<br>';
					$list_products .= $tmp;
					$list_products_w_pics .= sprintf( '<img src="%1$s" style="max-width: 50px; max-height: 50px; vertical-align: middle; margin: 5px 10px 5px 0;"><span style="vertical-align: middle;">%2$s</span><br>', $item['image'], $tmp );
				}
			}

			// unsubscribe link
			$unsubscribe_url = '';
			$unsubscribe_page = get_option( 'ivole_unsubscribe_page', '' );
			if( $unsubscribe_page ) {
				$unsubscribe_url = get_permalink( $unsubscribe_page );
				if( $args['is_test'] ) {
					$query_args = array(
						'cr-test' => 'yes',
						'cr-unsubscribe' => $args['email']
					);
				} else {
					$query_args = array(
						'cr-unsubscribe' => $args['email']
					);
				}
				$unsubscribe_url = esc_url( add_query_arg( $query_args, $unsubscribe_url ) );
			}

			if( 'ivole_email_review_reminder' === $email_type ) {
				$vars = array(
					'{{reviewLink}}',
					'{{shop name}}',
					'{{customer first name}}',
					'{{customer last name}}',
					'{{customer name}}',
					'{{order id}}',
					'{{order date}}',
					'{{list products}}',
					'{{list products with pics}}',
					'{{unsubscribeLink}}'
				);
				$replacement = array(
					$args['review_form'],
					CRPRO_Form_Editor_Settings::get_shop_name(),
					$args['firstname'],
					$args['lastname'],
					trim( $args['firstname'] . ' ' . $args['lastname'] ),
					$args['order_id'],
					$args['order_date'],
					$list_products,
					$list_products_w_pics,
					$unsubscribe_url
				);
			} elseif( 'ivole_email_review_discount' === $email_type ) {
				$vars = array(
					'{{shop name}}',
					'{{customer first name}}',
					'{{customer last name}}',
					'{{customer name}}',
					'{{order id}}',
					'{{order date}}',
					'{{list products}}',
					'{{list products with pics}}',
					'{{unsubscribeLink}}',
					'{{discount amount}}',
					'{{coupon code}}'
				);
				$replacement = array(
					CRPRO_Form_Editor_Settings::get_shop_name(),
					$args['firstname'],
					$args['lastname'],
					trim( $args['firstname'] . ' ' . $args['lastname'] ),
					$args['order_id'],
					$args['order_date'],
					$list_products,
					$list_products_w_pics,
					$unsubscribe_url,
					$args['discount_amount'],
					$args['discount_code']
				);
			} else {
				$vars = array();
				$replacement = array();
			}

			for( $i = 0; $i < count( $vars ); $i++ ) {
				$email_message = str_replace( $vars[$i], $replacement[$i], $email_message );
			}
			return $email_message;
		}

		private static function replace_variables_subject( $email_subject, $args ) {
			$vars = array(
				'{customer_first_name}',
				'{customer_last_name}',
				'{customer_name}',
				'{order_id}'
			);
			$replacement = array(
				$args['firstname'],
				$args['lastname'],
				trim( $args['firstname'] . ' ' . $args['lastname'] ),
				$args['order_id']
			);
			for( $i = 0; $i < count( $vars ); $i++ ) {
				$email_subject = str_replace( $vars[$i], $replacement[$i], $email_subject );
			}
			return $email_subject;
		}

		private static function crpro_price( $price, $args = array() ) {
			$args = wp_parse_args(
				$args,
				array(
					'ex_tax_label'       => false,
					'currency'           => '',
					'decimal_separator'  => wc_get_price_decimal_separator(),
					'thousand_separator' => wc_get_price_thousand_separator(),
					'decimals'           => wc_get_price_decimals(),
					'price_format'       => get_woocommerce_price_format(),
				)
			);

			$unformatted_price = $price;
			$negative          = $price < 0;
			$price             = floatval( $negative ? $price * -1 : $price );
			$price             = number_format( $price, $args['decimals'], $args['decimal_separator'], $args['thousand_separator'] );

			if ( apply_filters( 'woocommerce_price_trim_zeros', false ) && $args['decimals'] > 0 ) {
				$price = wc_trim_zeros( $price );
			}

			$formatted_price = ( $negative ? '-' : '' ) . sprintf( $args['price_format'], '<span class="cr-Price-currencySymbol">' . get_woocommerce_currency_symbol( $args['currency'] ) . '</span>', $price );
			$return          = '<span class="cr-Price-amount amount"><bdi>' . $formatted_price . '</bdi></span>';

			return apply_filters( 'crpro_price', $return, $price, $args, $unformatted_price );
		}

	}

endif;
