<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'CRPRO_Sender' ) ) :

	class CRPRO_Sender {

		public function __construct() {
			add_filter( 'cr_skip_reminder_internal', array( $this, 'skip_reminder_excluded_emails' ), 10, 2 );
			add_filter( 'cr_reminder_delay', array( $this, 'reminder_delay' ), 10, 3 );
			add_filter( 'cr_onsite_questions', array( $this, 'max_onsite_questions' ) );
			add_filter( 'cr_onsite_ratings', array( $this, 'max_onsite_ratings' ) );
		}

		public function skip_reminder_excluded_emails( $skip, $order ) {
			if( $order && method_exists( $order, 'get_billing_email' ) ) {
				// check if there are any emails in the unsubscribe list
				$unsubscribe_list = get_option( 'ivole_unsubscribed_emails', array() );
				// check if there are any exclusion rules for emails
				$exclude_emails = trim( get_option( 'ivole_exclude_emails', '' ) );
				if(
					0 < count( $unsubscribe_list ) ||
					0 < strlen( $exclude_emails )
				) {
					$keywords = explode( ',', $exclude_emails );

					// check if registered customers option is used
					$registered_customers = ( 'yes' === get_option( 'ivole_registered_customers', 'no' ) ) ? true : false;

					$email = '';
					$user = $order->get_user();
					if( $registered_customers ) {
						if( $user ) {
							$email = $user->user_email;
						} else {
							$email = $order->get_billing_email();
						}
					} else {
						$email = $order->get_billing_email();
					}

					if( $email ) {
						$email = mb_strtolower( trim( $email ) );

						// check if the email is in the list of unsubscribed emails
						if( in_array( $email, $unsubscribe_list ) ) {
							$order->add_order_note(
								__( 'CR: a review reminder was not scheduled because the customer had unsubscribed from receiving emails.', 'customer-reviews-woocommerce-pro' )
							);
							return true;
						}

						// check if the email contains any of the keywords
						foreach( $keywords as $keyword ) {
							$keyword = trim( $keyword );
							if( false !== strpos( $email, $keyword ) ) {
								$order->add_order_note(
									sprintf(
										__( 'CR: a review reminder was not scheduled because the email address contains a keyword \'%s\' that was configured as an exclusion in the settings.', 'customer-reviews-woocommerce-pro' ),
										$keyword
									)
								);
								return true;
							}
						}
					}
				}
			}
			return false;
		}

		public function reminder_delay( $timestamp, $order_id, $delay ) {
			// check send at setting
			$sendat = get_option( 'ivole_sending_time', 'nopref' );
			// check if there are any country-specific settings
			$countries = get_option( 'ivole_country_delays', '' );
			if( $countries && is_array( $countries ) && 0 < count( $countries ) ) {
				// find the shipping country from the order
				$shipping_country = apply_filters( 'woocommerce_get_base_location', get_option( 'woocommerce_default_country' ) );
				$order = wc_get_order( $order_id );
				if( method_exists( $order, 'get_shipping_country' ) ) {
					$tmp_shipping_country = $order->get_shipping_country();
					if( 0 < strlen( $tmp_shipping_country ) ) {
						$shipping_country = $tmp_shipping_country;
					}
				}
				if( isset( $countries[$shipping_country] ) ) {
					$delay = $countries[$shipping_country]['delay'];
					$sendat = $countries[$shipping_country]['sendat'];
					$timestamp = time() + $countries[$shipping_country]['delay'] * DAY_IN_SECONDS;
				}
			}
			// sending delay should be at least a day
			if( 1 <= $delay && 'nopref' !== $sendat ) {
				$dt = new DateTime();
				$dt->setTimestamp( $timestamp );
				$dt->setTimezone( wp_timezone() );
				if( 5 === strlen( $sendat ) ) {
					$dt->setTime(
						intval( substr( $sendat, 0, 2 ) ),
						intval( substr( $sendat, 3, 2 ) )
					);
					$timestamp = $dt->getTimestamp();
				}
			}

			return $timestamp;
		}

		public function max_onsite_questions( $max ) {
			return 100;
		}

		public function max_onsite_ratings( $max ) {
			return 100;
		}

	}

endif;
