<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'CRPRO_Emails_Settings' ) ) :

	class CRPRO_Emails_Settings {

		public function __construct() {
			add_filter( 'cr_settings_email_template', array( $this, 'extra_email_template_settings' ), 10, 2 );
			add_filter( 'cr_settings_email_template_php', array( $this, 'email_template_php_settings' ), 10, 2 );
			add_filter( 'cr_settings_emails_sections', array( $this, 'display_email_editor' ), 10, 2 );

			// display information about [cusrev_unsubscribe] on the settings page with shortcodes
			add_filter( 'cr_settings_shortcodes_desc', array( $this, 'shortcodes_settings' ) );

			add_action( 'woocommerce_admin_field_crpro_advanced_email_template', array( $this, 'show_advanced_email_template' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts_styles' ) );
			add_action( 'admin_footer', array( $this, 'output_inline_scripts' ) );
		}

		public function enqueue_scripts_styles( $hook_suffix ) {
			// email editor scripts and styles
			if(
				isset( $_SERVER['REQUEST_URI'] ) &&
				(
					false !== strpos( $_SERVER['REQUEST_URI'], 'page=cr-reviews-settings&tab=emails&section=review_reminder_editor' ) ||
					false !== strpos( $_SERVER['REQUEST_URI'], 'page=cr-reviews-settings&tab=emails&section=review_discount_editor' )
				)
			) {
				wp_enqueue_style( 'crpro-font-awesome', plugins_url( '/dist/css/font-awesome.min.css', dirname( __FILE__ ) ), array() );
				wp_enqueue_style( 'crpro-email-editor-vendors', plugins_url( '/dist/css/email-editor-vendors.css', dirname( __FILE__ ) ), array(), CRPRO::CRPRO_VERSION  );
				wp_enqueue_style( 'crpro-email-editor-app', plugins_url( '/dist/css/email-editor-app.css', dirname( __FILE__ ) ), array( 'crpro-email-editor-vendors', 'crpro-font-awesome' ), CRPRO::CRPRO_VERSION  );
				wp_enqueue_script( 'crpro-pace', plugins_url( '/dist/js/pace/pace.min.js' , dirname( __FILE__ ) ), array(), CRPRO::CRPRO_VERSION, true );
				wp_enqueue_script( 'crpro-tinymce', plugins_url( '/dist/js/tinymce/tinymce.min.js' , dirname( __FILE__ ) ), array(), CRPRO::CRPRO_VERSION, true );
				wp_enqueue_script( 'crpro-email-editor-vendors', plugins_url( '/dist/js/email-editor-vendors.js' , dirname( __FILE__ ) ), array(), CRPRO::CRPRO_VERSION, true );
				wp_enqueue_script( 'crpro-email-editor-bundle', plugins_url( '/dist/js/email-editor-bundle.js' , dirname( __FILE__ ) ), array( 'crpro-email-editor-vendors', 'crpro-tinymce' ), CRPRO::CRPRO_VERSION, true );
			}
		}

		public function output_inline_scripts() {
			if(
				isset( $_SERVER['REQUEST_URI'] ) &&
				(
					false !== strpos( $_SERVER['REQUEST_URI'], 'page=cr-reviews-settings&tab=emails&section=review_reminder_editor' ) ||
					false !== strpos( $_SERVER['REQUEST_URI'], 'page=cr-reviews-settings&tab=emails&section=review_discount_editor' )
				)
			) {
				?>
					<script type="text/javascript" >
						window.paceOptions = {
							restartOnPushState: false,
							ajax: false,
							elements: {
								selectors: ['body.ready']
							},
							target: '.crpro-email-editor-pace',
						}
					</script>
				<?php
			}
		}

		public function extra_email_template_settings( $fields, $email_type ) {
			if( in_array( $email_type, array( 'review_reminder', 'review_discount' ) ) ) {
				if( 'no' === get_option( 'ivole_verified_reviews', 'no' )  ) {
					// Advanced email template editor
					$fields[3] = array(
						'title' => __( 'Advanced Email Template', 'customer-reviews-woocommerce-pro' ),
						'type' => 'crpro_advanced_email_template',
						'desc' => __( 'Customize emails with a visual template editor.', 'customer-reviews-woocommerce-pro' ),
						'desc_tip' => true,
						'custom_attributes' => array( $email_type )
					);

					// add a setting for an unsubscribe page
					$fields[63] = array(
						'title' => __( 'Unsubscribe page', 'customer-reviews-woocommerce-pro' ),
						'type' => 'single_select_page_with_search',
						'id' => 'ivole_unsubscribe_page',
						'desc' => __( 'Set a page where customers will be taken to after clicking on an unsubscribe link in an email. Please add [cusrev_unsubscribe] shortcode to that page. If you use a caching plugin, it is recommended to exclude the unsubscribe page from caching.', 'customer-reviews-woocommerce-pro' ),
						'default' => '',
						'class'    => 'wc-page-search',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									wc_get_page_id( 'checkout' ),
									wc_get_page_id( 'myaccount' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false
					);

					$setting_name = self::get_setting_name( $email_type );
					$email_template = get_option( $setting_name, array() );
					if( isset( $email_template[ 'enabled' ] ) && $email_template[ 'enabled' ] ) {
						// hide basic settings for form templates
						unset( $fields[35] );
						unset( $fields[40] );
						unset( $fields[45] );
						unset( $fields[50] );
						unset( $fields[55] );
						unset( $fields[60] );
					}
				}
			}
			return $fields;
		}

		public function email_template_php_settings( $display, $email_type ) {
			$setting_name = self::get_setting_name( $email_type );
			$email_template = get_option( $setting_name, array() );
			if( isset( $email_template[ 'enabled' ] ) && $email_template[ 'enabled' ] ) {
				$display = false;
			}
			return $display;
		}

		public function show_advanced_email_template( $field ) {
			$setting_name = '';
			$setting_status = esc_html( __( 'Disabled', 'customer-reviews-woocommerce-pro' ) );
			$setting_class = ' crpro-settings-status-disabled';
			$editor_section = '';
			if(
				isset( $field['custom_attributes'] ) &&
				is_array( $field['custom_attributes'] ) &&
				0 < count( $field['custom_attributes'] )
			) {
				$setting_name = self::get_setting_name( $field['custom_attributes'][0] );
				$editor_section = $field['custom_attributes'][0] . '_editor';
			}
			if( $setting_name ) {
				$email_template = get_option( $setting_name, array() );
				if( isset( $email_template[ 'enabled' ] ) && $email_template[ 'enabled' ] ) {
					$setting_status = esc_html( __( 'Enabled', 'customer-reviews-woocommerce-pro' ) );
					$setting_class = ' crpro-settings-status-enabled';
				}
			}
			?>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="<?php echo esc_attr( $field['id'] ); ?>"><?php echo esc_html( $field['title'] ); ?>
						<span class="woocommerce-help-tip" data-tip="<?php echo esc_attr( $field['desc'] ); ?>"></span>
					</label>
				</th>
				<td class="forminp forminp-<?php echo sanitize_title( $field['type'] ) ?>">
					<div>
						<span class="cr-settings-manage-span<?php esc_attr_e( $setting_class ); ?>"><?php echo $setting_status; ?></span>
						<a class="button cr-settings-manage-button" href="<?php echo esc_url( admin_url( 'admin.php?page=cr-reviews-settings&tab=emails&section=' . $editor_section ) ); ?>"><?php echo esc_html( __( 'Customize', 'customer-reviews-woocommerce-pro' ) ); ?></a>
					</div>
				</td>
			</tr>
			<?php
		}

		public function display_email_editor( $section, $section_slug ) {
			if( 'review_reminder_editor' === $section_slug ) {
				$GLOBALS['hide_save_button'] = true;

				ob_start();

				echo '<h2>' . esc_html( __( 'Review Reminder Email Editor', 'customer-reviews-woocommerce-pro' ) );
				wc_back_link( __( 'Return to settings', 'customer-reviews-woocommerce-pro' ), admin_url( 'admin.php?page=cr-reviews-settings&tab=emails&section=review_reminder' ) );
				echo '</h2>';
				echo '<p>' . esc_html( __( 'A visual editor to customize email templates for review reminders. It should be used when reviews are collected without third-party verification.', 'customer-reviews-woocommerce-pro' ) ) . '</p>';
				echo '<div class="crpro-email-editor-pace"></div>';
				echo '<input type="hidden" id="crpro_email_editor_nonce" data-nonce="' . wp_create_nonce( 'crpro-email-editor' ) . '" />';
				echo '<input type="hidden" id="crpro_email_editor_type" data-type="review-reminder" />';
				echo '<div id="crpro_email_editor"></div>';

				$section = ob_get_clean();
			} elseif( 'review_discount_editor' === $section_slug ) {
				$GLOBALS['hide_save_button'] = true;

				ob_start();

				echo '<h2>' . esc_html( __( 'Review for Discount Email Editor', 'customer-reviews-woocommerce-pro' ) );
				wc_back_link( __( 'Return to settings', 'customer-reviews-woocommerce-pro' ), admin_url( 'admin.php?page=cr-reviews-settings&tab=emails&section=review_discount' ) );
				echo '</h2>';
				echo '<p>' . esc_html( __( 'A visual editor to customize templates of emails with discounts.', 'customer-reviews-woocommerce-pro' ) ) . '</p>';
				echo '<div class="crpro-email-editor-pace"></div>';
				echo '<input type="hidden" id="crpro_email_editor_nonce" data-nonce="' . wp_create_nonce( 'crpro-email-editor' ) . '" />';
				echo '<input type="hidden" id="crpro_email_editor_type" data-type="coupon-after-review" />';
				echo '<div id="crpro_email_editor"></div>';

				$section = ob_get_clean();
			}
			return $section;
		}

		private static function get_setting_name( $email_type ) {
			$name = '';
			switch( $email_type ) {
				case 'review_reminder':
					$name = 'ivole_email_review_reminder';
					break;
				case 'review_discount':
					$name = 'ivole_email_review_discount';
					break;
				default:
					break;
			}
			return $name;
		}

		// display information about [cusrev_unsubscribe] on the settings page with shortcodes
		public function shortcodes_settings( $shortcodes_desc ) {
			if( 'no' === get_option( 'ivole_verified_reviews', 'no' )  ) {
				$unsubscribe_desc = '<br><p class="cr-admin-shortcodes-large"><code>[cusrev_unsubscribe]</code></p>' .
				'<p>' . __( 'Use this shortcode to display a form that customers can use to unsubscribe from review reminders and other emails sent by the plugin. If you use a caching plugin, it is recommended to exclude the unsubscribe page from caching to prevent expiration of security nonces. Here are the default parameters of the shortcode:', 'customer-reviews-woocommerce-pro' ) . '</p>' .
				'<p class="cr-admin-shortcodes"><code>[cusrev_unsubscribe]</code></p>' .
				'<p class="cr-admin-shortcodes"><b>' . __( 'Parameters:', 'customer-reviews-woocommerce' ) . '</b></p>' .
				'<ul>' .
				'<li>' . __( 'This shortcode does not have parameters.', 'customer-reviews-woocommerce' ) . '</li>' .
				'</ul>';
				$shortcodes_desc .= $unsubscribe_desc;
			}
			return $shortcodes_desc;
		}

	}

endif;
