<?php

namespace MailOptin\OntraportConnect;

use MailOptin\Core\Connections\AbstractConnect;

class ConnectSettingsPage
{
    public function __construct()
    {
        add_filter('mailoptin_connections_settings_page', array($this, 'connection_settings'));
        add_action('wp_cspa_settings_after_title', array($this, 'output_error_log_link'), 10, 2);
    }

    public function connection_settings($arg)
    {
        $connected = AbstractOntraportConnect::is_connected(true);
        if (true === $connected) {
            $status = sprintf('<span style="color:#008000">(%s)</span>', __('Connected', 'mailoptin'));
        } else {
            $status = sprintf("<span style='color:#FF0000'>(%s) </span>", __('Not Connected', 'mailoptin'));
        }

        $settingsArg[] = array(
            'section_title_without_status' => __('Ontraport', 'mailoptin'),
            'section_title'                => __('Ontraport Connection', 'mailoptin') . " $status",
            'type'                         => AbstractConnect::CRM_TYPE,
            'ontraport_api_key'            => array(
                'type'          => 'text',
                'obfuscate_val' => true,
                'label'         => __('Enter API Key', 'mailoptin'),
                'description'   => sprintf(
                    __('%sGet your API key and App ID%s', 'mailoptin'),
                    '<a target="_blank" href="https://app.ontraport.com/#!/api_settings/listAll">',
                    '</a>'
                ),
            ),
            'ontraport_app_id'             => array(
                'type'          => 'text',
                'obfuscate_val' => false,
                'label'         => __('Enter App ID', 'mailoptin'),
            )
        );

        return array_merge($arg, $settingsArg);
    }

    public function output_error_log_link($option, $args)
    {
        //Not a ontraport connection section
        if (MAILOPTIN_CONNECTIONS_DB_OPTION_NAME !== $option || ! isset($args['ontraport_api_key'])) {
            return;
        }

        //Output error log link if  there is one
        echo AbstractConnect::get_optin_error_log_link('ontraport');
    }

    public static function get_instance()
    {
        static $instance = null;

        if (is_null($instance)) {
            $instance = new self();
        }

        return $instance;
    }
}