<?php

defined( 'ABSPATH' ) or exit;

global $pw_gift_cards;

foreach( $order->get_items( 'pw_gift_card' ) as $line ) {
    $gift_card = new PW_Gift_Card( $line->get_card_number() );

    ?>
    <tr>
        <td class="label">
            <?php
                _e( 'PW Gift Card', 'pw-woocommerce-gift-cards' );

                if ( $gift_card->get_id() ) {
                    $status = '';
                    if ( !$gift_card->get_active() ) {
                        $status = __( ' (inactive)', 'pw-woocommerce-gift-cards' );
                    }

                    $check_balance_url = $gift_card->check_balance_url();
                    echo $status . ' <a href="' . $check_balance_url . '">' . $line->get_card_number() . '</a>: ';
                } else {
                    echo ' ' . __( '(deleted)', 'pw-woocommerce-gift-cards' ) . ' ' . $line->get_card_number() . ':';
                }
            ?>
        </td>
        <td width="1%"></td>
        <td class="total">
            <?php
                $amount = apply_filters( 'pwgc_to_order_currency', floatval( $line->get_amount() ) * -1, $order );

                // Aelia Currency Switcher
                if ( class_exists( 'WC_Aelia_CurrencySwitcher' ) && isset( $GLOBALS[WC_Aelia_CurrencySwitcher::$plugin_slug] ) ) {
                    ?>
                    <span class="woocommerce-Price-amount amount"><?php echo $amount; ?></span>
                    <?php
                } else {
                    $args = array();

                    // Multi-Currency for WooCommerce by TIV.NET INC
                    if ( is_a( $order, 'WC_Order' ) && class_exists( 'WOOMC\App' ) ) {
                        $args['currency'] = get_post_meta( $order->get_id(), '_order_currency', true );
                    }

                    // Currency Switcher for WooCommerce by WP Wham
                    if ( is_a( $order, 'WC_Order' ) && function_exists( 'alg_get_current_currency_code' ) ) {
                        $args['currency'] = get_post_meta( $order->get_id(), '_order_currency', true );
                    }

                    echo wc_price( $amount, $args );
                }
            ?>
        </td>
    </tr>
    <?php
}
