<?php

defined( 'ABSPATH' ) or exit;

if ( !class_exists( 'Wpeventin' ) ) {
    return;
}

final class PWGC_Eventin {
    function __construct() {
        add_action( 'pwgc_data_panel_product_redemption_restrictions', array( $this, 'pwgc_data_panel_product_redemption_restrictions' ) );
        add_action( 'pwgc_data_panel_variation_redemption_restrictions', array( $this, 'pwgc_data_panel_variation_redemption_restrictions' ), 10, 2 );
        add_action( 'pwgc_process_pw_gift_card_product_meta_data', array( $this, 'pwgc_process_pw_gift_card_product_meta_data' ) );
        add_action( 'pwgc_process_pw_gift_card_variation_meta_data', array( $this, 'pwgc_process_pw_gift_card_variation_meta_data' ), 10, 2 );
        add_filter( 'pwgc_product_has_redemption_restrictions', array( $this, 'pwgc_product_has_redemption_restrictions' ), 10, 2 );
        add_filter( 'pwgc_variation_has_redemption_restrictions', array( $this, 'pwgc_product_has_redemption_restrictions' ), 10, 2 );
        add_filter( 'pwgc_cart_item_eligible_for_redemption', array( $this, 'pwgc_cart_item_eligible_for_redemption' ), 10, 3 );
    }

    function get_event_options() {
        $all_events = get_posts( array(
            'posts_per_page'  => -1,
            'post_type' => 'etn'
        ) );

        $options = array();
        foreach( $all_events as $event) {
            $options[ $event->ID ] = $event->post_title;
        }

        return $options;
    }

    function get_product_eventin_events( $product ) {
        $eventin_events = array();
        if ( is_a( $product, 'WC_Product' ) ) {
            $eventin_events = $product->get_meta( '_pwgc_eventin_events' );
        }

        if ( empty( $eventin_events ) || !is_array( $eventin_events ) ) {
            $eventin_events = array();
        }

        return $eventin_events;
    }

    function pwgc_data_panel_product_redemption_restrictions( $product ) {

        $eventin_events = $this->get_product_eventin_events( $product );
        $options = $this->get_event_options();

        ?>
        <p class="form-field">
            <label for="_pwgc_eventin_events"><?php _e( 'Select Eventin Events', 'eventin' ); ?></label>
            <select id="_pwgc_eventin_events" name="_pwgc_eventin_events[]" style="width: 50%;" class="wc-enhanced-select" multiple="multiple" data-placeholder="<?php esc_attr_e( 'No Events', 'pw-woocommerce-gift-cards' ); ?>">
                <?php
                    foreach ( $options as $option_key => $option ) {
                        echo '<option value="' . esc_attr( $option_key ) . '" ' . wc_selected( true, in_array( $option_key, $eventin_events ) ) . '>' . esc_html( $option ) . '</option>';
                    }
                ?>
            </select>
        </p>
        <?php
    }

    function pwgc_data_panel_variation_redemption_restrictions( $variation, $index ) {

        $eventin_events = $this->get_product_eventin_events( $variation );
        $options = $this->get_event_options();

        ?>
        <p class="form-field form-row form-row-last">
            <label for="variable_pwgc_eventin_events"><?php _e( 'Select Eventin Events', 'eventin' ); ?></label>
            <select id="variable_pwgc_eventin_events" name="variable_pwgc_eventin_events[<?php esc_attr_e( $index ); ?>][]" style="width: 100%;" class="wc-enhanced-select" multiple="multiple" data-placeholder="<?php esc_attr_e( 'No Events', 'pw-woocommerce-gift-cards' ); ?>">
                <?php
                    foreach ( $options as $option_key => $option ) {
                        echo '<option value="' . esc_attr( $option_key ) . '" ' . wc_selected( true, in_array( $option_key, $eventin_events ) ) . '>' . esc_html( $option ) . '</option>';
                    }
                ?>
            </select>
        </p>
        <?php
    }

    function pwgc_process_pw_gift_card_product_meta_data( $product ) {
        $eventin_events = ( isset( $_POST['_pwgc_redemption_restrictions'] ) && isset( $_POST['_pwgc_eventin_events'] ) ) ? array_map( 'intval', (array) wp_unslash( $_POST['_pwgc_eventin_events'] ) ) : array();
        $product->update_meta_data( '_pwgc_eventin_events', $eventin_events );
    }

    function pwgc_process_pw_gift_card_variation_meta_data( $variation, $index ) {
        $eventin_events = isset( $_POST['variable_pwgc_redemption_restrictions'][ $index ] ) && isset( $_POST['variable_pwgc_eventin_events'][ $index ] ) ? array_map( 'intval', (array) wp_unslash( $_POST['variable_pwgc_eventin_events'][ $index ] ) ) : null;
        $variation->update_meta_data( '_pwgc_eventin_events', $eventin_events );
    }

    function pwgc_product_has_redemption_restrictions( $checked, $product ) {
        if ( !$checked ) {
            $eventin_events = $product->get_meta( '_pwgc_eventin_events' );
            $checked = !empty( $eventin_events );
        }

        return $checked;
    }

    function pwgc_cart_item_eligible_for_redemption( $eligible, $gift_card, $cart_item ) {
        if ( $eligible ) {

            $eventin_events = array();

            if ( is_a( $gift_card->get_product(), 'WC_Product_PW_Gift_Card' ) ) {
                $ids = $this->get_product_eventin_events( $gift_card->get_product() );
                if ( is_array( $ids ) ) {
                    $eventin_events = array_unique( array_merge( $eventin_events, $ids ), SORT_REGULAR );
                }
            }

            if ( is_a( $gift_card->get_variation(), 'WC_Product_Variation' ) ) {
                $ids = $this->get_product_eventin_events( $gift_card->get_variation() );
                if ( is_array( $ids ) ) {
                    $eventin_events = array_unique( array_merge( $eventin_events, $ids ), SORT_REGULAR );
                }
            }

            if ( !empty( $eventin_events ) && !in_array( $cart_item['product_id'], $eventin_events ) ) {
                $eligible = false;
            }
        }

        return $eligible;
    }
}

new PWGC_Eventin();
