<?php

defined( 'ABSPATH' ) or exit;

if ( !class_exists( 'WC_Payments' ) ) {
    return;
}

final class PWGC_WC_Payments {

    function __construct() {
        add_filter( 'wcpay_payment_request_level3_data', array( $this, 'wcpay_payment_request_level3_data' ), 10, 2 );
        add_filter( 'wcpay_payment_request_is_product_supported', array( $this, 'maybe_hide_express_checkout_buttons' ), 10, 2 );
        add_filter( 'wcpay_woopay_button_is_product_supported', array( $this, 'maybe_hide_express_checkout_buttons' ), 10, 2 );
    }

    /**
     * Apply gift card discount to Level 3 data for Stripe.
     *
     * @param  array    $level3_data
     * @param  WC_Order $order
     * @param  callable $normalize_fn
     *
     * @return array
     */
    function wcpay_payment_request_level3_data( $level3_data, $order ) {

        $gift_cards = array_values( $order->get_items( 'pw_gift_card' ) );
        if ( empty( $gift_cards ) ) {
            return $level3_data;
        }

        $total = 0;
        $currency = $order->get_currency();

        foreach ( $gift_cards as $line ) {
            $total += WC_Payments_Utils::prepare_amount( $line->get_amount(), $currency );
        };

        $product_description = 'PWGC ' . $order->get_id();
        $gift_card_line_item = (object) array(
            'unit_cost'           => 0,
            'quantity'            => 1,
            'tax_amount'          => 0,
            'discount_amount'     => $total,
            'product_code'        => 1,
            'product_description' => $product_description,
        );

        if ( !isset( $level3_data['line_items'] ) ) {
            $level3_data['line_items'] = array();
        }

        foreach ( $level3_data['line_items'] as $key => $line_item ) {
            if ( is_object( $line_item ) && property_exists( $line_item, 'product_description' ) && $line_item->product_description == $product_description ) {
                $level3_data['line_items'][ $key ] = $gift_card_line_item;
                return $level3_data;
            }
        }

        $level3_data['line_items'][] = $gift_card_line_item;

        return $level3_data;
    }

    function maybe_hide_express_checkout_buttons( $is_supported, $product ) {
        if ( $is_supported !== false ) {
            if ( is_a( $product, 'WC_Product_PW_Gift_Card' ) && !$product->get_pwgc_is_physical_card( 'edit' ) ) {
                $is_supported = false;
            }
        }

        return $is_supported;
    }
}

new PWGC_WC_Payments();
