( function() {
	jQuery(document).ready( function() {

		function crproUpdateCountriesInput() {
			let countriesInput = {};
			jQuery('.crpro-countries-table tbody tr.crpro-countries-tr').each( function( i ) {
				const tds = jQuery(this).find( 'td' );
				countriesInput[tds.eq( 0 ).data( 'country' )] = {
					'delay': tds.eq( 1 ).text(),
					'sendat': tds.eq( 2 ).data( 'sendat' )
				}
			} );
			jQuery('#ivole_country_delays').val( JSON.stringify( countriesInput ) );
		}

		// display a modal to a add country
		jQuery('.crpro-button-add-country').on( 'click', function( e ) {
			jQuery('.crpro-countries-modal-internal .crpro-countries-modal-title' ).text( crpro_object.modal_new );
			jQuery('.crpro-countries-modal-internal #crpro_select_country' ).prop( "disabled", false );
			jQuery('.crpro-countries-table tbody tr.crpro-countries-tr').each( function( i ) {
				jQuery('.crpro-countries-modal-internal #crpro_select_country option[value="' + jQuery(this).find( 'td' ).eq( 0 ).data( 'country' ) + '"]').prop( "disabled", true );
			} );
			const remainingCountries = jQuery('.crpro-countries-modal-internal #crpro_select_country option:not([disabled]');
			if( 0 < remainingCountries.length ) {
				remainingCountries.eq( 0 ).prop( 'selected', true );
			} else {
				alert( 'All countries have already been added' );
				return;
			}
			jQuery('.crpro-countries-modal-cont').addClass( 'crpro-countries-modal-visible' );
		} );

		// prevent propogation of a click event
		jQuery('.crpro-countries-modal-internal, .crpro-delete-modal-internal').on( 'click', function( e ) {
			e.stopPropagation();
		} );

		// close a modal to a add country
		jQuery('.crpro-countries-modal-close-top, .crpro-countries-modal-cancel, .crpro-countries-modal-cont').on( 'click', function( e ) {
			jQuery('.crpro-countries-modal-cont').removeClass( 'crpro-countries-modal-visible' );
		} );

		// close a modal to confirm deletion
		jQuery('.crpro-countries-modal-close-top, .crpro-countries-modal-cancel, .crpro-delete-modal-cont').on( 'click', function( e ) {
			jQuery('.crpro-delete-modal-cont').removeClass( 'crpro-countries-modal-visible' );
		} );

		// close a modal to a add country on ESC button
		jQuery(document).on( 'keyup', function( e ) {
			if( e.key === "Escape" ) {
				jQuery('.crpro-countries-modal-cont').removeClass( 'crpro-countries-modal-visible' );
				jQuery('.crpro-delete-modal-cont').removeClass( 'crpro-countries-modal-visible' );
			}
		} );

		// save country modal
		jQuery('.crpro-countries-modal .crpro-countries-modal-save').on( 'click', function( e ) {
			const country = jQuery(this).closest( '.crpro-countries-modal-internal' ).find( '#crpro_select_country' ).find( ':selected' );
			const delay = jQuery(this).closest( '.crpro-countries-modal-internal' ).find( '#crpro_sending_delay' );
			const sendAt = jQuery(this).closest( '.crpro-countries-modal-internal' ).find( '#crpro_send_at' ).find( ':selected' );
			const tdCountry = '<td data-country="' + country.val() + '">' + country.text() + '</td>';
			const tdDelay = '<td>' + delay.val() + '</td>';
			const tdSendAt = '<td data-sendat="' + sendAt.val() + '">' + sendAt.text() + '</td>';
			const tdButtonEdit = crpro_object.button_edit;
			const tdButtonDelete = crpro_object.button_delete;
			const tdButtons = '<td>' + tdButtonEdit + tdButtonDelete + '</td>';
			const tbody = jQuery('.crpro-countries-table').find( 'tbody' );

			// check if the country already exists in the table
			const countryAlreadyExists = tbody.find( 'tr.crpro-countries-tr' ).filter( function( index ) {
				return country.val() === jQuery('td', this).eq( 0 ).data('country');
			} );
			if( 0 === countryAlreadyExists.length ) {
				tbody.append( '<tr class="crpro-countries-tr">' + tdCountry + tdDelay + tdSendAt + tdButtons + '</tr>' );
				tbody.find( 'tr.crpro-countries-tr' ).sort( function( a, b ) {
					return jQuery('td', a).text().localeCompare( jQuery('td', b).text() );
				} ).appendTo( tbody );
			} else {
				const tdsToUpdate = countryAlreadyExists.eq( 0 ).find( 'td' );
				tdsToUpdate.eq( 1 ).text( delay.val() );
				tdsToUpdate.eq( 2 ).data( 'sendat', sendAt.val() );
				tdsToUpdate.eq( 2 ).text( sendAt.text() );
			}

			// remove the placeholder row
			if( 0 < tbody.find( 'tr.crpro-countries-tr' ).length ) {
				tbody.find( 'tr.crpro-countries-empty' ).addClass( 'crpro-generic-hide' );
			}

			// show or hide 'Add Country' button
			if( jQuery('.crpro-countries-table tbody tr.crpro-countries-tr').length >= jQuery('.crpro-countries-modal-internal #crpro_select_country option').length ) {
				jQuery('.crpro-button-add-country').addClass( 'crpro-generic-hide' );
			} else {
				jQuery('.crpro-button-add-country').removeClass( 'crpro-generic-hide' );
			}

			crproUpdateCountriesInput();

			jQuery('.crpro-countries-modal-cont').removeClass( 'crpro-countries-modal-visible' );
		} );

		// delete country modal
		jQuery('.crpro-delete-modal .crpro-countries-modal-save').on( 'click', function( e ) {
			const countryCode = jQuery(this).data( 'country' );
			jQuery('.crpro-countries-table tbody tr.crpro-countries-tr').each( function( i ) {
				if( jQuery(this).find( 'td' ).eq( 0 ).data( 'country' ) === countryCode ) {
					jQuery(this).remove();
					return false;
				}
			} );

			crproUpdateCountriesInput();

			// display the placeholder row
			if( 0 >= jQuery('.crpro-countries-table tbody tr.crpro-countries-tr').length ) {
				jQuery('.crpro-countries-table tbody tr.crpro-countries-empty' ).removeClass( 'crpro-generic-hide' );
			}

			jQuery('.crpro-delete-modal-cont').removeClass( 'crpro-countries-modal-visible' );
		} );

		// edit country settings
		jQuery('.crpro-countries-table').on( 'click', '.crpro-countries-button-edit', function( e ) {

			// current values
			const currentTds = jQuery(this).closest( '.crpro-countries-tr' ).find( 'td' );
			const country = currentTds.eq( 0 ).data( 'country' );
			const delay = currentTds.eq( 1 ).text();
			const sendAt = currentTds.eq( 2 ).data( 'sendat' );

			// update values in the modal box
			jQuery('.crpro-countries-modal-internal .crpro-countries-modal-title' ).text( crpro_object.modal_edit );
			jQuery('.crpro-countries-modal-internal #crpro_select_country' ).val( country );
			jQuery('.crpro-countries-modal-internal #crpro_select_country' ).prop( "disabled", true );
			jQuery('.crpro-countries-modal-internal #crpro_sending_delay' ).val( delay );
			jQuery('.crpro-countries-modal-internal #crpro_send_at' ).val( sendAt );

			jQuery('.crpro-countries-modal-cont').addClass( 'crpro-countries-modal-visible' );
		} );

		// delete country settings
		jQuery('.crpro-countries-table').on( 'click', '.crpro-countries-button-delete', function( e ) {

			const country = jQuery(this).closest( '.crpro-countries-tr' ).find( 'td' ).eq( 0 );
			jQuery('.crpro-delete-modal-cont .crpro-countries-modal-title').text( country.text() );
			jQuery('.crpro-delete-modal-cont .crpro-countries-modal-save').data( 'country', country.data( 'country' ) );

			jQuery('.crpro-delete-modal-cont').addClass( 'crpro-countries-modal-visible' );
		} );

	} );
} () );
