<?php
/**
 * WooCommerce Simple Storewide Sale Settings
 *
 * @package    Woocommerce_Simple_Storewide_Sale
 * @subpackage Woocommerce_Simple_Storewide_Sale/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( class_exists( 'WC_Settings_Page' ) ) :
	/**
	 * Simple_Storewide_Sale_For_Woocommerce_Settings
	 */
	class Simple_Storewide_Sale_For_Woocommerce_Settings extends WC_Settings_Page {

		/**
		 * Initialize the class and set its properties.
		 */
		public function __construct() {
			$this->id    = 'simple_storewide_sale';
			$this->label = __( 'Simple Storewide Sale', 'simple-storewide-sale-for-woocommerce' );
			add_filter( 'woocommerce_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
			add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
			add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
		}

		/**
		 * Get settings array
		 *
		 * @return array
		 */
		public function get_settings() {

			$product_categories_select = array();
			$product_tag_select        = array();

			$product_categories = get_terms( 'product_cat' );
			$product_tag        = get_terms( 'product_tag' );

			foreach ( $product_categories as $key => $value ) {

				$product_categories_select [ $value->term_id ] = $value->name;
			}

			foreach ( $product_tag as $key => $value ) {

				$product_tag_select [ $value->term_id ] = $value->name;
			}

			if ( sssfw_fs()->is_premium() ) {
				return apply_filters(
					'woocommerce_' . $this->id . '_settings', array(

						array(
							'title' => __( 'Simple Storewide Sale for WooCommerce Options', 'simple-storewide-sale-for-woocommerce' ),
							'type'  => 'title',
							'desc'  => '',
							'id'    => 'simple_lottery_options',
						),

						array(
							'title'    => __( 'Discount enable', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Enable storewide sales.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'checkbox',
							'id'       => 'wcsss_enable',
							'default'  => 'no',
							'desc_tip' => true,
						),
						array(
							'title'   => __( 'Discount amount', 'simple-storewide-sale-for-woocommerce' ),
							'type'    => 'text',
							'id'      => 'wcsss_amount',
							'default' => '',
							'class'   => 'wc_input_price',
							'css'   => 'position:relative'
						),
						array(
							'title'   => __( 'Discount type', 'simple-storewide-sale-for-woocommerce' ),
							'type'    => 'radio',
							'id'      => 'wcsss_type',
							'default' => '',
							'options' => array( '%', 'fixed' ),
						),
						array(
							'title'       => __( 'Sale starts', 'simple-storewide-sale-for-woocommerce' ),
							'id'          => 'wcsss_start',
							'type'        => 'datetimepicker',
							'class'       => 'datetimepicker',
							'placeholder' => __( 'From&hellip; YYYY-MM-DD HH:MM', 'simple-storewide-sale-for-woocommerce' ),
							'default'     => '',
						),
						array(
							'title'       => __( 'Sale ends', 'simple-storewide-sale-for-woocommerce' ),
							'id'          => 'wcsss_end',
							'type'        => 'datetimepicker',
							'class'       => 'datetimepicker',
							'placeholder' => __( 'To&hellip; YYYY-MM-DD HH:MM', 'simple-storewide-sale-for-woocommerce' ),
							'default'     => '',
						),
						array(
							'title'    => __( 'Exclude Sale products', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Exclude products that are already on sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'checkbox',
							'id'       => 'wcsss_exclude_sale',
							'default'  => 'no',
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Use regular price', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Use regular price for discount price for product that are already on sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'checkbox',
							'id'       => 'wcsss_use_regular_price',
							'default'  => 'no',
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Exclude Product type', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Select product type to exclude from sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'multiselect',
							'id'       => 'wcsss_exclude_type',
							'default'  => '',
							'class'    => 'chosen_select_nostd',
							'options'  => wc_get_product_types(),
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Exclude Category', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Select product categories to exclude from sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'multiselect',
							'id'       => 'wcsss_exclude_cat',
							'default'  => '',
							'class'    => 'chosen_select_nostd',
							'options'  => $product_categories_select,
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Include Category', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Select product categories  to include in sale. Only product within this categories will be on sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'multiselect',
							'id'       => 'wcsss_include_cat',
							'default'  => '',
							'class'    => 'chosen_select_nostd',
							'options'  => $product_categories_select,
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Exclude tag', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Select product tag to exclude from sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'multiselect',
							'id'       => 'wcsss_exclude_tag',
							'default'  => '',
							'class'    => 'chosen_select_nostd',
							'options'  => $product_tag_select,
							'desc_tip' => true,
						),
						array(
							'title'    => __( 'Include tag', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Select product tags  to include in sale. Only product within this tags will be on sale.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'multiselect',
							'id'       => 'wcsss_include_tag',
							'default'  => '',
							'class'    => 'chosen_select_nostd',
							'options'  => $product_tag_select,
							'desc_tip' => true,
						),
					array(
						'title'    => __( 'Exclude products', 'simple-storewide-sale-for-woocommerce' ),
						'desc'     => __( 'Select product to exclude from sale.', 'simple-storewide-sale-for-woocommerce' ),
						'type'     => 'ajaxproduct',
						'id'       => 'wcsss_exclude_product',
						'default'  => '',
						'desc_tip' => true,
					),
					array(
						'title'    => __( 'Include products', 'simple-storewide-sale-for-woocommerce' ),
						'desc'     => __( 'Select products to include in sale. Only selsected products will be on sale.', 'simple-storewide-sale-for-woocommerce' ),
						'type'     => 'ajaxproduct',
						'id'       => 'wcsss_include_product',
						'default'  => '',
						'desc_tip' => true,

					),
					array(
						'title'    => __( 'Exclude SKU', 'simple-storewide-sale-for-woocommerce' ),
						'desc'     => __( 'Enter SKU to exclude from sale. Use comma for delimiter.', 'simple-storewide-sale-for-woocommerce' ),
						'type'     => 'text',
						'id'       => 'wcsss_exclude_sku',
						'default'  => '',
						'desc_tip' => true,
						'css'      => 'width:100%;',
					),
					array(
						'title'    => __( 'Include SKU', 'simple-storewide-sale-for-woocommerce' ),
						'desc'     => __( 'Enter SKU to include in sale. Only entered SKU will be on sale. Use comma for delimiter.', 'simple-storewide-sale-for-woocommerce' ),
						'type'     => 'text',
						'id'       => 'wcsss_include_sku',
						'default'  => '',
						'desc_tip' => true,
						'css'      => 'width:100%;',

					),
					array(
						'title'   => __( 'Enable storewide sale notice', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'checkbox',
						'id'      => 'wcsss_notice_enable',
						'default' => 'no',
					),
					array(
						'title'   => __( 'Sale storewide notice', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'textarea',
						'id'      => 'wcsss_notice',
						'default' => '',
						'css'     => 'width:100%',
					),
					array(
						'title'   => __( 'Enable storewide before sale notice', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'checkbox',
						'id'      => 'wcsss_before_notice_enable',
						'default' => 'no',
					),
					array(
						'title'   => __( 'Sale storewide notice befor sale starts', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'textarea',
						'id'      => 'wcsss_notice_before',
						'default' => '',
						'css'     => 'width:100%',
					),
					array(

						'type' => 'hiddenhash',
						'id'   => 'wcsss_hiddenhash',

					),

					array(
						'type' => 'sectionend',
						'id'   => 'simple_lottery_options',
					),

				)
				);
			} else {
				return apply_filters(
					'woocommerce_' . $this->id . '_settings', array(

						array(
							'title' => __( 'Simple Storewide Sale for WooCommerce Options', 'simple-storewide-sale-for-woocommerce' ),
							'type'  => 'title',
							'desc'  => '',
							'id'    => 'simple_lottery_options',
						),

						array(
							'title'    => __( 'Discount enable', 'simple-storewide-sale-for-woocommerce' ),
							'desc'     => __( 'Enable storewide sales.', 'simple-storewide-sale-for-woocommerce' ),
							'type'     => 'checkbox',
							'id'       => 'wcsss_enable',
							'default'  => 'no',
							'desc_tip' => true,
						),
						array(
							'title'   => __( 'Discount amount', 'simple-storewide-sale-for-woocommerce' ),
							'type'    => 'text',
							'id'      => 'wcsss_amount',
							'default' => '',
							'class'   => 'wc_input_price',
							'css'   => 'position:relative'
						),
						array(
							'title'   => __( 'Discount type', 'simple-storewide-sale-for-woocommerce' ),
							'type'    => 'radio',
							'id'      => 'wcsss_type',
							'default' => '',
							'options' => array( '%' ),
						),
						array(
							'title'       => __( 'Sale starts', 'simple-storewide-sale-for-woocommerce' ),
							'id'          => 'wcsss_start',
							'type'        => 'datetimepicker',
							'class'       => 'datetimepicker',
							'placeholder' => __( 'From&hellip; YYYY-MM-DD HH:MM', 'simple-storewide-sale-for-woocommerce' ),
							'default'     => '',
						),
						array(
							'title'       => __( 'Sale ends', 'simple-storewide-sale-for-woocommerce' ),
							'id'          => 'wcsss_end',
							'type'        => 'datetimepicker',
							'class'       => 'datetimepicker',
							'placeholder' => __( 'To&hellip; YYYY-MM-DD HH:MM', 'simple-storewide-sale-for-woocommerce' ),
							'default'     => '',
						),


					array(
						'title'   => __( 'Enable storewide sale notice', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'checkbox',
						'id'      => 'wcsss_notice_enable',
						'default' => 'no',
					),
					array(
						'title'   => __( 'Sale storewide notice', 'simple-storewide-sale-for-woocommerce' ),
						'type'    => 'textarea',
						'id'      => 'wcsss_notice',
						'default' => '',
						'css'     => 'width:100%',
					),

					array(

						'type' => 'hiddenhash',
						'id'   => 'wcsss_hiddenhash',

					),

					array(
						'type' => 'sectionend',
						'id'   => 'simple_lottery_options',
					),

				)
				);

			}// End pages settings
		}

		/**
		 * Save settings.
		 */
		public function save() {
			global $current_section;

			$settings = $this->get_settings();
			WC_Admin_Settings::save_fields( $settings );
			do_action( 'woocommerce_update_options_' . $this->id );

		}
	}
	return new Simple_Storewide_Sale_For_Woocommerce_Settings();

endif;
