<?php
class AdornEdgeYithWishlist extends WP_Widget {
	public function __construct() {
		parent::__construct(
			'edge_woocommerce_yith_wishlist',
			esc_html__('Edge Woocommerce Wishlist', 'adorn'),
			array( 'description' => esc_html__( 'Display a wishlist icon with number of products that are in the wishlist', 'adorn' ), )
		);
	}

    /**
     * @param array $new_instance
     * @param array $old_instance
     *
     * @return array
     */
    public function update($new_instance, $old_instance) {
        $instance = array();
        foreach($this->params as $param) {
            $param_name = $param['name'];

            $instance[$param_name] = sanitize_text_field($new_instance[$param_name]);
        }

        return $instance;
    }

	public function widget( $args, $instance ) {
		extract( $args );
		
		global $yith_wcwl;

		?>
		<div class="edge-wishlist-widget-holder">
            <a href="<?php echo esc_url($yith_wcwl->get_wishlist_url()); ?>" class="edge-wishlist-widget-link">
                <?php /** ---------------- EMMA SPEF --------------------------- */ ?>
				<span class="edge-wishlist-widget-icon"><svg viewBox="0 0 24 24" width="1em" height="1em" class="svg_icons" focusable="false" aria-hidden="false" role="img" data-testid="wishlist"><path d="M17.488 1.11h-.146a6.552 6.552 0 0 0-5.35 2.81A6.57 6.57 0 0 0 6.62 1.116 6.406 6.406 0 0 0 .09 7.428c0 7.672 11.028 15.028 11.497 15.338a.745.745 0 0 0 .826 0c.47-.31 11.496-7.666 11.496-15.351a6.432 6.432 0 0 0-6.42-6.306zM12 21.228C10.018 19.83 1.59 13.525 1.59 7.442c.05-2.68 2.246-4.826 4.934-4.826h.088c2.058-.005 3.93 1.251 4.684 3.155.226.572 1.168.572 1.394 0 .755-1.907 2.677-3.17 4.69-3.16h.02c2.7-.069 4.96 2.118 5.01 4.817 0 6.089-8.429 12.401-10.41 13.8z"></path></svg></span>
				<!--span class="edge-wishlist-widget-icon"><i class="icon_heart_alt"></i></span-->
                <span class="edge-wishlist-items-number">(<span><?php echo yith_wcwl_count_products(); ?></span>)</span>
            </a>
			<?php wp_nonce_field( 'edgtf_product_wishlist_nonce_' . $unique_id, 'edgtf_product_wishlist_nonce_' . $unique_id ); ?>
		</div>
		<?php
	}
}
?>