<?php

/**
 *
 * @link              http://wpgenie.org
 * @since             1.0.0
 * @package           Woocommerce_Simple_Storewide_Sale
 *
 * Plugin Name:       Simple Storewide Sale for WooCommerce
 * Plugin URI:        https://wpgenie.org/woocommerce-simple-storewide-sale/documentation/
 * Description:       Simple Storewide Sale for WooCommerce is a tool which allows shop owner to have sales on all products for events like Black Friday, Christmas, clerance or store anniversary.
 * Version:           1.0.0
 * Author:            wpgenie
 * Author URI:        http://wpgenie.org/
 * Requires at least: 5.0
 *
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       simple-storewide-sale-for-woocommerce
 * Domain Path:       /languages
 * Requires Plugins: woocommerce
 *
 * WC requires at least: 4.0
 * WC tested up to: 10.0
 */
// If this file is called directly, abort.
if ( !defined( 'ABSPATH' ) ) {
    die;
}
if ( function_exists( 'sssfw' ) ) {
    sssfw()->set_basename( false, __FILE__ );
} else {
    /**
     * Create a helper function for easy SDK access.
     */
    function sssfw_fs() {
        global $sssfw_fs;
        if ( !isset( $sssfw_fs ) ) {
            // Include Freemius SDK.
            require_once __DIR__ . '/vendor/freemius/start.php';
            $sssfw_fs = fs_dynamic_init( array(
                'id'               => '18506',
                'slug'             => 'simple-storewide-sale-for-woocommerce',
                'type'             => 'plugin',
                'public_key'       => 'pk_a4d9a444a269fb51ecfbcce526a4f',
                'is_premium'       => false,
                'is_org_compliant' => true,
                'premium_suffix'   => 'Professional',
                'has_addons'       => false,
                'has_paid_plans'   => true,
                'menu'             => array(
                    'slug'           => 'simple-storewide-sale-for-woocommerce',
                    'override_exact' => true,
                    'support'        => true,
                    'parent'         => array(
                        'slug' => 'options-general.php',
                    ),
                ),
                'is_live'          => true,
            ) );
        }
        return $sssfw_fs;
    }

    // Init Freemius.
    sssfw_fs();
    // Signal that SDK was initiated.
    do_action( 'sssfw_fs_loaded' );
    /**
     * Sssfw_fs_settings_url
     *
     * @return string
     */
    function sssfw_fs_settings_url() {
        return admin_url( 'admin.php?page=wc-settings&tab=simple_storewide_sale' );
    }

    sssfw_fs()->add_filter( 'connect_url', 'sssfw_fs_settings_url' );
    sssfw_fs()->add_filter( 'after_skip_url', 'sssfw_fs_settings_url' );
    sssfw_fs()->add_filter( 'after_connect_url', 'sssfw_fs_settings_url' );
    sssfw_fs()->add_filter( 'after_pending_connect_url', 'sssfw_fs_settings_url' );
}
/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-simple-storewide-sale-for-woocommerce.php';
add_action( 'before_woocommerce_init', function () {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_simple_storewide_sale_for_woocommerce() {
    global $sssfw;
    $sssfw = new Simple_Storewide_Sale_For_Woocommerce();
    $sssfw->run();
}

add_action( 'woocommerce_init', 'run_simple_storewide_sale_for_woocommerce' );
add_action( 'before_woocommerce_init', function () {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );