<?php

namespace MailOptin\Core\Admin\Customizer;

use MailOptin\Core\PluginSettings\Settings;

use function MailOptin\Core\_remove_class_action;

trait CustomizerTrait
{
    public function modify_customizer_publish_button()
    {
        add_filter('gettext', function ($translations, $text, $domain) {
            if ($domain == 'default' && $text == 'Publish') {
                $translations = __('Save Changes', 'mailoptin');
            }
            if ($domain == 'default' && $text == 'Published') {
                $translations = __('Saved', 'mailoptin');
            }

            return $translations;
        }, 10, 3);
    }

    /**
     * @param \WP_Customize_Manager $wp_customize
     */
    public function register_custom_section($wp_customize)
    {
        $wp_customize->register_section_type('MailOptin\Core\Admin\Customizer\UpsellCustomizerSection');
    }

    /**
     * Registered customize control as eligible to be rendered via JS and created dynamically.
     *
     * @param \WP_Customize_Manager $wp_customize
     */
    public function register_control_type($wp_customize)
    {
        $controls = apply_filters('mo_optin_registered_control_types', [
            'MailOptin\Core\Admin\Customizer\CustomControls\WP_Customize_Button_Set_Control'
        ]);

        foreach ($controls as $control) {
            $wp_customize->register_control_type($control);
        }

        do_action('mo_customizer_register_control_type', $wp_customize);
    }

    public function is_ninja_form_shortcode()
    {
        if (class_exists('\Ninja_Forms') && class_exists('\NF_Display_Render') && isset($_GET['mailoptin_optin_campaign_id'])) {
            $optin_campaign_id = absint($_GET['mailoptin_optin_campaign_id']);

            return \MailOptin\Core\is_ninja_form_shortcode($optin_campaign_id);
        }

        return false;
    }

    public function clean_up_customizer()
    {
        if (Settings::instance()->switch_customizer_loader() != 'true' && ! $this->is_ninja_form_shortcode()) {

            add_filter('customize_loaded_components', function ($components) {

                $core_components = array('nav_menus'/*, 'widgets'*/);

                if ( ! empty($components)) {
                    foreach ($components as $component_key => $component) {
                        if (in_array($component, $core_components, true)) {
                            unset($components[$component_key]);
                        }
                    }
                }

                return $components;

            }, 99);
        }

        // this should never change from init to say admin_init in future because it will
        // cause wp_enqueue_scripts filter from taking effect cos its used in frontend.
        add_action('init', function () {

            remove_all_actions('admin_print_footer_scripts');

            // remove all custom media button added by plugins and core.
            remove_all_actions('media_buttons');
            remove_all_filters('media_buttons_context');
            remove_all_filters('mce_buttons', 10);
            remove_all_filters('mce_external_plugins', 10);
            remove_all_actions('after_wp_tiny_mce');

            remove_all_actions('wp_head');
            remove_all_actions('wp_print_styles');
            remove_all_actions('wp_print_head_scripts');
            remove_all_actions('wp_footer');

            // Handle `wp_head`
            add_action('wp_head', 'wp_enqueue_scripts', 1);
            add_action('wp_head', 'wp_print_styles', 8);
            add_action('wp_head', 'wp_print_head_scripts', 9);
            add_action('wp_head', 'wp_site_icon');

            add_action('customize_controls_head', function () {
                if ( ! did_action('admin_enqueue_scripts')) {
                    do_action('admin_enqueue_scripts');
                }
            });

            // Handle `wp_footer`
            add_action('wp_footer', 'wp_print_footer_scripts', 20);

            // add core media button back.
            add_action('media_buttons', 'media_buttons');

            if (Settings::instance()->switch_customizer_loader() != 'true' && ! $this->is_ninja_form_shortcode()) {

                $wp_get_theme = wp_get_theme();

                $active_plugins = array_reduce(get_option('active_plugins'), function ($carry, $item) {
                    $name = dirname($item);
                    if ($name != 'mailoptin' && $name != 'wp-jquery-update-test' && $name != '.') {
                        $carry[] = $name;
                    }

                    return $carry;
                });

                $active_plugins = ! is_array($active_plugins) ? [] : $active_plugins;

                add_action('customize_controls_enqueue_scripts', function () use ($wp_get_theme, $active_plugins) {

                    global $wp_styles;
                    global $wp_scripts;

                    $child_theme  = $wp_get_theme->get_stylesheet();
                    $parent_theme = $wp_get_theme->get_template();

                    // important in fixing: Uncaught TypeError: Cannot set property '_value' of undefined
                    // from /wp-admin/js/customize-nav-menus.min.js
                    unset($wp_scripts->registered['customize-nav-menus']);

                    foreach ($wp_scripts->registered as $key => $value) {
                        $src = $value->src;
                        if (strpos($src, "themes/$child_theme/") !== false || strpos($src, "themes/$parent_theme/") !== false) {
                            unset($wp_scripts->registered[$key]);
                        }

                        if (strpos($src, "/uploads/$child_theme/") !== false || strpos($src, "/uploads/$parent_theme/") !== false) {
                            unset($wp_scripts->registered[$key]);
                        }

                        foreach ($active_plugins as $active_plugin) {
                            if (strpos($src, "plugins/$active_plugin/") !== false) {
                                unset($wp_scripts->registered[$key]);
                            }
                        }
                    }

                    foreach ($wp_styles->registered as $key => $value) {
                        $src = $value->src;
                        if (strpos($src, "themes/$child_theme/") !== false || strpos($src, "themes/$parent_theme/") !== false) {
                            unset($wp_styles->registered[$key]);
                        }

                        if (strpos($src, "/uploads/$child_theme/") !== false || strpos($src, "/uploads/$parent_theme/") !== false) {
                            unset($wp_styles->registered[$key]);
                        }

                        foreach ($active_plugins as $active_plugin) {
                            if (strpos($src, "plugins/$active_plugin/") !== false) {
                                unset($wp_styles->registered[$key]);
                            }
                        }
                    }

                }, 9999999999999);

                // was surprised a theme called Awaken used this action to enqueue styles.
                // do not change the priority from 20. that's where it seem to work.
                add_action('customize_controls_print_styles', function () use ($wp_get_theme, $active_plugins) {
                    global $wp_styles;

                    $child_theme  = $wp_get_theme->get_stylesheet();
                    $parent_theme = $wp_get_theme->get_template();

                    foreach ($wp_styles->registered as $key => $value) {
                        $src = $value->src;

                        if (strpos($src, "themes/$child_theme/") !== false || strpos($src, "themes/$parent_theme/") !== false) {
                            unset($wp_styles->registered[$key]);
                        }
                    }

                }, 20);

                remove_all_actions('wp_enqueue_scripts');
            }

            if (class_exists('Astra_Customizer') && method_exists('Astra_Customizer', 'print_footer_scripts')) {
                remove_action('customize_controls_print_footer_scripts', [
                    \Astra_Customizer::get_instance(),
                    'print_footer_scripts'
                ]);
            }

            if (class_exists('Astra_Customizer') && method_exists('Astra_Customizer', 'enqueue_customizer_scripts')) {
                remove_action('customize_controls_enqueue_scripts', [
                    \Astra_Customizer::get_instance(),
                    'enqueue_customizer_scripts'
                ], 999);
            }

            // flatbase theme compat
            add_filter('nice_scripts', '__return_false');

            if (function_exists('td_customize_js')) {
                remove_action('customize_controls_print_footer_scripts', 'td_customize_js');
            }

            if (class_exists('\OceanWP_Customizer')) {
                _remove_class_action('customize_controls_print_footer_scripts', 'OceanWP_Customizer', 'customize_panel_init');
                _remove_class_action('customize_controls_enqueue_scripts', 'OceanWP_Customizer', 'custom_customize_enqueue');
            }

            // compatibility with easy google font plugin
            if (class_exists('EGF_Customize_Manager')) {
                remove_action('customize_controls_enqueue_scripts', [
                    \EGF_Customize_Manager::get_instance(),
                    'easy-google-fonts-customize-controls-js'
                ]);
                remove_action('customize_register', [
                    \EGF_Customize_Manager::get_instance(),
                    'register_font_control_type'
                ]);
            }

            add_action('customize_controls_enqueue_scripts', array($this, 'mo_customizer_js'));

        }, 9999999999999);

        add_action('customize_controls_print_footer_scripts', [$this, 'js_script']);
        add_action('customize_controls_print_footer_scripts', [$this, 'js_wp_editor']);
        add_action('customize_controls_print_footer_scripts', function () {
            if ( ! did_action('admin_print_footer_scripts')) {
                do_action('admin_print_footer_scripts');
            }

        }, 9999);
    }

    public function mo_customizer_js()
    {
        wp_enqueue_script(
            'mailoptin-rename-customizer-title',
            MAILOPTIN_ASSETS_URL . 'js/customizer-controls/rename-customizer-title.js',
            array('jquery', 'customize-controls'),
            MAILOPTIN_VERSION_NUMBER
        );

        wp_enqueue_script(
            'mailoptin-wp-editor',
            MAILOPTIN_ASSETS_URL . 'js/customizer-controls/mo-wp-editor.js',
            array('jquery', 'customize-controls'),
            MAILOPTIN_VERSION_NUMBER
        );

        wp_localize_script('mailoptin-wp-editor', 'moWPEditor_globals', array(
            'url'                      => get_home_url(),
            'includes_url'             => includes_url(),
            'wpeditor_texttab_label'   => __('Text', 'mailoptin'),
            'wpeditor_visualtab_label' => __('Visual', 'mailoptin'),
            'wpeditor_addmedia_label'  => __('Add Media', 'mailoptin')
        ));
    }

    /**
     * Change the label from "Email Provider List" to "Kit (ConvertKit) Form" on convertkit selected as email provider.
     */
    public function js_script()
    {
        $labels = [
            'WordPressUserRegistrationConnect' => __('Select User Role (Required)', 'mailoptin'),
            'SalesforceConnect' => __('Select Salesforce Object', 'mailoptin'),
            'ConvertKitConnect' => __('Select Kit (ConvertKit) Form', 'mailoptin'),
            'BeehiivConnect' => __('Select beehiiv Tier', 'mailoptin'),
            'DripConnect' => __('Select Drip Campaign', 'mailoptin'),
            'ZohoCRMConnect' => __('Select ZohoCRM Module', 'mailoptin'),
            'FacebookCustomAudienceConnect' => __('Select Custom Audience', 'mailoptin'),
            'WebHookConnect' => __('Request Method', 'mailoptin'),
            'GoogleSheetConnect' => __('Select Spreadsheet File', 'mailoptin'),
        ];
        $default_label = __('Select Email List', 'mailoptin');
        ?>
        <script type="text/javascript">
            (function ($) {
                function updateLabel(connection_service, title_obj) {
                    var labels = <?php echo json_encode($labels); ?>;
                    title_obj.text(labels[connection_service] || '<?php echo $default_label; ?>');
                }

                function logic(connection_service) {
                    if (!connection_service) {
                        connection_service = $("select[data-customize-setting-link*='connection_service']").val();
                    }
                    updateLabel(connection_service, $('li[id*="connection_email_list"] .customize-control-title'));
                }

                function logic_new(connection_service, parent) {
                    $('.mo-integration-widget').each(function () {
                        var container = parent || $(this);
                        var service = connection_service || $("select[name='connection_service']", container).val();
                        updateLabel(service, $(".connection_email_list label.customize-control-title", container));
                    });
                }

                $(window).on('load', function () {
                    logic();
                    logic_new();
                    $(document.body).on('mo_email_list_data_found', function (e, connection_service) {
                        $('li[id*="connection_email_list"] .customize-control-title').text('<?php echo $default_label; ?>');
                        logic(connection_service);
                    });
                    $(document.body).on('mo_new_email_list_data_found', function (e, connection_service, parent) {
                        $(".connection_email_list label.customize-control-title", parent).text('<?php echo $default_label; ?>');
                        logic_new(connection_service, parent);
                    });
                });
            })(jQuery);
        </script>
        <?php
    }

    public function js_wp_editor()
    {
        // Enable rich editing for this view (Overrides 'Disable the visual editor when writing' option for current user)
        add_filter('user_can_richedit', '__return_true');
        wp_enqueue_editor();

        if ( ! empty($GLOBALS['post'])) {
            wp_enqueue_media(array('post' => $GLOBALS['post']->ID));
        } else {
            wp_enqueue_media();
        }
    }
}