<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://wpgenie.org
 * @since      1.0.0
 *
 * @package    Woocommerce_Simple_Storewide_Sale
 * @subpackage Woocommerce_Simple_Storewide_Sale/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Woocommerce_onsale_page
 * @subpackage Woocommerce_onsale_page/admin
 */
class Simple_Storewide_Sale_For_Woocommerce_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param string $plugin_name The name of this plugin.
	 * @param string $version The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wc-simple-storewide-sale-admin.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area
	 *
	 * @param  mixed $hook hook.
	 * @return void
	 */
	public function enqueue_scripts( $hook ) {

		if ( 'woocommerce_page_wc-settings' === $hook ) {
			wp_register_script(
				$this->plugin_name,
				plugin_dir_url( __FILE__ ) . 'js/wc-simple-storewide-sale-admin.js',
				array( 'jquery', 'jquery-ui-core', 'jquery-ui-datepicker', 'timepicker-addon' ),
				$this->version,
				false
			);

			wp_localize_script( $this->plugin_name, 'wccsss', array( 'calendar_image' => WC()->plugin_url() . '/assets/images/calendar.png' ) );
			wp_enqueue_script( $this->plugin_name );

			wp_enqueue_script(
				'timepicker-addon',
				plugin_dir_url( __FILE__ ) . '/js/jquery-ui-timepicker-addon.js',
				array( 'jquery', 'jquery-ui-core', 'jquery-ui-datepicker' ),
				$this->version,
				true
			);

			wp_enqueue_style( 'jquery-ui-datepicker' );
		}
	}

	/**
	 * Add support link
	 *
	 * @param  mixed $links lniks.
	 * @param  mixed $file fiel.
	 * @return array
	 */
	public function add_support_link( $links, $file ) {
		if ( ! current_user_can( 'install_plugins' ) ) {
			return $links;
		}

		if ( 'woocommerce-simple-storewide-sale/woocommerce-simple-storewide-sale.php' === $file ) {
			$links[] = '<a href="http://wpgenie.org/woocommerce-simple-storewide-sale/documentation/" target="_blank">' . __( 'Docs', 'simple-storewide-sale-for-woocommerce' ) . '</a>';
			$links[] = '<a href="http://codecanyon.net/user/wpgenie#contact" target="_blank">' . __( 'Support', 'simple-storewide-sale-for-woocommerce' ) . '</a>';
			$links[] = '<a href="http://codecanyon.net/user/wpgenie/" target="_blank">' . __( 'More WooCommerce Extensions', 'simple-storewide-sale-for-woocommerce' ) . '</a>';
		}
		return $links;
	}

	/**
	 * Add settings tab to Woocommerce settings page
	 *
	 * @since    1.0.0
	 *
	 */
	function settings_class( $settings ) {

		$settings[] = include plugin_dir_path( __DIR__ ) . 'admin/class-simple-storewide-sale-for-woocommerce-settings.php';
		return $settings;
	}

	/**
	 * Add datepicker element to settings tab
	 *
	 * @since    1.0.0
	 *
	 */
	function datetimepicker( $value ) {

		?>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?></label>
			</th>
			<td class="formin">
				<input type="text"
					name="<?php echo esc_attr( $value['id'] ); ?>"
					id="<?php echo esc_attr( $value['id'] ); ?>"
					type="<?php echo esc_attr( $value['type'] ); ?>"
					style="<?php echo esc_attr( $value['css'] ); ?>"
					value="<?php echo esc_attr( WC_Admin_Settings::get_option( $value['id'], $value['default'] ) ); ?>"
					class="<?php echo esc_attr( $value['class'] ); ?>"
					placeholder="<?php echo esc_attr( $value['placeholder'] ); ?>"
					maxlength="16" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])[ ](0[0-9]|1[0-9]|2[0-4]):(0[0-9]|1[0-9]|2[0-9]|3[0-9]|4[0-9]|5[0-9])" />
			</td>
		</tr>
		<?php
	}

	/**
	 * Add ajax product select to settings tab
	 *
	 * @since    1.0.0
	 *
	 */
	function ajaxproduct( $value ) {
		global $post;
		$field_description = WC_Admin_Settings::get_field_description( $value );
		extract( $field_description );
		$get_option  = WC_Admin_Settings::get_option( $value['id'], $value['default'] );
		$optionarray = is_array( $get_option ) ? $get_option : explode( ',', $get_option );
		$product_ids = array_filter( array_map( 'absint', $optionarray ) );

		$json_ids = array();

		foreach ( $product_ids as $product_id ) {
			$product = wc_get_product( $product_id );
			if ( is_object( $product ) ) {
				$json_ids[ $product_id ] = wp_kses_post( html_entity_decode( $product->get_formatted_name(), ENT_QUOTES, get_bloginfo( 'charset' ) ) );
			}
		}
		?>
		<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo esc_html( $value['title'] ); ?></label>
					<?php echo wp_kses_post( $tooltip_html ); ?>
				</th>
				<td class="formin">
		<?php
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			?>

				<input type="hidden"
					class="wc-product-search "
					id="<?php echo esc_attr( $value['id'] ); ?>"
					name="<?php echo esc_attr( $value['id'] ); ?>"
					data-placeholder="<?php esc_attr_e( 'Search for a product&hellip;', 'simple-storewide-sale-for-woocommerce' ); ?>"
					data-action="woocommerce_json_search_products"
					data-multiple="true"
					data-selected="
					<?php

							echo esc_attr( json_encode( $json_ids ) );
					?>
					"

					value="<?php echo esc_attr( implode( ',', array_keys( $json_ids ) ) ); ?>" />

			<?php
		} else {
			?>

			<select class="wc-product-search" multiple="multiple" style="width: 50%;" id="<?php echo esc_attr( $value['id'] ); ?>" name="<?php echo esc_attr( $value['id'] ); ?>[]" data-placeholder="<?php esc_attr_e( 'Search for a product&hellip;', 'simple-storewide-sale-for-woocommerce' ); ?>" data-action="woocommerce_json_search_products_and_variations" data-exclude="" >
					<?php

					foreach ( $product_ids as $product_id ) {
						$product = wc_get_product( $product_id );
						if ( is_object( $product ) ) {
							echo '<option value="' . esc_attr( $product_id ) . '"' . selected( true, true, false ) . '>' . wp_kses_post( $product->get_formatted_name() ) . '</option>';
						}
					}
					?>
					</select>
				<?php } ?>
		</td>
			</tr>

		<?php
	}

	/**
	 * Add datepicker element to settings tab
	 *
	 * @since    1.0.0
	 *
	 */
	function hiddenhash( $value ) {

		?>

				<input type="hidden"
					name="<?php echo esc_attr( $value['id'] ); ?>"
					id="<?php echo esc_attr( $value['id'] ); ?>"

					value="<?php echo esc_attr( md5( microtime() ) ); ?>"
				/>
		<?php
	}

	function sanitize_ajaxproduct_option( $value, $option, $raw_value ) {
		if ( $option['type'] == 'ajaxproduct' ) {
				$value = array_filter( array_map( 'wc_clean', (array) $raw_value ) );
		}
		return $value;

	}
}
