<?php
	$attachment_meta = adorn_edge_get_attachment_meta_from_url($logo_image);
	$hwstring = !empty($attachment_meta) ? image_hwstring( $attachment_meta['width'], $attachment_meta['height'] ) : '';

	if(!empty($logo_image_dark)) {
		$attachment_meta_dark = adorn_edge_get_attachment_meta_from_url($logo_image_dark);
		$hwstring_dark = !empty($attachment_meta_dark) ? image_hwstring($attachment_meta_dark['width'], $attachment_meta_dark['height']) : '';
	}

	if(!empty($logo_image_light)) {
		$attachment_meta_light = adorn_edge_get_attachment_meta_from_url( $logo_image_light );
		$hwstring_light = !empty($attachment_meta_light) ? image_hwstring($attachment_meta_light['width'], $attachment_meta_light['height']) : '';
	}
?>

<?php do_action('adorn_edge_before_site_logo'); ?>

<?php /** --------------------- EMMA SPEF -----------------------------------------
<div class="edge-logo-wrapper">
    <a itemprop="url" href="<?php echo esc_url(home_url('/')); ?>" <?php adorn_edge_inline_style($logo_styles); ?>>
        <img itemprop="image" class="edge-normal-logo" src="<?php echo esc_url($logo_image); ?>" <?php echo wp_kses($hwstring, array('width' => true, 'height' => true)); ?> alt="<?php esc_attr_e('logo','adorn'); ?>"/>
        <?php if(!empty($logo_image_dark)){ ?><img itemprop="image" class="edge-dark-logo" src="<?php echo esc_url($logo_image_dark); ?>" <?php echo wp_kses($hwstring_dark, array('width' => true, 'height' => true)); ?> alt="<?php esc_attr_e('dark logo','adorn'); ?>"/><?php } ?>
        <?php if(!empty($logo_image_light)){ ?><img itemprop="image" class="edge-light-logo" src="<?php echo esc_url($logo_image_light); ?>" <?php echo wp_kses($hwstring_light, array('width' => true, 'height' => true)); ?> alt="<?php esc_attr_e('light logo','adorn'); ?>"/><?php } ?>
    </a>
</div> */ ?>

<?php if(ICL_LANGUAGE_CODE == "fr"){ ?>	
<div class="edge-logo-wrapper">
    <a itemprop="url" href="<?php echo esc_url(home_url('/')); ?>" <?php adorn_edge_inline_style($logo_styles); ?> title="Sellerie haut-de-gamme made in France | Marpezia">
        <img itemprop="image" class="edge-normal-logo" src="/wp-content/uploads/2023/05/logo_marpezia_le_cheval_comme_art_de_vivre.jpg" alt="Sellerie haut-de-gamme made in France | Marpezia" title="Sellerie haut-de-gamme made in France | Marpezia" decoding="async" loading="lazy"/>
    </a>
</div>
<?php }else{ ?>	
 <div class="edge-logo-wrapper">
    <a itemprop="url" href="<?php echo esc_url(home_url('/')); ?>" <?php adorn_edge_inline_style($logo_styles); ?> title="Sellerie haut-de-gamme made in France | Marpezia">
        <img itemprop="image" class="edge-normal-logo" src="/wp-content/uploads/2023/05/logo_marpezia_le_cheval_comme_art_de_vivre.jpg" alt="Sellerie haut-de-gamme made in France | Marpezia" title="Sellerie haut-de-gamme made in France | Marpezia" decoding="async" loading="lazy"/>
    </a>
</div>
<?php } ?>	

<?php do_action('adorn_edge_after_site_logo'); ?>